/**
 * Copyright kotobuki ( http://wonderfl.net/user/kotobuki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hyP5
 */

// forked from kotobuki's FIO Basic Example: SignalScope
// forked from kotobuki's Gainer Basic Example: SignalScope
// A basic accelerometer example for FIO modules
// 
// Reference
// http://funnel.cc/Software/ActionScript3
// http://funnel.cc/Hardware/FIO

package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.text.*
    
    import funnel.*;
    import funnel.gui.*;

    [SWF(backgroundColor="0x808080")]

    public class GainerTest extends Sprite {
        private const NUM_CHANNELS:int = 3;

        private var fioSystem:Fio;
        private var fio:IOModule;
        private var scopes:Array;
        private var textField:TextField;

        public function GainerTest() {
            var config:Configuration = Fio.FIRMATA;

            // set unused analog pins output to improve performance
            config.setDigitalPinMode(17, OUT);
            config.setDigitalPinMode(18, OUT);
            config.setDigitalPinMode(19, OUT);
            config.setDigitalPinMode(20, OUT);
            config.setDigitalPinMode(21, OUT);
            fioSystem = new Fio([1], config);
            fio = fioSystem.ioModule(1);

            scopes = new Array(NUM_CHANNELS);
            for (var i:int = 0; i < NUM_CHANNELS; i++) {
                scopes[i] = new SignalScope(0, 0 + (53 * i), 200, "A" + i, 0, 2);
                addChild(scopes[i]);
            }

            fio.analogPin(0).addFilter(new SetPoint([[0.4, 0.05], [0.6, 0.05]]));
            fio.analogPin(1).addFilter(new SetPoint([[0.4, 0.05], [0.6, 0.05]]));
            fio.analogPin(2).addFilter(new SetPoint([[0.4, 0.05], [0.6, 0.05]]));

            fio.analogPin(0).addEventListener(CHANGE, onChange);
            fio.analogPin(1).addEventListener(CHANGE, onChange);
            fio.analogPin(2).addEventListener(CHANGE, onChange);

            textField = new TextField();
            textField.y = 350;
            addChild(textField);
            
            addEventListener(Event.ENTER_FRAME, loop);
        }

        private function loop(event:Event):void {
            for (var i:int = 0; i < NUM_CHANNELS; i++) {
                scopes[i].update(fio.analogPin(i));
            }
        }

        private function onChange(event:Event):void {
            if ((fio.analogPin(2).value == 2) && (fio.analogPin(0).value == 1) && (fio.analogPin(1).value == 1)) {
                textField.text = "上向き水平";
            } else if ((fio.analogPin(2).value == 0) && (fio.analogPin(0).value == 1) && (fio.analogPin(1).value == 1)) {
                textField.text = "下向き水平";
            } else {
                textField.text = "";
            }
        }
    }
}
