/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hxtc
 */

// Flash 10 で被写界深度ネタ Z-sortつき
package{
    
    import flash.display.Sprite;
    import flash.utils.getTimer;
    import flash.geom.Matrix3D;
    import flash.geom.Point;
    import flash.geom.PerspectiveProjection;    
    import flash.net.URLRequest;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import flash.net.navigateToURL;
    import flash.filters.DropShadowFilter;
    import flash.display.BitmapData;
    import flash.geom.Matrix;
    
    [SWF(width="465", height="465", frameRate="30", backgroundColor="0xFFFFFF")]
    public class Test extends Sprite {
        private var loadFiles_array:Array;
        private var data_xml:XML;
        private var loadNum:int;
        private var loadCompNum:int;
        private var text_tf:TextField = new TextField();
        private var titleText_array:Array = new Array();
        private var url_array:Array = new Array();
        private var MultiLoader:MultiLoaderClass = new MultiLoaderClass("http://mztm.jp/crossdomain.xml");
        public function Test():void {
            //xmlの読み込み
            loadFiles_array = MultiLoader.setLoad(["http://mztm.jp/wonderfl/3d/arss/data.xml"],onXMLComp);
        }
        private function onXMLComp():void{
            var jpg_array:Array = new Array();
            data_xml = XML(loadFiles_array[0].data);
            var _length:int = data_xml.items.item.length();
            for (var i:int = 10; i < 75; i++) {
                if(data_xml.items.item[i].jpg != ""){
                    
                    var _array:Array = String(data_xml.items.item[i].jpg).split('/');
                    var jpg_url:String = "http://mztm.jp/wonderfl/3d/arss/revolution/"+_array.pop();
                    jpg_url = jpg_url.replace(/%/g,'')
                    jpg_array.push(jpg_url);
                    titleText_array.push(data_xml.items.item[i].title +"\r￥"+ data_xml.items.item[i].price);
                    url_array.push(data_xml.items.item[i].url);
                }
            }
            loadFiles_array = new Array();
            loadFiles_array = MultiLoader.setLoad(jpg_array,Main2);
        }
        public function Main2():void {
            var main :Sprite = Sprite(addChild(new Sprite()));
            main.x = stage.stageWidth / 2;
            main.y = stage.stageHeight / 2;
            
            var wrap :Sprite = Sprite(main.addChild(new Sprite()));
            var perspectiveProjection:PerspectiveProjection = root.transform.perspectiveProjection; 
            perspectiveProjection.projectionCenter = new Point(stage.stageWidth / 2,stage.stageHeight / 2 - 100);
            wrap.z = 800;
            var objs:Array = [];
            
            for(var i:int=0; i<50; i++)
            {
                var sp: Sprite = Sprite(wrap.addChild(new Sprite()));
                if(loadFiles_array[i]){
                    var bmp_data : BitmapData = new BitmapData(150,150 , false , 0xFF1111);
                    bmp_data.draw(loadFiles_array[i]);
                    sp.graphics.beginBitmapFill(bmp_data,new Matrix(1,0,0,1,75,75));
                }else{
                    sp.graphics.beginFill(0,1);
                }
                sp.graphics.drawRect(-75, -75, 150, 150);
                sp.x = 800 * Math.sin( i * 360 / 50 * Math.PI / 180);
                sp.z = 800 * Math.cos( i * 360 / 50 * Math.PI / 180);
                sp.buttonMode = true;
                sp.name = i+"__";
                objs.push(sp)
            }
            
            var ele:Sprite
            text_tf.y = stage.stageHeight - 55;
            text_tf.width = stage.stageWidth;
            text_tf.multiline = text_tf.wordWrap = true;
            
            addChild(text_tf); 
            
            
            var wrap_rotation:Number = 0;
            stage.addEventListener(MouseEvent.CLICK,onClick)
            function onClick(e:MouseEvent):void{
                var _array:Array = getHighestDepthObjectUnderPoint(stage);
                if(_array[0] > -1){
                    navigateToURL(new URLRequest(url_array[int(_array[0])]),"_blank");
                }
            }
            stage.addEventListener(Event.ENTER_FRAME, function(e:Event):void
            {
                
                wrap_rotation += Math.max(Math.min((mouseX - (stage.stageWidth/2)),stage.stageWidth/2),-stage.stageWidth/2) * 0.001;
                wrap_rotation = (360 +wrap_rotation)%360;
                wrap.rotationY = wrap_rotation;
                var _length:int = objs.length;
                var focus:int = Math.floor((_length + 0.5 + _length/2 - wrap_rotation/(360/_length))%_length);
                
                var _array:Array = getHighestDepthObjectUnderPoint(stage);
                if(_array[0] > -1){
                    focus = int(_array[0]);
                }
                
                text_tf.text = "\r"+titleText_array[focus];
                var z_array:Array = [];
                var arr:Array = [];
                
                for (var i:int=0; i<_length; i++) {
                    
                    if(i == focus){
                        if((wrap.rotationY+i*(360/_length))%360 < 180){
                            objs[i].rotationY = (i*(360/_length)-180)*0.07 + objs[i].rotationY*0.93;
                        }else{
                            objs[i].rotationY = (i*(360/_length)-180)*0.07 + objs[i].rotationY*0.93;
                        }
                    }else if(Math.abs(i - focus) < 4 || Math.abs(i+_length - focus) < 4){
                        if((wrap.rotationY+i*(360/_length))%360 < 180){
                            objs[i].rotationY = (i*(360/_length)-90)*0.1 + objs[i].rotationY*0.9;
                        }else{
                            objs[i].rotationY = (i*(360/_length)-270)*0.1 + objs[i].rotationY*0.9;
                        }
                    }else{
                        if((wrap.rotationY+i*(360/_length))%360 < 180){
                            objs[i].rotationY = i*(360/_length)-90;
                        }else{
                            objs[i].rotationY = i*(360/_length)-270;
                        }
                    }
                    
                    var mtx:Matrix3D = objs[i].transform.getRelativeMatrix3D(main);
                    z_array[i] = mtx.position.z;
                }
                z_array = z_array.sort(Array.NUMERIC | Array.RETURNINDEXEDARRAY);
                var arr_length:int = z_array.length;
                for (i=0; i<arr_length; i++) {
                    wrap.setChildIndex(objs[z_array[i]],0)
                    objs[i].filters = (i == focus) ? [new DropShadowFilter(0,0,0xFF3333,1,16,16)] : []
                }
            })
        }
        
        //マウス位置の一番手前のオブジェクトの名前を取得
        public function getHighestDepthObjectUnderPoint(_naviStage:Object):Array{
            var pt:Point = new Point(_naviStage.mouseX , _naviStage.mouseY);
            var list:Array = _naviStage.getObjectsUnderPoint(_naviStage.localToGlobal(pt));
            var l:int = list.length;
            var _array:Array = new Array();    
            if(l > 0){
                //上から順にnameを確認
                for (var i:int = 0; i<l; i++) {
                    var str:String = list[l-1-i].name;
                    _array = str.split("__");
                    //trace(_array,str)
                    if(_array.length == 2){break};
                    //該当無しの場合、-1を返す。
                    _array = [-1,-1];
                }
            };
            return _array;
        }
        
    }
}



class MultiLoaderClass{
    import flash.system.Security;
    import flash.net.URLRequest;
    import flash.net.URLLoader;
    import flash.events.Event;
    import flash.events.IOErrorEvent;
    import flash.display.Loader;
    //import flash.display.LoaderInfo;

    private var onComplete:Function = function():void{};
    private var loadNum:int;
    private var loadCompNum:int;

    public function MultiLoaderClass(_str:String = null){
        if(_str != null){
            Security.loadPolicyFile(_str);
        }
    }

    public function setLoad(__item_array:Array,_onComp:Function = null):Array{
        loadCompNum = loadNum = 0;
        onComplete = _onComp;
        var _array:Array = new Array();
        var _length:int = __item_array.length;
        for (var i:int = 0; i < _length; i++) {
            if(__item_array[i] == null){continue};
            var _extension:String = __item_array[i].substr(-4,4).toLowerCase();//拡張子を取り出す。
            if(_extension == ".xml"){
                loadNum ++;
                _array[i] = fnURLLoader(__item_array[i]);
            }else if(_extension == ".jpg" || _extension == ".png" || _extension == ".gif"){
                loadNum ++;
                _array[i] = fnLoader(__item_array[i]);
            }else{
                //_array[i] = null;
            }
        }
        return _array;
    }
    private function fnURLLoader(__url:String):URLLoader{
        var _loader : URLLoader = new URLLoader();
        _loader.load(new URLRequest(__url));
        _loader.addEventListener (Event.COMPLETE,completeHandler);
        _loader.addEventListener (IOErrorEvent.IO_ERROR, ioErrorHandler);
        return _loader;
    }

    private function fnLoader(__url:String):Loader{
        var _loader:Loader = new Loader();
        _loader.contentLoaderInfo.addEventListener(Event.COMPLETE, completeHandler);
        _loader.contentLoaderInfo.addEventListener(IOErrorEvent.IO_ERROR, ioErrorHandler);
        _loader.load(new URLRequest(__url));
        //_loader.name = __url;
        return _loader;
    }

    private function completeHandler(event:Event = null):void {
        loadCompNum ++;
        if(loadCompNum == loadNum){
            onComplete();
        }
        //var loaderInfo:LoaderInfo=event.currentTarget as LoaderInfo;
        //var loader:Loader=loaderInfo.loader;
        //addChild(loader);
    }

    private function ioErrorHandler(event:IOErrorEvent):void {
        //event.text = "Error #2035: URL が見つかりません。 URL: file:///~~~~~";
        //event.text = "Error #2036: 読み込みが未完了です。 URL: http://~~~~~";
        //から、URLのみを取り出す。
        //trace(String(event.text).substr(String(event.text).indexOf(" URL: ")+6),"*****");
        completeHandler();
    }
}
