/**
 * Copyright SquirrelKing ( http://wonderfl.net/user/SquirrelKing )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hxEU
 */

// forked from nulldesign's UnyoUnyo
package
{
    import flash.display.*;
    import flash.events.*;
    import flash.utils.*;
    import flash.geom.*;
    import flash.filters.GlowFilter;
    import flash.ui.Mouse;
    
    /*
        lineToで書いてみました。@nulldesign
    */
    
    [SWF(width="465", height="465", backgroundColor="0x0F1854") ]
    
    public class UnyoUnyo extends Sprite
    {
        //全体のうにょにょの数
        private const AllNums:uint = 1;
        
        //うにょうにょの関節の数
        private const SECTION:uint = 11;
        
        //うにょうにょブッコミ配列
        private var sectionList:Array = [];
        
        public function UnyoUnyo():void
        {
            addEventListener( Event.ADDED_TO_STAGE, initialize );
        }
        private function initialize( e:Event ):void
        {
            Mouse.hide();
            
            removeEventListener( Event.ADDED_TO_STAGE, initialize );
            
            //全体にフィルターかける。重たかったらはずしてもよいかもしれませｎ
            var _filter:GlowFilter = new GlowFilter( 0x000000, 1, 12, 12, 2, 1, false, false );
            this.filters = [ _filter ];
            
            //うにょうにょの生成
            var _w:Number = stage.stageWidth;
            var _h:Number = stage.stageHeight ;
            for( var z:uint = 0; z < AllNums; z++ )
            {
                var _px:Number = Math.random() * _w;
                var _py:Number = Math.random() * _h;
                var _list:Array = [];
                for( var i:uint = 0; i < SECTION; i++ )
                {
                    var _sec:SectionData = new SectionData( _px, _py );
                    _list.push( _sec );
                }
                sectionList.push( _list );
            }
            
            //動きます
            addEventListener( Event.ENTER_FRAME, loop );
        }
        
        private function loop( e:Event ):void
        {
            var _w:Number = stage.stageWidth;
            var _h:Number = stage.stageHeight;
            
            // Change for Tail length
            var delayVal:Number = .7;
            
            //画面を一度きれいにしてから描画
            this.graphics.clear();
            
            var r:Number;
            var g:Number;
            var b:Number;
            
            for( var z:uint = 0; z < AllNums; z++ )
            {
                var _list:Array = sectionList[z];
            
                var _sec:SectionData = _list[0] as SectionData;
                var _secP:SectionData;
                
                _sec.x = mouseX;
                _sec.y = mouseY;
                
                //座標関係の調整
                if( _sec.x <= 0 )
                {
                    _sec.x = 0;
                    _sec.vx *= -.96;
                };
                if( _sec.x > _w )
                {
                    _sec.x = _w;
                    _sec.vx *= -.96;
                };
                if( _sec.y <= 0 )
                {
                    _sec.y = 0;
                    _sec.vy *= -.96;
                };
                if( _sec.y > _h )
                {
                    _sec.y = _h;
                    _sec.vy *= -.96;
                };
                
                
                //うにょうにょの頭だけ力場で動かして、後ろからついてくるボディ（？）は頭についていくイメージです。
                this.graphics.moveTo( _sec.x, _sec.y );
                this.graphics.lineStyle( 12, 0x000000 );
                for( var i:uint = 1; i < SECTION; i++ )
                {
                    _sec = _list[i] as SectionData;
                    _secP = _list[i-1] as SectionData;
                    _sec.x += ( _secP.x - _sec.x ) * delayVal;
                    _sec.y += ( _secP.y - _sec.y ) * delayVal;
                    
                }
                
                //描画
                for( i = 0; i < SECTION; i++ )
                {
                    _sec = _list[i] as SectionData;
                    this.graphics.lineStyle( ( SECTION - i ) * .75, 0x999999 );
                    this.graphics.lineTo( _sec.x, _sec.y );
                }
            }
        }
    }
}

class SectionData
{
    public var x:Number;
    public var y:Number;
    public var vx:Number = 0;
    public var vy:Number = 0;
    public var ax:Number = 0;
    public var ay:Number = 0;
    
    public function SectionData( _x:Number = 0, _y:Number = 0 ):void
    {
        this.x = _x;
        this.y = _y;
    }
}