/**
 * Copyright smallflowergame ( http://wonderfl.net/user/smallflowergame )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hvj7
 */

// forked from hacker_6b5pgq24's forked from: forked from: nengafl
// forked from uwi's forked from: nengafl
package {
    import org.papervision3d.view.BasicView;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.core.math.*;
    import org.papervision3d.core.geom.*;
    import org.papervision3d.core.geom.renderables.*;
    import org.papervision3d.materials.special.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.core.utils.Mouse3D;
    import flash.text.TextField;
    import flash.events.Event;
    import net.hires.debug.Stats;
    
    [SWF(backgroundColor="0xffffff", frameRate="120")]
    public class PV3D extends BasicView {
        private var _tf : TextField;
        private var _sp : Sphere;
        private var _particles : Particles;
        private var _edges : Lines3D;
        private const N : uint = 1;
        private const R : Number = 100;
        
        private var _vs : Array;
        
        public function PV3D() {
            super(0, 0, true, true);
            
            _tf = new TextField();
//            _tf.textColor = 0xffffff;
            _tf.width = 100;
            _tf.height = 465;
            addChild(_tf);
            
//            _sp = new Sphere(new ColorMaterial(0x0000ff, 0.2), R, 20, 20);
            _sp = new Sphere(new WireframeMaterial(0x0000ff, 0.2), R, 20, 20);
            scene.addChild(_sp);
            
            var pm : ParticleMaterial = new ParticleMaterial(0xff0000, 0.7, ParticleMaterial.SHAPE_CIRCLE);
            _particles = new Particles("Forced Points");
            _particles.addParticle(new Particle(pm, 10, R, 0, 0));
            var i : uint, j : uint;
            for(i = 1;i < N;i++){
                var theta : Number = Math.random() * 2 * 3.14;
                var phi : Number = Math.random() * 3.14;
                _particles.addParticle(new Particle(
                    pm, 10,
                    R * Math.cos(phi) * Math.cos(theta),
                    R * Math.cos(phi) * Math.sin(theta),
                    R * Math.sin(phi)
                    ));
            }
            scene.addChild(_particles);
            
            var lm : LineMaterial = new LineMaterial(0x000000, 0.3);
            _edges = new Lines3D(lm, "Edges");
            for(i = 0;i < N;i++){
                for(j = i+1;j < N;j++){
                    _edges.addNewLine(2, 0, 0, 0, 0, 0, 0);
                }
            }
            scene.addChild(_edges);
            updateEdges();
            
            camera.z = -200;
            camera.lookAt(_sp);
            
            _vs = [];
            for(i = 0;i < N;i++){
                _vs.push(new Number3D(0, 0, 0));
            }
            
//            addChild(new Stats());

            startRendering();
            
        }
        
        private function updateEdges() : void
        {
            var p : uint = 0;
            for(var i : uint = 0;i < N;i++){
                for(var j : uint = i + 1;j < N;j++){
                    _edges.lines[p].v0.x = _particles.particles[i].x;
                    _edges.lines[p].v0.y = _particles.particles[i].y;
                    _edges.lines[p].v0.z = _particles.particles[i].z;
                    _edges.lines[p].v1.x = _particles.particles[j].x;
                    _edges.lines[p].v1.y = _particles.particles[j].y;
                    _edges.lines[p].v1.z = _particles.particles[j].z;
                    p++;
                }
            }
        }
        
        override protected function onRenderTick(e : Event = null) : void
        {
            var fs : Array = [];
            var i : uint, j : uint;
            for(i = 0;i < N;i++){
                fs.push(new Number3D(0, 0, 0));
            }
            
            for(i = 0;i < N;i++){ 
                var xi : Number3D = _particles.particles[i].vertex3D.toNumber3D();
                for(j = i+1;j < N;j++){
                    var xj : Number3D = _particles.particles[j].vertex3D.toNumber3D();
                    var sub : Number3D = Number3D.sub(xj, xi);
                    sub.multiplyEq(10000000.0 / (sub.modulo * sub.modulo * sub.modulo));
                    fs[j].plusEq(sub);
                    fs[i].minusEq(sub);
                }
            }
            
                _tf.text = "";
            for(i = 1;i < N;i++){
                _vs[i].plusEq(fs[i]);
//                _vs[i].multiplyEq(0.999);
                var x : Number3D = _particles.particles[i].vertex3D.toNumber3D();
                x.plusEq(_vs[i]);
                x.normalize();
                _particles.particles[i].x = x.x * R;
                _particles.particles[i].y = x.y * R;
                _particles.particles[i].z = x.z * R;
                
                tr(x);
            }
            updateEdges();
            
            super.onRenderTick(e);
        }
        
        private function tr(...o : Array) : void
        {
            _tf.appendText(o + "\n");
            _tf.scrollV = _tf.maxScrollV;
        }
    }
}