/**
 * Copyright Aksor.Al ( http://wonderfl.net/user/Aksor.Al )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hvTs
 */

// forked from takishiki's forked from: Sound Spectrum Ring
// forked from takishiki's Sound Spectrum Ring
/*
 * sound spectrum
 * サウンドスペクトル表示
 * 
 * ♪使用音楽素材について♪
 * 音楽素材/魔王魂（http://maoudamashii.jokersounds.com/）の素材を使わせていただきました。
 * ありがとうございます。
 * 
 */

package 
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.display.Graphics;
    import flash.geom.Point;
    import flash.system.Security;
    import flash.media.Sound;
    import flash.media.SoundChannel;
    import flash.media.SoundLoaderContext;
    import flash.media.SoundTransform;
    import flash.media.SoundMixer;
    import flash.net.URLRequest;
    import flash.utils.ByteArray;
    
    
    [SWF(width = 465, height = 465, frameRate = 30, backgroundColor = 0x000000)]
    public class Main extends Sprite
    {
        // 定数
        private const FFT_MODE    :Boolean = false;
        private const COLOR        :Array = [0xFF0000, 0xFFFF00];
        // 変数
        private var _sp            :Sprite;
        
        // constructor
        public function Main():void {
            stage.frameRate = 30;
            
            _sp = new Sprite();
            _sp.x = stage.stageWidth / 2;
            _sp.y = stage.stageHeight / 2;
            this.addChild(_sp);
            
            // mp3
            var snd:Sound = new Sound();
            Security.loadPolicyFile("http://mutast.heteml.jp/crossdomain.xml");
            var req:URLRequest = new URLRequest("http://vaindog.raindrop.jp/wonderfl/sound/bgm_maoudamashii_cyber06.mp3");
            var context:SoundLoaderContext = new SoundLoaderContext(10, true);
            snd.load(req, context);
            
            var channel:SoundChannel = snd.play();
            var transform:SoundTransform = new SoundTransform();
            transform.volume = 0.5;    // ボリュームを半分に
            transform.pan = 0.0;    // パンは中央
            channel.soundTransform = transform;
            // 再生終了時
            channel.addEventListener(Event.SOUND_COMPLETE, onPlaybackComplete);
            
            // フレーム処理
            this.addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        // 再生終了時
        private function onPlaybackComplete(event:Event):void {
            this.removeEventListener(Event.ENTER_FRAME, onEnterFrame);
            _sp.graphics.clear();
        }
        
        // フレーム処理
        private function onEnterFrame(event:Event):void {
            var bytes:ByteArray = new ByteArray();
            const CHANNEL_LENGTH:int = 256;
            const R:int = 200;
            const OFFSET:int = 100;
            
            var i:int;
            var index:uint;
            var n:Number;
            var rad:Number;
            var point:Point = new Point();
            
            var g:Graphics = _sp.graphics;
            g.clear();
            
            SoundMixer.computeSpectrum(bytes, FFT_MODE, 0);
            
            // L
            index = 0;
            g.lineStyle(1, COLOR[index]);
            g.beginFill(COLOR[index], 0.5);
            for (i = 0; i < CHANNEL_LENGTH; i++) {
                rad = deg2rad(360 * i / (CHANNEL_LENGTH - 1)) + index * deg2rad(180);
                n = bytes.readFloat() * R + OFFSET;
                if (i == 0) {
                    point = new Point(n * Math.cos(rad), n * Math.sin(rad));
                    g.moveTo(point.x, point.y);
                }
                g.lineTo(n * Math.cos(rad), n * Math.sin(rad));
            }
            g.lineTo(point.x, point.y);
            
            g.moveTo(n * Math.cos(0), n * Math.sin(0));
            for (i = 0; i < CHANNEL_LENGTH; i++) {
                rad = deg2rad(360 * i / (CHANNEL_LENGTH - 1));
                n = OFFSET;
                g.lineTo(n * Math.cos(rad), n * Math.sin(rad));
            }
            g.lineTo(n * Math.cos(0), n * Math.sin(0));
            g.endFill();
            
            // R
            index = 1;
            g.lineStyle(1, COLOR[index]);
            g.beginFill(COLOR[index], 0.5);
            for (i = 0; i < CHANNEL_LENGTH; i++) {
                rad = deg2rad(360 * i / (CHANNEL_LENGTH - 1)) + index * deg2rad(180);
                n = bytes.readFloat() * R + OFFSET;
                if (i == 0) {
                    point = new Point(n * Math.cos(rad), n * Math.sin(rad));
                    g.moveTo(point.x, point.y);
                }
                g.lineTo(n * Math.cos(rad), n * Math.sin(rad));
            }
            g.lineTo(point.x, point.y);
            
            g.moveTo(n * Math.cos(0), n * Math.sin(0));
            for (i = 0; i < CHANNEL_LENGTH; i++) {
                rad = deg2rad(360 * i / (CHANNEL_LENGTH - 1));
                n = OFFSET;
                g.lineTo(n * Math.cos(rad), n * Math.sin(rad));
            }
            g.lineTo(n * Math.cos(0), n * Math.sin(0));
            g.endFill();
        }
        
        // degree -> radian
        private function deg2rad(deg:Number):Number {
            deg %= 360;
            return deg / 180 * Math.PI;
        }
    }
}