/**
 * Copyright hacker_owxqkb_k ( http://wonderfl.net/user/hacker_owxqkb_k )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hvSU
 */

package
{
	import flash.display.*;
	import flash.events.*;
	import flash.filters.*;
	import flash.utils.*;
	import org.papervision3d.core.proto.*;
	import org.papervision3d.materials.shadematerials.*;
	import org.papervision3d.objects.*;
	import org.papervision3d.objects.primitives.*;
	import org.papervision3d.view.*;
	import org.papervision3d.cameras.*;
	import org.papervision3d.lights.*;
	import org.papervision3d.materials.*;
	import org.papervision3d.materials.utils.*;
	
	[SWF(width = "720", height = "480", frameRate = "60", backgroundColor="#FFFFFF")]

	public class Main extends BasicView
	{
		static private const CUBE_ROUND      :uint = 2500;
		static private const CUBE_SIZE       :uint = 600;
		static private const CUBE_SEGMENT    :uint = 1;
		static private const CUBE_AMOUNT     :uint = 10;
		static private const CAMERA_POSITION :uint = 4500;
		static private const LIGHT_POSITION  :uint = 2000;
		static private const PLANE_SIZE      :uint = 5000;
		
		private var light        :PointLight3D = new PointLight3D();
		private var shadowCaster :ShadowCaster = new ShadowCaster("shadow", 0, BlendMode.NORMAL, .25, [new BlurFilter(16, 16, 3)]); 	
		private var plane        :Plane;
		private var cubes        :DisplayObject3D;
		private var lightModel   :DisplayObject3D;
		
		public function Main()
		{
			super(0, 0, true, false, CameraType.TARGET);
			
			// shadow caster and movie material
			shadowCaster.setType(ShadowCaster.SPOTLIGHT);
			
			var sprite : Sprite = new Sprite();
			sprite.graphics.beginFill(0xEEEEEE, 1);
			sprite.graphics.drawRect(0, 0, 128, 128);
			sprite.graphics.endFill();
			var movieMat : MovieMaterial = new MovieMaterial(sprite, false, true, true);
			
			// add movieMaterial to plane
			plane = new Plane(movieMat, PLANE_SIZE, PLANE_SIZE, 4, 4);
			plane.pitch(90)
			plane.y = - CUBE_ROUND;
			scene.addChild(plane);
			
			cubes = scene.addChild(new DisplayObject3D());
			
			var i:int = CUBE_AMOUNT;
			while(i--)
			{
				var cube:Cube = new Cube(
					new MaterialsList( { all:new FlatShadeMaterial(light, 0xCCCCCC) } ),
					CUBE_SIZE, CUBE_SIZE, CUBE_SIZE,
					CUBE_SEGMENT, CUBE_SEGMENT, CUBE_SEGMENT);
				cube.x = CUBE_ROUND * Math.random() - CUBE_ROUND / 2;
				cube.y = CUBE_ROUND * Math.random() - CUBE_ROUND / 2;
				cube.z = CUBE_ROUND * Math.random() - CUBE_ROUND / 2;
				cube.scale = .8 * Math.random() + .2;
				cube.rotationX = 360 * Math.random();
				cube.rotationY = 360 * Math.random();
				cube.rotationZ = 360 * Math.random();
				cubes.addChild(cube);
			}
			
			lightModel = new Sphere(new WireframeMaterial(0xFFFF00), 100, 1, 1);
			scene.addChild(lightModel);
			scene.addChild(light);
			
			startRendering()
		}
		
		override protected function onRenderTick(e:Event = null):void
		{
			shadowCaster.invalidate();
			shadowCaster.castModel(cubes, light, plane); 	
			
			camera.x += (CAMERA_POSITION * Math.sin(mouseX / stage.stageWidth * 360 * Math.PI / 180) - camera.x) * .1;
			camera.z += (CAMERA_POSITION * Math.cos(mouseX / stage.stageWidth * 360 * Math.PI / 180) - camera.z) * .1;
			camera.y += (CAMERA_POSITION * mouseY / stage.stageHeight - CAMERA_POSITION / 2 - camera.y) * .1;
			
			light.x = LIGHT_POSITION * Math.sin(getTimer() / 2000);
			light.z = LIGHT_POSITION * Math.cos(getTimer() / 2000);
			light.y = LIGHT_POSITION * 1;
			
			lightModel.transform = light.transform
			
			super.onRenderTick(e);
		}
	}
}