/**
 * Copyright nbhd ( http://wonderfl.net/user/nbhd )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hvBQ
 */

package {
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.PixelSnapping;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.filters.BlurFilter;
	import flash.filters.GlowFilter;
	import flash.geom.ColorTransform;
	import flash.geom.Matrix;
	import flash.ui.Mouse;
	
	[SWF(width = "465", height = "465", frameRate = "60", backgroundColor=0x0)]
	public class Main extends Sprite {
		
		private var _bmpData:BitmapData;
		private var _bmp:Bitmap;
		private var _sp:Sprite;
		private var _color:int = 0xffffff;
		
		public function Main():void {
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void {
			removeEventListener(Event.ADDED_TO_STAGE, init);
			// entry point
			_bmpData = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0x00ffffff);
			_bmp = new Bitmap(_bmpData, PixelSnapping.AUTO, true);
			addChild(_bmp);
			
			
			_sp = new Sprite();
			_sp.graphics.beginFill(_color);
			_sp.graphics.drawCircle(0, 0, 50);
			addChild(_sp);
			_sp.filters = [new GlowFilter(0x00ffff, 0.7, 10, 10, 100), new BlurFilter(50, 50)];
			_sp.addEventListener(MouseEvent.MOUSE_MOVE, _drag);
			_sp.x = stage.stageWidth / 2;
			_sp.y = stage.stageHeight / 2;
			
			addEventListener(Event.ENTER_FRAME, _loop);
		}
		
		private function _drag(e:MouseEvent):void {
			e.target.startDrag(true);
			Mouse.hide();
		}
		
		private function _loop(e:Event):void {
			_bmpData.colorTransform(_bmpData.rect, new ColorTransform(1, 1, 1, 1, 1, 1, 1, -10));
			var mt:Matrix = new Matrix();
			mt.translate(_sp.x, _sp.y);
			
			_bmpData.draw(_sp, mt);
			//ここの GlowFilter の _color を任意の数値にすることで残像の色が変わるよ
			_bmp.filters = [new GlowFilter(_color, 0.5), new BlurFilter(100, 100)];
			_bmp.blendMode = "add";
		}
		
		
	}
	
}