/**
 * Copyright Kihara ( http://wonderfl.net/user/Kihara )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hucr
 */

package
{
    import flash.events.Event;
    import org.papervision3d.view.BasicView;

    [SWF(backgroundColor=0x0)]
    public class pv3d_ex2_3 extends BasicView
    {
        private var vector:Vector.<Str>=new Vector.<Str>;
        private var t:Number=0;
        private const N:uint=6;
        public function pv3d_ex2_3()
        {
            for (var i:uint=0; i < N; i++)
            {
                var v:Str=new Str(Math.random() * 600 + 200, Math.random() * 400 - 200, Math.random() * 600 + 300, Math.random() * 1000 - 500, Math.random() * 200 - 100, Math.random() * 600 - 300);
                vector.push(v);
                for (var j:uint=0; j < v.len; j++)
                    scene.addChild(vector[i].vec[j]);
            }
            startRendering();
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }

        public function onEnterFrame(e:Event):void
        {
            t++;
            for (var i:uint=0; i < N; i++)
            {
                for (var j:uint=0; j < vector[i].len; j++)
                {
                    var theta:Number=(j * 360 / vector[i].len + t) % 360;
                    vector[i].vec[j].rotationZ=vector[i].rZ;
                    vector[i].vec[j].rotationX=vector[i].rX;
                    vector[i].vec[j].rotationY=90 - theta;
                    vector[i].vec[j].x=vector[i].xr * Math.cos(theta * Math.PI / 180) + vector[i]._x;
                    vector[i].vec[j].y=vector[i].yr * Math.sin(theta * Math.PI / 180) + vector[i]._y;
                    vector[i].vec[j].z=vector[i].zr * Math.sin(theta * Math.PI / 180) + vector[i]._z;
                }
            }
            camera.x+=(mouseX - camera.x) * 0.2;
            camera.y+=(mouseY - camera.y) * 0.2;
        }
    }
}

import flash.display.BlendMode;
import flash.filters.GlowFilter;

import org.papervision3d.materials.special.Letter3DMaterial;
import org.papervision3d.typography.Text3D;
import org.papervision3d.typography.fonts.HelveticaBold;
import org.papervision3d.view.BasicView;

class Str extends BasicView
{
    public var rX:Number, rY:Number, rZ:Number, xr:Number, yr:Number, zr:Number;
    public var _x:Number, _y:Number, _z:Number;
    public var vec:Vector.<Text3D>=new Vector.<Text3D>;
    private var str:String="abcdefghijklmnopqrstuvwxyz";
    public var len:uint=str.length;

    public function Str(xr:Number, yr:Number, zr:Number, _x:Number, _y:Number, _z:Number)
    {
        this.xr=xr;this.yr=yr;this.zr=zr;this._x=_x;this._y=_x;this._z=_z;
        rZ=Math.PI * (1 / 3) * (1 / (xr / yr));
        rX=Math.random() * 90 - 45;
        var mat:Letter3DMaterial=new Letter3DMaterial(0xFFFFAA);
        var font:HelveticaBold=new HelveticaBold();
        mat.doubleSided=true;
        for (var i:uint=0; i < str.length; i++)
        {
            vec.push(new Text3D(str.charAt(str.length - i - 1), font, mat));
            vec[i].useOwnContainer=true;
            vec[i].filters=[new GlowFilter(0x99BBFF, 0.8, 10, 10)];
            vec[i].blendMode=BlendMode.ADD;
        }
    }
}