/**
 * Copyright hacker_9p8x8mco ( http://wonderfl.net/user/hacker_9p8x8mco )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/huZR
 */

package{
	import flash.display.*;
	import flash.events.*;
	import flash.text.*;
	import flash.ui.*;

	public class KeyEx extends Sprite{
		private var base:Sprite;
		private var label:TextField;

		public function KeyEx(){
			base = new Sprite();
			base.graphics.beginFill(0xFFFFFF);
			base.graphics.drawRect(0,0,240,240);
			base.graphics.endFill();
			//base.focusRect = false;
			addChild(base);

			label = makeLabel("キーイベント");
			base.addChild(label);

			base.addEventListener(KeyboardEvent.KEY_DOWN,onKeyDown);
			base.addEventListener(KeyboardEvent.KEY_UP,onKeyUp);
			base.addEventListener(MouseEvent.CLICK,onClick);
		}

		private function onKeyDown(evt:KeyboardEvent):void{
			var text:String = "";
			text += "キーダウン\n";
			text += "キーコード:"	+evt.keyCode+"\n";
			text += "コントロールキー:"+evt.ctrlKey+"\n";
			text += "シフトキー:"	+evt.shiftKey+"\n";
			text += "アルトキー:"	+evt.altKey+"\n";
			label.text = text;
		}

		private function onKeyUp(evt:KeyboardEvent):void{
			var text:String = "";
			text += "キーアップ\n";
			text += "キーコード:"	+evt.keyCode+"\n";
			text += "コントロールキー:"+evt.ctrlKey+"\n";
			text += "シフトキー:"	+evt.shiftKey+"\n";
			text += "アルトキー:"	+evt.altKey+"\n";
			label.text = text;
		}
		
		private function onClick(evt:MouseEvent):void{
			stage.focus = base;
		}
		
		private function makeLabel(text:String):TextField{
			var label:TextField = new TextField();
			label.text = text;
			label.autoSize = TextFieldAutoSize.LEFT;
			label.selectable = false;
			return label;
		}
	}

}
