/**
 * Copyright rettuce ( http://wonderfl.net/user/rettuce )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hsjZ
 */

package 
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.display.LoaderInfo;
    import flash.display.MovieClip;
    import flash.display.Sprite;
    import flash.display.Graphics;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.events.ProgressEvent;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    
    // library
    import caurina.transitions.Tweener;
    
    [SWF(width = 465, height = 465, backgroundColor = 0x000000, frameRate = 40)]
//    [SWF(width = 1024, height = 768, backgroundColor = 0x000000, frameRate = 40)]
    /**
     * ...
     * @author rettuce
     */
    public class DocumentClass extends Sprite 
    {
        private var ROTATE0:String = "rotate0";
        private var ROTATE10:String = "rotate10";
        private var ROTATE45:String  = "rotate45";
        private var ROTATE90:String  = "rotate90";
        private var ROTATE135:String = "rotate135";
        private var ROTATE170:String = "rotate170";
        private var ROTATE180:String = "rotate180";
        private var ROTATE190:String = "rotate190";
        private var ROTATE225:String = "rotate225";
        private var ROTATE270:String = "rotate270";
        private var ROTATE315:String = "rotate315";
        private var ROTATE350:String = "rotate350";
        
        private var _cube:MovieClip;
        private var _loadcube:MovieClip;
        private var _cubeArr:Array = [];
        private var _cnt:int = 0;
        
        private var _urlArr:Array = ["http://lab.rettuce.com/common/src/MonaLisa.jpg","http://lab.rettuce.com/common/src/PearlGirl.jpg"]
        
        private var _col:Number = 0xFF0000;
        private var _alp:Number = 0.5;
        private var _space:int    = 25;
        private var _num:int      = 16;
        
        private var _wid:Number = 25;
        private var _hei:Number = 25;
        private var _dep:Number = 25;
        
        public function DocumentClass()
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);        
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            
            loadcubeInit();
            cubeInit();
            imgLoad();
        }
        
        private function cubeInit():void 
        {
            _cube = new MovieClip();
            
            for ( var n:int = 0; n < _num; n++ ) {
                _cubeArr[n] = new Array();
                for (var i:int = 0; i < _num; i++ ) {
                    var c:MovieClip = new Cube( _col, _alp);
                    c.createBox( _wid, _hei, _dep );
                    c.x = _space * ( i - _num / 2 );
                    c.y = _space * ( n - _num / 2 );
                    _cube.addChild(c);
                    _cubeArr[n][i] = c;
                }
            }            
            _cube.x = stage.stageWidth / 2;
            _cube.y = stage.stageHeight / 2;
        }
        private function loadcubeInit():void 
        {
            _loadcube = new Cube( _col, _alp);
            _loadcube.createBox( _wid, _hei, _dep );
            addChild( _loadcube );
            _loadcube.x = stage.stageWidth / 2;
            _loadcube.y = stage.stageHeight / 2;
        }
        
        private function change(e:MouseEvent):void 
        {
            var num:Number = Math.floor( _num * Math.random());
            var num2:Number = Math.floor( _num * Math.random());
            _cubeArr[num][num2].cook();
        }
        
        private function rotateHandler(e:Event):void 
        {
            switch( e.type ) {
                case "rotate0":
                    removeEventListener(ROTATE0, rotateHandler );
                    addEventListener( ROTATE10 , rotateHandler );
                    break;
                    
                case "rotate10":
                    removeEventListener(ROTATE10, rotateHandler );
                    addEventListener( ROTATE45 , rotateHandler );
                    break;
                    
                case "rotate45":
                    removeEventListener(ROTATE45, rotateHandler );
                    addEventListener( ROTATE90 , rotateHandler );
                    break;
                    
                case "rotate90":
                    removeEventListener(ROTATE90, rotateHandler );
                    addEventListener( ROTATE135 , rotateHandler );
                    break;
                    
                case "rotate135":
                    removeEventListener(ROTATE135, rotateHandler );
                    addEventListener( ROTATE170 , rotateHandler );
                    break;
                    
                case "rotate170":
                    removeEventListener(ROTATE170, rotateHandler );
                    addEventListener( ROTATE180 , rotateHandler );
                    break;
                    
                case "rotate180":
                    removeEventListener(ROTATE180, rotateHandler );
                    addEventListener( ROTATE190 , rotateHandler );
                    break;
                    
                case "rotate190":
                    removeEventListener(ROTATE190, rotateHandler );
                    addEventListener( ROTATE225 , rotateHandler );
                    break;
                    
                case "rotate225":
                    removeEventListener(ROTATE225, rotateHandler );
                    addEventListener( ROTATE270 , rotateHandler );
                    break;
                    
                case "rotate270":
                    removeEventListener(ROTATE270, rotateHandler );
                    addEventListener( ROTATE315 , rotateHandler );
                    break;
                    
                case "rotate315":
                    removeEventListener(ROTATE315, rotateHandler );
                    addEventListener( ROTATE350 , rotateHandler );
                    break;
                    
                case "rotate350":
                    removeEventListener(ROTATE350, rotateHandler );
                    addEventListener( ROTATE0 , rotateHandler );
                    break;
            }
            
            depthChange(Math.floor(keisu));
        }
        
        private function depthChange( num:Number ):void 
        {            
            trace( num )
            switch( num ) {
                case 0:
                    depthAllHandler( 1 );
                    depthAllHandler( 2 );
                    break;
                case 10:
                    depthMainHandlerR();
                    break;
                case 45:
                    depthAllHandler( 1 );
                    break;
                case 90:
                    depthAllHandler( 0 );
                    depthAllHandler( 1 );
                    break;
                case 135:
                    depthAllHandler( 0 );
                    break;
                case 170:
                    depthMainHandler();
                    break;
                case 180:
                    depthAllHandler( 3 );
                    depthAllHandler( 0 );
                    break;
                case 190:
                    depthMainHandlerL();
                    break;
                case 225:
                    depthAllHandler( 3 );
                    break;
                case 270:
                    depthAllHandler( 2 );
                    depthAllHandler( 3 );
                    break;
                case 315:
                    depthAllHandler( 2 );
                    break;
                case 350:
                    depthMainHandler();
                    break;
            }
        }
        
        private function depthAllHandler(  cnt:int ):void 
        {
            for ( var n:int = 0; n < _num; n++ ) {
                for (var i:int = 0; i < _num; i++ ) {
                    _cubeArr[n][i].setIndexTop( cnt );
                }
            }
        }
        private function depthMainHandler():void 
        {
            for ( var n:int = 0; n < _num; n++ ) {
                for (var i:int = 0; i < _num; i++ ) {
                    var _x:int = i+1;
                    var _y:int = n+1;
                    if ( _x > _num / 2 ) _x -= (_x - _num / 2) * 2 -1;
                    if ( _y > _num / 2 ) _y -= (_y - _num / 2) * 2    -1;                
                    var dept:int = (_x) * (_y) * 2;
                    _cube.setChildIndex( _cubeArr[n][i] , dept );
                }
            }
        }
        private function depthMainHandlerR():void 
        {
            for ( var n:int = 0; n < _num; n++ ) {
                for (var i:int = 0; i < _num; i++ ) {
                    var _x:int = i+1;
                    var _y:int = n+1;
                    if ( _y > _num / 2 ) _y -= (_y - _num / 2) * 2    -1;
                    var dept:int = (_x) * (_y) ;
                    _cube.setChildIndex( _cubeArr[n][i] , dept );
                }
            }
        }
        private function depthMainHandlerL():void 
        {
            for ( var n:int = 0; n < _num; n++ ) {
                for (var i:int = 0; i < _num; i++ ) {
                    var _x:int = _num - i ;
                    var _y:int = n+1;
                    if ( _y > _num / 2 ) _y -= (_y - _num / 2) * 2    -1;
                    var dept:int = (_x) * (_y) ;
                    _cube.setChildIndex( _cubeArr[n][i] , dept );
                }
            }
        }
        
        
        
        
        
        private var plusY:Number = 0.3;        
        private var keisu:Number = 0;
        private function animation(e:Event):void
        {
            _cube.rotationY += plusY;
            keisu = _cube.rotationY;
            
            if ( keisu <= 10 ) {
                dispatchEvent( new Event( ROTATE0 ) );
            } else if ( 10  < keisu && keisu <= 45 ) {
                dispatchEvent( new Event( ROTATE10 ) );
            } else if ( 45  < keisu && keisu <= 90 ) {
                dispatchEvent( new Event( ROTATE45 ) );
            } else if ( 90  < keisu && keisu <= 135 ) {
                dispatchEvent( new Event( ROTATE90 ) );
            } else if ( 135  < keisu && keisu <= 170 ) {
                dispatchEvent( new Event( ROTATE135 ) );
            } else if ( 170 < keisu && keisu <= 180 ) {
                dispatchEvent( new Event( ROTATE170 ) );
            } else if ( 180 < keisu && keisu <= 190 ) {
                dispatchEvent( new Event( ROTATE180 ) );
            } else if ( 190 < keisu && keisu <= 225 ) {
                dispatchEvent( new Event( ROTATE190 ) );
            } else if ( 225 < keisu && keisu <= 270 ) {
                dispatchEvent( new Event( ROTATE225 ) );
            } else if ( 270 < keisu && keisu <= 315 ) {
                dispatchEvent( new Event( ROTATE270 ) );
            } else if ( 315 < keisu && keisu <= 350 ) {
                dispatchEvent( new Event( ROTATE315 ) );
            } else if ( 350 < keisu && keisu <= 360 ) {
                dispatchEvent( new Event( ROTATE350 ) );
            } else if ( 360 < keisu ) {
                _cube.rotationY = 0;
            }
        }
        
        
        
        private function imgLoad():void
        {
            if (_urlArr.length == 0 ) {
                trace("LOAD COMP !!");
                removeChild( _loadcube );
                addChild(_cube);
                depthMainHandler();
                stage.addEventListener(MouseEvent.CLICK, change );
                addEventListener(Event.ENTER_FRAME, animation);
                addEventListener( ROTATE0 , rotateHandler );
                return;
            }
            
            var context:LoaderContext = new LoaderContext(true);
            
            var loader:Loader = new Loader();
            var info:LoaderInfo = loader.contentLoaderInfo;
            var url:URLRequest = new URLRequest( _urlArr.shift() );
            info.addEventListener(ProgressEvent.PROGRESS, loadingAnimation);
            info.addEventListener(Event.COMPLETE, loadComp);
            loader.load(url, context);
        }
        
        private function loadingAnimation(e:ProgressEvent):void 
        {
            _loadcube.rotationX+=0.5;
            _loadcube.rotationY+=0.5;
            _loadcube.rotationZ+=0.5;
        }
        
        private function loadComp(e:Event):void
        {
            e.target.removeEventListener(ProgressEvent.PROGRESS, loadingAnimation);
            e.target.removeEventListener(Event.COMPLETE, arguments.callee );
            
            var bm:Bitmap = e.target.content;
            var bmNew:Bitmap = imgResize( bm );            
            
            var point:Point = new Point(0, 0);
            
            for ( var n:int = 0; n < _num; n++ ) {
                if (_urlArr.length == 1) {
                    for (var i:int = 0; i < _num; i++ ) {
                        var c:Cube = _cubeArr[n][i];
                        var rect:Rectangle = new Rectangle(_wid*i, _hei*n, _wid, _hei);
                        var src:Bitmap = new Bitmap( new BitmapData(_wid, _hei) );
                        src.bitmapData.copyPixels(bmNew.bitmapData, rect, point);
                        c.texture( src , 2 );
                    }
                }else if(_urlArr.length == 0) {
                    for (var m:int = _num-1; m >= 0; m-- ) {
                        var c2:Cube = _cubeArr[n][m];
                        var rect2:Rectangle = new Rectangle(_wid*m, _hei*n, _wid, _hei);
                        var src2:Bitmap = new Bitmap( new BitmapData(_wid, _hei) );
                        src2.bitmapData.copyPixels(bmNew.bitmapData, rect2, point);
                        c2.texture( src2 , 0 );
                    }
                }
            }
            
            imgLoad();
        };        
        
        private var W:Number;
        private var H:Number;
        
        // 渡されたBitmapを決められた値（W,H）でリサイズして戻す
        private function imgResize(bm:Bitmap):Bitmap
        {
            W = _num * _wid;
            H = _num * _hei;
            
            var bmNew:Bitmap = new Bitmap( new BitmapData( W, H ) );
            bmNew.smoothing = true;
            
            var per:Number;
            var perW:Number = W / bm.width;
            var perH:Number = H / bm.height ;            
            per = Math.max( perW, perH );
            
            var bmX:Number = Math.floor(( W - bm.width * per ) / 2 );
            var bmY:Number = Math.floor(( H - bm.height * per ) / 2 );
            
            var mat:Matrix = new Matrix();
            mat.scale( per, per );
            mat.translate( bmX , bmY );
            bmNew.bitmapData.draw(bm , mat );
            
            return bmNew;
        }
        
        
    }
}


import flash.display.MovieClip;
import flash.display.Sprite;
import flash.display.Graphics;
import flash.text.TextField;
import flash.display.Bitmap;
import flash.display.BitmapData;

// library
import caurina.transitions.Tweener;

/*
 *         _cube = new Cube( 0xFFFFFF, 0.3 ); // color, alpha
 *         _cube.createBox( 200, 200, 300 );    // width, height, depth
 *         addChild(_cube); 
 */

class Cube extends MovieClip
{    
    private var _col:Number;
    private var _alp:Number;    
    private var planeArr:Array = [];
     private var txt:TextField;
    
    function Cube( col:Number = 0xFF0000, alp:Number = 0.3 )
    {
        _col = col;
        _alp = alp;        
    }
    
    public function createBox( wid:Number, hei:Number, dep:Number  ):void
    {
        
        for (var i:int = 0; i < 6; i++ ) {
            var s:Sprite = new Sprite();
            var g:Object = s.graphics;
            
            g.lineStyle (0, _col, _alp+0.2);    // 線のスタイル指定
            g.beginFill (_col, _alp);    // 面のスタイル設定
            
            if ( i == 0 || i == 2 ) {
                g.drawRect  (0, 0 , wid , hei);
            }else if ( i == 1 || i == 3 ) {
                g.drawRect  (0, 0 , dep , hei);
            }else if ( i == 4 || i == 5 ) {
                g.drawRect  (0, 0 , wid , dep);
            }
            planeArr.push(s);
            addChild(s);
        }
            
        planeArr[0].x = -wid/2;
        planeArr[0].y = -hei/2;
        planeArr[0].z =   dep/2;

        planeArr[1].x =  wid/2;
        planeArr[1].y = -hei/2;
        planeArr[1].z = -dep/2;
        planeArr[1].rotationY = -90;

        planeArr[2].x = -wid/2;
        planeArr[2].y = -hei/2;
        planeArr[2].z = -dep/2;

        planeArr[3].x = -wid/2;
        planeArr[3].y = -hei/2;
        planeArr[3].z = -dep/2;
        planeArr[3].rotationY = -90;

        planeArr[4].x = -wid/2;
        planeArr[4].y = -hei/2;
        planeArr[4].z =  dep/2;
        planeArr[4].rotationX = -90;

        planeArr[5].x = -wid/2;
        planeArr[5].y =  hei/2;
        planeArr[5].z = -dep/2;
        planeArr[5].rotationX = 90;
    }
    
    public function texture( src:Bitmap, num:int ):void 
    {
        planeArr[num].addChildAt(src, 0);
    }
    public function setIndexTop( num:int ):void 
    {
        setChildIndex( planeArr[num], planeArr.length - 1 );
    }
    
    
    public function zSort():void 
    {
        Tweener.addTween( this, { z:0, time:1 } );
    }
    public function popup():void 
    {
        Tweener.addTween( this, { z:-25, alpha:0.5, time:1 , onComplete:function():void {
            Tweener.addTween( this, { z:25,  alpha:1, time:0.5 } );
        }} );
    }
    public function cook():void 
    {
        Tweener.addTween( this, { rotationX:-180*Math.random(), rotationY:-180, scaleX:1.2, scaleY:1.2, scaleZ:1.2, time:0 , onComplete:function():void {
            Tweener.addTween( this, { rotationX:0, rotationY:0, scaleX:1, scaleY:1, scaleZ:1, time:0.5 ,delay:0.2 } );
        }} );
        popup();
    }
    
}




