/**
 * Copyright mutantleg ( http://wonderfl.net/user/mutantleg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hsd8
 */

package {
    import flash.text.TextField;
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
       
        public function FlashTest() {
            // write as3 code here..
            
            vecWall.push(new Wall(60,60, 100,100));
            vecWall.push(new Wall(100,100, 160,100));
            vecWall.push(new Wall(160,100,  160, 160));
            vecWall.push(new Wall(160,160,  100, 180));
            vecWall.push(new Wall(100,180, 60,170) );
            vecWall.push(new Wall(60,170, 40, 100) );
            vecWall.push(new Wall(40,100, 60,60) );
            
            deb = new TextField();
            deb.x = 16;
            deb.y = 16;
            deb.width = 300;
            deb.text = "Debug ";
            addChild(deb);
            
            stage.addEventListener(Event.ENTER_FRAME, onEnter);
        }//ctor
        
        public var tw:Wall = new Wall(10,10, 100,100);
        
        public var vecWall:Vector.<Wall> = new Vector.<Wall>;
        
        
        public function getClose(px:Number, py:Number, w:Wall):Number
        {
            var jx:Number;
            var jy:Number;
            var hx:Number;
            var hy:Number;
            
            jx = px - w.bx;
            jy = py - w.by;
            hx = w.ax - w.bx;
            hy = w.ay - w.by;
            
            var ab:Number;
            var ak:Number;
            
            ab = hx*hx + hy*hy;
            ak = jx*hx + jy*hy;
            var t:Number;
            t = ak / ab;

           if (t < 0) { t=0;}
            if (t > 1) { t=1;}
          
            return t;
        }//getclose
        
        
        var deb:TextField;
        
        public function drawWall(w:Wall):void
        {
              
           graphics.moveTo(w.ax, w.ay);
           graphics.lineTo(w.bx, w.by);
            
            var kx:Number;
            var ky:Number;
            kx = w.ax + (w.bx-w.ax)*0.5;
            ky = w.ay +(w.by - w.ay)*0.5;
            
            graphics.moveTo(kx,ky);
            graphics.lineTo(kx+w.nx*8,ky+w.ny*8);
            
           
        }//drawwall
        
        public function getDist(dx:Number, dy:Number):Number
        {
            return (dx*dx + dy*dy);
        }//getdist
        
       public function onEnter(e:Event):void
       {
           deb.text = "";
           
           graphics.clear();
           graphics.lineStyle(2,0);
           
           var cx:Number;
           var cy:Number;
           var i:int;
           var num:int;
           var w:Wall;
           var t:Number;
           var gx:Number;          
            var gy:Number;
           var maxd:Number;
           var dist:Number;
           var wx:Number;
           var wy:Number;
           var ww:Wall;
           
           cx = mouseX;
           cy = mouseY;
           
           maxd = 99999999;
           
           num = vecWall.length;
           for (i =0; i < num; i++)
           {
               w = vecWall[i];
               drawWall(w);
               
               t = getClose(cx,cy, w);
               
               deb.appendText("i "+i+" t " +t);

                 gx = w.bx + (w.ax - w.bx) * t;
                 gy = w.by + (w.ay - w.by) * t;
                 graphics.drawCircle(gx,gy,4);   
              
              dist = getDist(cx-gx, cy-gy);
               if (dist < maxd) 
               { 
                   maxd = dist;
                   ww = w;
                   wx = gx;
                   wy = gy;
               }//endif
            }//nexti
            
            graphics.moveTo(wx,wy);
            graphics.lineTo(cx,cy);
           
           if (ww != null)
           {
            var dot:Number;
            
            //plane to point test
            //http://www.gamespp.com/algorithms/collisionDetectionTutorial01.html
            
            dot = (cx-wx)*ww.nx + (cy-wy)*ww.ny;
            
           // deb.text = " " +dot;
       
               if (dot < 16) 
               {
                graphics.lineStyle(2,0xFF0000);   
                   }
                else
                {
                 graphics.lineStyle(2,0);   
                 }
           }//endif
           
          // drawWall(tw);
                
             graphics.drawCircle(cx,cy,16);
           
       }//onenter 
        
    }//classend
}//package

internal class Wall
{
    public var ax:Number = 0;
    public var ay:Number = 0;
    public var bx:Number = 0;
    public var by:Number = 0;
    
    public var nx:Number = 0;
    public var ny:Number = 0;
    
    public function Wall(x:Number, y:Number, x2:Number, y2:Number)
    {
        ax = x;
        ay = y;
        bx = x2;
        by = y2;
   
   //calc normal
       var dx:Number;
       var dy:Number;
       var mag:Number;
       dx = ax-bx;
       dy = ay-by;
        mag = Math.sqrt(dx*dx+dy*dy);
        if (mag == 0) { mag = 0.000001; }
        dx /= mag;
        dy /= mag;
        nx = -dy;
        ny = dx;
        
    }//ctor
    
};//wall