/**
 * Copyright shaggy ( http://wonderfl.net/user/shaggy )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hsb9
 */

// forked from mousepancyo's Half Tone Screen Cam
package  {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.events.IOErrorEvent;
    import flash.display.Shader;
    import flash.filters.ShaderFilter;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.geom.ColorTransform;
    import flash.geom.Point;
    import flash.net.*;
    import flash.utils.ByteArray;
    import com.adobe.images.PNGEncoder;
    import com.bit101.components.*;
    import flash.filters.BlurFilter;
    
    [SWF(width = "465", height = "465", backgroundColor = "0", frameRate = "30")]
    public class Main extends Sprite{
        private const FILTER_URL:String = "http://www.digifie.jp/files/filters/halftone.pbj";
        private var _loader:URLLoader;
        private var _shader:Shader;
        private var _filter:ShaderFilter;
        private var _container:Sprite;
        private var _srcBmd:BitmapData;
        private var _bm:Bitmap;
        private var _video:CameraCapture;
        private var _saveBmd:BitmapData;
        private var _ctf:ColorTransform = new ColorTransform;
        private var _fr:FileReference = new FileReference();
        private var _chengeBtn:PushButton;
        private var _blendBtn:PushButton;
        private var _saveBtn:PushButton;
        private var _slider:HSlider;

        public function Main() {
            addChild(new Bitmap(new BitmapData(465, 465, false, 0xF0F0F0)));
            
            
            //
            _srcBmd = new BitmapData(320, 240, false, 0);
            
            
            _container = new Sprite();
            _container.x = 72;
            _container.y = 100;
            //
            filterLoad();
        }
        
        // Load Filter
        private function filterLoad():void{
            _loader = new URLLoader;
            _loader.addEventListener(Event.COMPLETE, onLoaded);
            _loader.dataFormat = URLLoaderDataFormat.BINARY;
            _loader.load(new URLRequest(FILTER_URL));
        }
        private function onLoaded(e:Event):void{
            _loader.removeEventListener(Event.COMPLETE, onLoaded);
            // CreateFilter
            _shader = new Shader(_loader.data);
            _shader.data.dot_spacing.value = [4];
            _shader.data.gamma.value = [1];
            _shader.data.max_dot_size.value = [4];
            _filter = new ShaderFilter(_shader);
            // Video
            _video = new CameraCapture(320, 240, 30);
            _video.visible = false;
            addEventListener(Event.ENTER_FRAME, update);
            //_container.addChild(_video);
            //_container.addChild(_bm);
            
            addChild(new Bitmap(_srcBmd));
            //
            
        }
        
        // View Update
        private function update(e:Event):void{
            _srcBmd.draw(_video)
            // addedFilter
            _srcBmd.applyFilter(_srcBmd, _srcBmd.rect, new Point(), _filter);
            //_srcBmd.applyFilter(_srcBmd, _srcBmd.rect, new Point(), new BlurFilter(2,2));
        }
        
        private function changeVal(e:Event):void{
            var n:Number = e.currentTarget.value * .05;
            _shader.data.gamma.value = [n];
        }
        
        
        
    }     
}


// Camera
import flash.media.Video;
import flash.events.Event;
import flash.media.Camera;

class CameraCapture extends Video{
    private var _cam:Camera;
    private var _camW:int;
    private var _camH:int;
    private var _fps:Number;

    public function CameraCapture(camW:Number, camH:Number, fps:Number=30) {
        this.width = camW;
        this.height = camH;
        _camW = camW;
        _camH = camH;
        _fps = fps;
        _cam = Camera.getCamera();
        _cam.setMode(_camW, _camH, _fps);
        this.attachCamera(_cam);
    }
}



