/**
 * Copyright kihon ( http://wonderfl.net/user/kihon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hsaQ
 */

package
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.filters.BevelFilter;
	import flash.filters.DropShadowFilter;
	import flash.text.TextField;
	import flash.text.TextFormat;
 
	public class Main extends Sprite
	{
		private var hour:Sprite;	// 時針
		private var minute:Sprite;	// 分針
		private var second:Sprite;	// 秒針
		private var tf:TextField;
 
		public function Main()
		{
			graphics.lineStyle(10.0, 0x0);
			graphics.drawCircle(232, 232, 100);
 
			var circle:Sprite = new Sprite();
			circle.graphics.beginFill(0xFFFFFF);
			circle.graphics.drawCircle(0, 0, 100);
			circle.x = circle.y = 232;
			circle.filters = [new BevelFilter(4, 40, 0x707070, 1, 0x707070, 1)];
			addChild(circle);
 
			for (var degree:int = 0; degree < 360; degree += 360 / 12)
			{
				var rect:Sprite = new Sprite();
				rect.graphics.beginFill(0x0);
				rect.graphics.drawRect(0, 0, 13, 3);
				rect.graphics.endFill();
 
				rect.x = 232 + Math.cos(degree * Math.PI / 180) * 80;
				rect.y = 232 + Math.sin(degree * Math.PI / 180) * 80;
				rect.rotation = degree;
				addChild(rect);
			}
 
			second = new Sprite();
			second.graphics.beginFill(0x777777);
			second.graphics.drawRect(0, -1, 80, 2);
			second.graphics.endFill();
			second.x = second.y = 232;
			second.filters = [new DropShadowFilter(4, 45, 0xcccccc)];
			addChild(second);
 
			circle = new Sprite();
			circle.graphics.beginFill(0x0);
			circle.graphics.drawCircle(0, 0, 8);
			circle.graphics.endFill();
			circle.x = circle.y = 232;
			addChild(circle);
 
			tf = new TextField();
			tf.defaultTextFormat = new TextFormat("_typeWriter", 40, 0x0, true);
			tf.autoSize = "left";
			addChild(tf);
 
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
		}
 
		private function onEnterFrame(event:Event):void
		{
			var date:Date = new Date();
			tf.text = date.toTimeString();
 
			second.rotation = date.seconds * 6 - 90;
		}
	}
}
