/**
 * Copyright Scmiz ( http://wonderfl.net/user/Scmiz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hsaP
 */

package {
	import flash.display.Graphics;
    import flash.display.Sprite;
	import flash.events.Event;
    public class FlashTest extends Sprite {
		private var _frame:uint;
		
		private const MAX_FRAME:uint = 30;
		private const SIZE:Number = 8.0;
		
        public function FlashTest() {
			_frame = 0;
			this.addEventListener(Event.ENTER_FRAME, proc);
        }
		
		private function proc(e:Event):void {
			update();
			draw();
		}
		
		private function update():void {
			_frame = (_frame + 1) % MAX_FRAME;
		}
		
		private function draw():void {
			var g:Graphics = this.graphics;
			g.clear();
			
			g.beginFill(0x404040);
			g.drawRect(0, 0, 465, 465);
			g.endFill();
			
			g.lineStyle(1, 0xefefef);
			for (var index:uint = 0; index < 50; ++index) {
				var ratio:Number = Number(_frame) / MAX_FRAME;
				var size:Number = (SIZE * index) + (SIZE * ratio);
				g.drawCircle(232.5, 232.5, size);
			}
		}
    }
}