/**
 * Copyright shaktool ( http://wonderfl.net/user/shaktool )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hrob
 */

// forked from psyark's BumpyPlanet
// 非平面モデルへのバンプマップ生成
// ついでに地形のランダム生成
// Shader使ってないので初期化が重いです
// favoriteありがとう！マウスで光を動かせるようにしてみたよ
package {
    import flash.display.*;
    import flash.events.Event;
    import flash.filters.ColorMatrixFilter;
    import flash.geom.*;
    import flash.utils.getTimer;
    
    [SWF(width=465,height=465,frameRate=60,backgroundColor=0x000000)]
    public class BumpyPlanet extends Sprite {
        private var heightMap:BitmapData = new HeightMap(512, 512);
        private var normalMap:BitmapData = new NormalMap(heightMap, 0x80, 25);
        private var texture:BitmapData = new Texture(heightMap, 0x80);
        private var screenBuffer:BitmapData = new BitmapData(512, 512, false, 0);
        
        public function BumpyPlanet() {
            addChild(new Bitmap(screenBuffer));
            addEventListener(Event.ENTER_FRAME, enterFrame);
        }
        
        private function enterFrame(event:Event):void {
            var light:Vector3D = new Vector3D();
            var radius: Number = 465/2.0;
            light.x = (mouseX - radius) / radius / Math.SQRT2;
            light.y = (mouseY - radius) / radius / Math.SQRT2;
            light.z = Math.sqrt(1 - light.x * light.x - light.y * light.y);
            var lighting:ColorMatrixFilter = new ColorMatrixFilter([
                2 * light.x, 2 * light.y, 2 * light.z, 0, (light.x + light.y + light.z) * -0xFF,
                2 * light.x, 2 * light.y, 2 * light.z, 0, (light.x + light.y + light.z) * -0xFF,
                2 * light.x, 2 * light.y, 2 * light.z, 0, (light.x + light.y + light.z) * -0xFF,
                0,           0,           0,           1, 0
            ]);
            screenBuffer.applyFilter(normalMap, normalMap.rect, normalMap.rect.topLeft, lighting);
            screenBuffer.draw(texture, null, null, BlendMode.MULTIPLY);
        }
    }
}

import flash.display.BitmapData;
import flash.geom.ColorTransform;
import flash.geom.Vector3D;
import flash.geom.Matrix3D;
class HeightMap extends BitmapData {
    public function HeightMap(width:uint, height:uint) {
        super(width, height, false, 0);
        perlinNoise(50, 50, 3, Math.random() * 100, true, true, 0, true);
    }
}
class NormalMap extends BitmapData {
    public function NormalMap(heightMap:BitmapData, seaHeight:uint, multiplier:Number) {
        super(heightMap.width, heightMap.height, false);
        var vec:Vector3D = new Vector3D();
        for (var y:int=0; y<heightMap.height; y++) {
            for (var x:int=0; x<heightMap.width; x++) {
                var height:uint = heightMap.getPixel(x, y) & 0xFF;
                vec.x = (height - (heightMap.getPixel((x + 1) % heightMap.width, y) & 0xFF)) / 0xFF * multiplier;
                vec.y = (height - (heightMap.getPixel(x, (y + 1) % heightMap.height) & 0xFF)) / 0xFF * multiplier;
                vec.z = 0;
                if (vec.lengthSquared > 1) {
                    vec.normalize();
                }
                vec.z = Math.sqrt(1 - vec.lengthSquared);
                setPixel(x, y,
                    (vec.x * 0x7F + 0x80) << 16 |
                    (vec.y * 0x7F + 0x80) << 8 |
                    (vec.z * 0x7F + 0x80)
                );
            }
        }
    }
}
class Texture extends BitmapData {
    public function Texture(heightMap:BitmapData, seaHeight:uint) {
        super(heightMap.width, heightMap.height, false, 0);
        draw(heightMap);
    }
}
