/**
 * Copyright davidejones ( http://wonderfl.net/user/davidejones )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hrcZ
 */

package {
    
    import alternativa.engine3d.controllers.SimpleObjectController;
    import alternativa.engine3d.core.Camera3D;
    import alternativa.engine3d.core.Object3D;
    import alternativa.engine3d.core.Resource;
    import alternativa.engine3d.core.View;
    import alternativa.engine3d.loaders.Parser;
    import alternativa.engine3d.loaders.Parser3DS;
    import alternativa.engine3d.loaders.ParserA3D;
    import alternativa.engine3d.loaders.ParserCollada;
    import alternativa.engine3d.loaders.ParserMaterial;
    import alternativa.engine3d.loaders.ResourceLoader;
    import alternativa.engine3d.loaders.TexturesLoader;
    import alternativa.engine3d.materials.TextureMaterial;
    import alternativa.engine3d.materials.StandardMaterial;
    import alternativa.engine3d.materials.FillMaterial;
    import alternativa.engine3d.objects.Mesh;
    import alternativa.engine3d.objects.Surface;
    import alternativa.engine3d.resources.ExternalTextureResource;
    import alternativa.engine3d.resources.BitmapTextureResource;
    import alternativa.engine3d.resources.Geometry;
    import flash.display.Bitmap;
    
    import flash.display.Loader;
    import flash.system.LoaderContext;
    import flash.display.Sprite;
    import flash.display.Stage3D;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.net.URLLoader;
    import flash.net.URLLoaderDataFormat;
    import flash.net.URLRequest;
    import flash.display.BitmapData;
    
    import alternativa.engine3d.lights.*;
    
    import flash.geom.Vector3D;
    
    public class Test extends Sprite {
        
        private var scene:Object3D = new Object3D();
        private var camera:Camera3D;
        private var controller:SimpleObjectController;
        private var stage3D:Stage3D;
        private var mesh:Mesh;
        
        private var diffmap:BitmapTextureResource;
        private var bumpmap:BitmapTextureResource;
        private var specmap:BitmapTextureResource;
        private var shinmap:BitmapTextureResource;
        private var transmap:BitmapTextureResource;
                
        public function Test() 
        {
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            camera = new Camera3D(1, 1000);
            camera.view = new View(stage.stageWidth, stage.stageHeight, false, 0, 0, 4);
            addChild(camera.view);
            addChild(camera.diagram);
            
            // Initial position
            camera.x = 2;
            camera.z = 5;
            camera.y = 5;
            controller = new SimpleObjectController(stage, camera, 50);
            controller.lookAt(new Vector3D(0,0,0));
            scene.addChild(camera);
            
            // Light sources
            var ambientLight:AmbientLight = new AmbientLight(0x333333);
            scene.addChild(ambientLight);
            var directionalLight:DirectionalLight = new DirectionalLight(0xFFFFFF);
            directionalLight.z = 10;
            directionalLight.y = 10;
            directionalLight.x = 10;
            directionalLight.lookAt(0, 0, 0);
            scene.addChild(directionalLight);
            
            stage3D = stage.stage3Ds[0];
            stage3D.addEventListener(Event.CONTEXT3D_CREATE, onContextCreate);
            stage3D.requestContext3D();            
        }
        
        private function onContextCreate(e:Event):void {
            stage3D.removeEventListener(Event.CONTEXT3D_CREATE, onContextCreate);
            
            onA3DLoad(null);

            stage.addEventListener(Event.ENTER_FRAME, onEnterFrame);
            stage.addEventListener(Event.RESIZE, onResize);
            onResize();
        }
        
        private function onA3DLoad(e:Event):void {
            var parser:ParserA3D = new ParserA3D();
            parser.parse(new model().data);            
            mesh = parser.getObjectByName("Crate") as Mesh;
            mesh.calculateBoundBox();
            mesh.geometry.calculateNormals();
            mesh.geometry.calculateTangents(0);
            scene.addChild(mesh);
            setMaterials(mesh);
            uploadResources(scene.getResources(true));
        }
        
        private function setMaterials(mesh:Mesh):void
        {
            //do my strange way of loading textures because i had problems...
            
            var diffldr:Loader = new Loader;
            diffldr.load(
                new URLRequest("http://assets.wonderfl.net/images/related_images/e/e5/e5ec/e5eccb206c9a284840426ecd8574c68ed7d4dca1"),
                new LoaderContext( true )
            );
            diffldr.contentLoaderInfo.addEventListener( Event.COMPLETE, function(e :Event) :void {     
                var bd:BitmapData = new BitmapData(diffldr.width,diffldr.height);
                bd.draw( diffldr );
                diffmap = new BitmapTextureResource(bd);
                setMat();
            });
            
            var bumpldr:Loader = new Loader;
            bumpldr.load(
                new URLRequest("http://assets.wonderfl.net/images/related_images/2/2d/2d16/2d167846d5b3a9105d674d77dcbcae3faf5aa0a6"),
                new LoaderContext( true )
            );
            bumpldr.contentLoaderInfo.addEventListener( Event.COMPLETE, function(e :Event) :void {            
                var bd:BitmapData = new BitmapData(bumpldr.width,bumpldr.height);
                bd.draw( bumpldr );
                bumpmap = new BitmapTextureResource(bd);
                setMat();
            });
            
            var specldr:Loader = new Loader;
            specldr.load(
                new URLRequest("http://assets.wonderfl.net/images/related_images/c/c0/c003/c003a071d20c6e91bf028b1771eb2725688d91cf"),
                new LoaderContext( true )
            );
            specldr.contentLoaderInfo.addEventListener( Event.COMPLETE, function(e :Event) :void {            
                var bd:BitmapData = new BitmapData(specldr.width,specldr.height);
                bd.draw( specldr );
                specmap = new BitmapTextureResource(bd);
                setMat();
            });
            
            var shinldr:Loader = new Loader;
            shinldr.load(
                new URLRequest("http://assets.wonderfl.net/images/related_images/2/2b/2b04/2b04eb769af27beb5dbeaa1afb614bc7020b6dda"),
                new LoaderContext( true )
            );
            shinldr.contentLoaderInfo.addEventListener( Event.COMPLETE, function(e :Event) :void {            
                var bd:BitmapData = new BitmapData(shinldr.width,shinldr.height);
                bd.draw( shinldr );
                shinmap = new BitmapTextureResource(bd);
                setMat();
            });
            
            var transldr:Loader = new Loader;
            transldr.load(
                new URLRequest("http://assets.wonderfl.net/images/related_images/c/c0/c019/c0190751647ea4ddee63f852bab67ab4406dc66d"),
                new LoaderContext( true )
            );
            transldr.contentLoaderInfo.addEventListener( Event.COMPLETE, function(e :Event) :void {            
                var bd:BitmapData = new BitmapData(transldr.width,transldr.height);
                bd.draw( transldr );
                transmap = new BitmapTextureResource(bd);
                setMat();
            });
        }
        
        private function setMat():void
        {
            var sm:StandardMaterial = new StandardMaterial(diffmap, bumpmap, specmap, shinmap, transmap);
            sm.alphaThreshold = 1;
            mesh.setMaterialToAllSurfaces(sm);
            uploadResources(mesh.getResources(true));
        }
        
        private function uploadResources(resources:Vector.<Resource>):void {
            for each (var resource:Resource in resources) {
                resource.upload(stage3D.context3D);
            }
        }

        private function onEnterFrame(e:Event):void 
        {
            if (mesh != null) {
                mesh.rotationX += 0.01;
                mesh.rotationY += 0.01;
            }
            controller.update();
            camera.render(stage3D);
        }
        
        private function onResize(e:Event = null):void {
            camera.view.width = stage.stageWidth;
            camera.view.height = stage.stageHeight;
        }
    }
}

import flash.utils.ByteArray;

class model extends Object
{
    private var b:String = "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";
    public var data:ByteArray = new ByteArray();
    
    public function model():void
    {
        data = new Base64(b);
    }

}

// base64 code by 2ndyofyyx,
// http://wonderfl.kayac.com/code/b3a19884080f5ed34137e52e7c3032f3510ef861

import flash.utils.ByteArray; 
class Base64 extends ByteArray { 
    private static const BASE64:Array = [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,0,0,0,63,52,53,54,55,56,57,58,59,60,61,0,0,0,0,0,0,0,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,0,0,0,0,0,0,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,0,0,0,0,0]; 
    public function Base64(str:String) { 
        var n:int, j:int; 
        for(var i:int = 0; i < str.length && str.charAt(i) != "="; i++) {
            if (str.charCodeAt (i) < 33) continue;
            j = (j << 6) | BASE64[str.charCodeAt(i)]; 
            n += 6; 
            while(n >= 8) { 
                writeByte((j >> (n -= 8)) & 0xFF); 
            } 
        } 
        position = 0; 
    } 
}