/**
 * Copyright Desuade ( http://wonderfl.net/user/Desuade )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hrSl
 */

// forked from Desuade's Desuade Partigen 2.1 Introduction Example Base File
// forked from mash's Desuade Partigen 2.1 Introduction Examples
/*

Desuade Partigen 2.1 Introduction Examples
http://desuade.com/partigen

This .fla goes over the basics of how to use Emitters with Partigen and the Desuade Motion Package

IMPORTANT!
Understanding of the Motion Package's MotionControllers is necessary. Working knowledge of the tween, sequencing, and physics classes is also highly recommended.
While it is possible to jump right in without it and be fine, this .fla assumes you are familiar with these before getting started.

////Overview////

This is an introduction to the Desuade Partigen API. It's recommended to have access to 
the official API docs as you're working along.

Partigen uses concepts (as well as the library itself) from the Motion Package such as 
MotionControllers heavily, as the DMP was designed with Partigen in mind.

In Partigen 1, there was a defined set of properties that could be changed for particles, 
with only a beginning and end value, and only a few offered random ranges. While this made 
it straightforward for novices, expert developers were looking for more freedom.

Thus the concept of MotionControllers was born, even before Partigen 1 was finished. This 
core architecture design allows for unlimited amount of tweens on each property during a 
particle's life - for any of the particle's tweenable properties.

While this comes with a bit more required code, much of it is duplicatable 
across emitters and provides incredible value. Also, since everything is dynamic, file 
size has decreased considerably, from the original default standard size of 40k, to an 
average of 20k (for all the libraries) - that includes and entire tween and physics engine, as 
well as the entire Partigen engine. The minimum is around 5k (this excludes controllers, etc).

If you're migrating from 1.x/AS2, there is very little in common with the old API besides 
some general concepts. Partigen 2 is a revolutionary new framework that's here to stay, 
with an architecture and syntax that is open to the future and community contributions.


////Usage////

Components of Partigen 2:

Renderers: these control how the particles are displayed
Pools: this manages the actual particle objects in memory
Events: particle events
Particles: these are dynamic objects that get created by emitters
Emitters: creates, manages, and configures particles


On average, the majority of your time with Partigen will be spent with emitters and their controllers.
Each emitter creates two "master controllers" by default:

emitter.controllers.emitter //this controls the properties of the emitter itself when start() is called
emitter.controllers.particle //this controls the properties of new particles


Any property under those will be the actual property being controlled.

For example:

emitter.controllers.particle.x //controls each particle's x value
emitter.controllers.particle.alpha //controls each particle's alpha value
emitter.controllers.emitter.x //controls the emitter's x value

-----

>To create emitter controllers, use one of the following methods on emitter.controllers.emitter:

addTween(property:String, duration:Number)
addPhysics(property:String, duration:Number, flip:Boolean = false)
addBeginValue(property:String, value:*, spread:* = 0, precision:* = 0, extras:* = null)

These methods will either create an EmitterTweenController or an EmitterePhysicsController
Each inherits a real MotionController or a PhysicsMultiController respectivly.


>To create particle controllers, use one of the following methods on emitter.controllers.particle:

addTween(property:String, duration:Number = 0)
addColorTween(property:String = "color", duration:Number = 0)
addPhysics(property:String, duration:Number = 0, flip:Boolean = false)
addBeginValue(property:String, value:*, spread:* = 0, precision:* = 0, extras:* = null)

These methods will either create a ParticleTweenController or a ParticlePhysicsController
Each resembles a MotionController or a PhysicsMultiController respectivly.


These controllers work the same way as MotionControllers from the Motion Package, so each 
one has a keyframes property than can be used to create more intricate effects:

emitter.controllers.particle.x.keyframes;

-----

The emitter has an angle and angleSpread property that is only used for ParticlePhysicsControllers
and will effect all Physics-based properties unless explicitly set not to via the 'useangle' property
on the given ParticlePhysicsController.


Emitters are controlled by start() and stop() methods, and do just what they say.
These methods also start and stop any controllers in my_emitter.controllers.emitter

-----

To make a custom Particle, simply create your class/Sprite/MovieClip and extend the partigen Particle class.
Then asign that class to the emitter:

my_em.particle = CustomParticle;


Consult the official API docs for more details http://api.desuade.com/. The examples in this .fla should provide a majority of common approaches.

*/

package {

	import flash.display.*;
	
	public class partigen_intro extends MovieClip {
	
		public function partigen_intro()
		{
			super();

			//you may want to disable debugging or set the level lower if the traces don't get overwhelming

			//fla setup
			stop();
			import flash.display.MovieClip;
			import flash.display.StageAlign;
			import flash.display.StageScaleMode;
			import flash.display.BitmapData;
			stage.align = StageAlign.TOP_LEFT;
			stage.scaleMode = StageScaleMode.NO_SCALE;

			//This is for all the debugging classes
			import com.desuade.debugging.*;
			import com.desuade.partigen.*;
			import com.desuade.motion.*;

			Debug.load(new DebugCodesPartigen()); //load partigen debug codes
			Debug.load(new DebugCodesMotion()); //load motion codes
			Debug.level = 50000;
			//Debug.enabled = true; //comment this out or set it to false to disable debugging
			//Debug.onlyCodes = true;

			import com.desuade.partigen.emitters.*;
			import com.desuade.partigen.particles.*;
			import com.desuade.partigen.controllers.*;
			import com.desuade.partigen.renderers.*;
			import com.desuade.partigen.pools.*;
			import com.desuade.partigen.events.*;

			import com.desuade.motion.eases.*;
			import com.desuade.motion.controllers.*
			import com.desuade.motion.events.*
			import com.desuade.utils.*


			var t1:MovieClip = new MovieClip(); //make a container for particles for the renderer
			addChild(t1);

			var sr:Renderer = new StandardRenderer(t1, 'top'); //by default, emitters create nullpools and nullrenderes. let's make a StandardRenderer to share between all of them

			////
			//demos emitter controllers and physics angle
			var em6:Emitter = new Emitter();
			em6.x = 100;
			em6.y = 50;
			em6.particle = CircleParticle;
			em6.renderer = sr;
			em6.eps = 10;
			em6.angle = 0;
			//em6.angleSpread = '40'; this makes an angle between whatever the angle is and angle+40
			em6.life = 1;
			em6.lifeSpread = '1';
			em6.controllers.particle.addPhysics('y', 0, true);
			em6.controllers.particle.y.velocity.keyframes.begin.value = 3;
			em6.controllers.particle.y.acceleration.keyframes.begin.value = -0.1;
			em6.controllers.particle.addPhysics('x');
			em6.controllers.particle.x.velocity.keyframes.begin.value = 5;
			em6.controllers.particle.x.acceleration.keyframes.flatten(0.1);
			em6.controllers.particle.addBeginValue('scale', .75, '0', 2);
			em6.controllers.emitter.addTween('y', 5).setSingleTween('0', '0', 200, '100', 'easeOutBounce');
			em6.controllers.emitter.addTween('angle', 10).setSingleTween('0', 0, 360, '0');
			em6.start();
			
		}
	
	}

}

import flash.display.Sprite;
class CircleParticle extends Sprite {
	public function CircleParticle() {
		super();
		this.graphics.beginFill(0x222222);
		this.graphics.drawCircle(0,0,5);
	}
}
