/**
 * Copyright WLAD ( http://wonderfl.net/user/WLAD )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hqtq
 */

package 
{
    import flash.geom.Point;
    import flash.events.MouseEvent;
    import flash.events.Event;
    import flash.display.Sprite;
    
    public class Main extends Sprite 
    {
        private var c:StageControl;
        
        public function Main() 
        {
            if(stage) init();
            else this.addEventListener(Event.ADDED_TO_STAGE,init);}
            private function init(e:Event = null):void{inittrace(stage);
            
                        
            //Code...
            
            c = new StageControl(stage);            
            this.addEventListener(Event.ENTER_FRAME,onFrame);   

            initWaves();                
        }
        
        private var red:WaveLine;
        
        private function initWaves():void
        {
            red = new WaveLine(c.w,80,0xFF0000);
            addChild(red);
            red.y = c.h / 2;
            
            trace("Move mouse along the X-axis");
               
            //temp
            //red.draw(c.timeStep);
        }
        private function onFrame(e:Event):void
        {
            red.d = (mouseX - 465/2) / (465/2);
            
            red.draw(c.timeStep);
        }
    }
}
import flash.geom.*;
import flash.events.*;
import flash.display.*;
import flash.utils.Dictionary;

import flash.text.TextField;
import flash.text.TextFormat;



class WaveLine extends Sprite
{
    private var w:Number,h:Number,c:uint;
    
    private var v:Vector.<Number>;
    
    ///Width, Height, Color
    public function WaveLine(w:Number,h:Number,c:uint)
    {
        this.w = w;
        this.h = h;
        this.c = c;
        
        v = new Vector.<Number>();
        v.push(0,1,0,1,0);
        
        g = this.graphics;
    }
    private var g:Graphics;
    
    
    //Num of points
    private var n:uint = 8;
    //Line position. range [0,1]
    private var l:Number = 0.3;
    //Pulse size in pixels.
    private var p:Number = 30;
    //Pulse difference.
    public var d:Number = 1;
    
    
    //Step. in milisecounds.
    private var s:uint = 0;
    //Frequency. in Hz
    private var f:uint = 2;
    //Line frequency. in Hz.
    private var a:Number = .25;
    
    
    ///ms - Time step in meilisecounds.
    public function draw(ms:uint):void
    {
        
        //Calc time.
        s += ms;
        var time:Number = 1 / f;
        
        //trace(f,"Hz = ",time,"s ");
        
        
        var n1:uint = n - 1;
        var n2:Number = n1 / 2;
        
        //Current node position.
        var pos:Number = l * w;
        //Current node value. range [0.3 - 1.0]
        var nod:Number;
        //Node step.
        var stp:Number;
        //Node heigth. range [0,1]
        var hei:Number;
        //Min / Max node bound.
        var bnd:Number;
        //Node Length.
        var lng:Number;
        
        g.clear();
        g.lineStyle(3,c);
        g.moveTo(0,0);
        if(pos > 0) g.lineTo(pos,0);
        
        for(var i:int = 0; i < n; ++i)
        { 
            nod = ((i <= n2 ? i / n2 : (n1 - i) / n2) * .7 + .3);
            stp = p * nod;
            hei = (i % 2 == 0 ? 1 : -1) * nod;
            bnd = -h * hei * d;
            lng = p * nod;

            //Draw
            g.curveTo(
              // X                 Y
                pos,              bnd,    // top/bottom left point
                pos + lng / 2,    bnd     // top middle point
            ); g.curveTo(
                pos + lng,        bnd,    // top/bottom rigth point
                pos + lng,        0       // next point on line
            );
            pos += stp;            
        }
        
        if(pos < w) g.lineTo(w,0);        
        
    }
}

class StageControl
{
    public function keyDown(keyCode:int):Boolean
    {
        return keyCodes[keyCode];    
    }

    
    /*
     _   _            _       _     _           
    | | | |          (_)     | |   | |          
    | | | | __ _ _ __ _  __ _| |__ | | ___  ___ 
    | | | |/ _` | '__| |/ _` | '_ \| |/ _ \/ __|
    \ \_/ / (_| | |  | | (_| | |_) | |  __/\__ \
     \___/ \__,_|_|  |_|\__,_|_.__/|_|\___||___/*/
    
    //Mouse is dowm
    public var mouseDown:Boolean = false;
    //Current mouse position
    public var mouse:Point = null;
    //Previus frame mouse pos
    public var mousePrev:Point = null;

    public var keyCodes:Dictionary;
    public var keyChars:Dictionary;
    public var keyAlt:Boolean = false;
    public var keyCtrl:Boolean = false;
    public var keyShift:Boolean = false;



    public var stage:Stage = null;
    //w - stageWidth
    //h - stageHeight
    public var w:Number = 1, h:Number = 1;
    public var timeStep:uint = 0;

        /*
         _____      _ _   
        |_   _|    (_) |  
          | | _ __  _| |_ 
          | || '_ \| | __|
         _| || | | | | |_ 
         \___/_| |_|_|\__|*/
          
    public function StageControl(stage:Stage)
    {
        initStage(stage);
        initEvents();
    }
    
    private function initStage(stage:Stage):void
    {
        this.stage = stage;
        
        w = stage.stageWidth;
        h = stage.stageHeight;
         
        stage.frameRate = 20;
        
        timeStep = uint(1000 / stage.frameRate);
        
        var g:Graphics = (stage.getChildAt(0) as Sprite).graphics;
        
        g.clear();
        g.beginFill(0x000000);
        g.drawRect(0,0,w,h);
        g.endFill();
    }    
    private function initEvents():void
    {
        keyCodes = new Dictionary(true);
        keyChars = new Dictionary(true);
        
        stage.addEventListener(MouseEvent.MOUSE_DOWN,onMouseDown);
        stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
        stage.addEventListener(KeyboardEvent.KEY_UP, onKeyUp);
    }
    /*
     _____                _       
    |  ___|              | |      
    | |____   _____ _ __ | |_ ___ 
    |  __\ \ / / _ \ '_ \| __/ __|
    | |___\ V /  __/ | | | |_\__ \
    \____/ \_/ \___|_| |_|\__|___/*/
         
    private function onMouseDown(e:MouseEvent):void
    {
        if(mouse) mousePrev = mouse.clone();
        mouse = new Point(stage.mouseX,stage.mouseY);
        if(!mousePrev) mousePrev = mouse.clone();
        
        stage.removeEventListener(MouseEvent.MOUSE_DOWN,onMouseDown);
        stage.addEventListener(MouseEvent.MOUSE_UP,onMouseUp);
        stage.addEventListener(MouseEvent.MOUSE_MOVE,onMouseMove);
    }
    private function onMouseUp(e:MouseEvent):void
    {
        stage.removeEventListener(MouseEvent.MOUSE_UP,onMouseUp);
        stage.addEventListener(MouseEvent.MOUSE_DOWN,onMouseDown);
        stage.removeEventListener(MouseEvent.MOUSE_MOVE,onMouseMove);
    }
    private function onMouseMove(e:MouseEvent):void
    {
        mousePrev = mouse.clone();
        mouse = new Point(stage.mouseX,stage.mouseY);
    }
    
    private function onKeyDown(e:KeyboardEvent):void
    {
        keyCtrl = e.ctrlKey;
        keyAlt = e.altKey;
        keyShift = e.shiftKey;
        keyCodes[e.keyCode] = true;
        keyChars[e.charCode] = true;
    }
    private function onKeyUp(e:KeyboardEvent):void
    {
        keyCtrl = e.ctrlKey;
        keyAlt = e.altKey;
        keyShift = e.shiftKey;
        keyCodes[e.keyCode] = false;
        keyChars[e.charCode] = false;
    }
}


import flash.text.TextField;
import flash.text.TextFormat;
/////  WONDERFL TRACE /////
function inittrace(s:Stage):void{WTrace.initTrace(s);}var trace:Function;class WTrace{

    private static var FONT:String = "_sans";
    private static var SIZE:Number = 12;
    private static var SPACE:String = " ";
    private static var COLOR:uint = 0xFFFFFF;
    private static var LINES:uint = 6;

private static var TextFields:Array = [];private static var trace_stage:Stage;
public static function initTrace(stg:Stage):void{trace_stage = stg;trace = wtrace;}
private static function scrollup():void{if (TextFields.length > LINES){
var removeme:TextField = TextFields.shift();trace_stage.removeChild(removeme);removeme = null;
}for(var x:Number=0;x<TextFields.length;x++){(TextFields[x] as TextField).y -= SIZE*1.2;}}
public static function wtrace(... args):void{var s:String="";var tracefield:TextField;
for (var i:int;i < args.length;i++){if (i != 0) s+=SPACE;s+=args[i].toString();}
tracefield= new TextField();tracefield.autoSize = "left";tracefield.textColor = COLOR;
tracefield.text = s;tracefield.y = trace_stage.stageHeight - 20;
var tf:TextFormat = new TextFormat(FONT, SIZE);tracefield.setTextFormat(tf);
trace_stage.addChild(tracefield);scrollup();TextFields.push(tracefield);}}