/**
 * Copyright yanbaka ( http://wonderfl.net/user/yanbaka )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hqiO
 */

package
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.filters.BlurFilter;
	
	[SWF(width = "465", height = "465", backgroundColor = "0x000000", frameRate = "30")]
	public class Eyes extends Sprite
	{
		private const NUM:uint = 100;
		private var eyes:Array = [];
		
		public function Eyes()
		{
			init();
			
			var eye:Eye;
			for (var i:uint=0; i<NUM; i++)
			{
				eye = new Eye();
				eye.x = Math.random()*stage.stageWidth;
				eye.y = Math.random()*stage.stageHeight;
				addChild(eye);
				eyes.push(eye);
			}
			
			addEventListener(Event.ENTER_FRAME, loop);
		}
		
		private function loop(e:Event):void
		{
			var eye:Eye;
			var dx:Number;
			var dy:Number;
			var angle:Number;
			var vx:Number;
			var vy:Number;
			var dist:Number;
			for (var i:uint = 0; i<NUM; i++)
			{
				eye = eyes[i];
				dx = mouseX - eye.x;
				dy = mouseY - eye.y;
				angle = Math.atan2(dy, dx);
				dist = Math.sqrt(dx*dx + dy*dy);
				vx = Math.cos(angle)*dist/40;
				vy = Math.sin(angle)*dist/40;
				eye.getEyeball().x = vx;
				eye.getEyeball().y = vy;
				
				eye.x += Math.random()*4-2;
				eye.y += Math.random()*4-2;
			}			
		}

	}
}
	import flash.display.Sprite;
	

class Eye extends Sprite
{
	private var eyeball:Sprite;
	private var msk:Sprite;
	
	public function Eye():void
	{
		graphics.beginFill(0xDDDDDD);
		graphics.drawCircle(0, 0, 20);
		graphics.endFill();
		
		eyeball = new Sprite();
		eyeball.graphics.beginFill(0x333333);
		eyeball.graphics.drawCircle(0, 0, 10);
		eyeball.graphics.endFill();
		addChild(eyeball);
		
		msk = new Sprite();
		msk.graphics.beginFill(0xFFFFFF);
		msk.graphics.drawCircle(0, 0, 20);
		msk.graphics.endFill();
		addChild(msk);
		eyeball.mask = msk;
	}
	
	public function getEyeball():Sprite
	{
		return eyeball;
	}
}