/**
 * Copyright h_kamizono ( http://wonderfl.net/user/h_kamizono )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hq6z
 */

// forked from h_kamizono's test
package {
    import flash.display.AVM1Movie;
    import flash.display.MovieClip;
    import flash.display.Sprite;
    import flash.display.DisplayObject
    import flash.events.MouseEvent;
    import flash.geom.Point;
    public class ObjectLink extends MovieClip {
        
        public var base:Sprite = new Sprite();
        public var selectedStringObject:TheStringObject = null;
        public var selectedLineObject:TheLineObject = null;
        private var textArea:TheTextArea;
        public function ObjectLink() {
            // write as3 code here..
            textArea = new TheTextArea();
            textArea.x = stage.stageWidth - textArea.width;
            
            var makeObjBt:FMButton = new FMButton("make object", 80);
            makeObjBt.x = 0;//372;
            makeObjBt.y = 400;//600;
            makeObjBt.addEventListener(MouseEvent.CLICK, addStringObject);
            
            var makeLineBt:FMButton = new FMButton("make line", 80);
            makeLineBt.x = 0;//472;
            makeLineBt.y = 420;//600;
            makeLineBt.addEventListener(MouseEvent.CLICK, addLineObject);
            
            var deleteBt:FMButton = new FMButton("delete", 80);
            deleteBt.x = 0;
            deleteBt.y = 440;
            deleteBt.addEventListener(MouseEvent.CLICK, deleteObject);
            
            addChild(makeObjBt);
            addChild(makeLineBt);
            addChild(deleteBt);
            addChild(base);
            addChild(textArea);
            stage.addEventListener(MouseEvent.MOUSE_DOWN, onMDown);
        }
        
        public function addStringObject(ev:MouseEvent) :void {
            var to = base.addChild(new TheStringObject());
            to.x = 250;//512;
            to.y = 150;//300;
            xmlOut(); 
        }
        
        public function addLineObject(ev:MouseEvent) :void {
            var ll = base.addChild(new TheLineObject());
            ll.startPt.x = 212;
            ll.startPt.y = 140;
            ll.endPt.x = 312;
            ll.endPt.y = 240;
            xmlOut();
        }
        
        public function onMDown(ev:MouseEvent) :void {
            if (ev.target is FMButton || ev.target is TheTextArea) {
                
            } else if (ev.target is TheLineObject) {
                selectedStringObject = null;
                selectedLineObject = TheLineObject(ev.target);
            } else if (ev.target is TheStringObject ||
                       ev.target.parent is TheStringObject) {
                selectedLineObject = null;
                if (ev.target is TheStringObject)
                    selectedStringObject = TheStringObject(ev.target);
                if (ev.target.parent is TheStringObject)
                    selectedStringObject = TheStringObject(ev.target.parent);   
            } else {
                allCancel();
                allDragMode();
            }
        }
        
        public function allCancel() :void {
            selectedLineObject = null;
            selectedStringObject = null;
            allRedOff();
        }
        
        public function allRedOff() :void {
            for (var i:Number = 0; i < base.numChildren; ++i) {
                if (base.getChildAt(i) is TheStringObject) {
                    var to:TheStringObject = TheStringObject(base.getChildAt(i));
                    to.redOff();
                }
                if (base.getChildAt(i) is TheLineObject) {
                    var tl:TheLineObject = TheLineObject(base.getChildAt(i));
                    tl.redOff();
                }
            }
        }
       
        public function allDragMode() :void {
           for (var i:Number = 0; i < base.numChildren; ++i) {
               if (base.getChildAt(i) is TheStringObject) {
                   var to:TheStringObject = TheStringObject(base.getChildAt(i));
                   to.dragMode();
               }
           }
        }
        
        public function redCheck(pt:Point, r:Number) :void {
            for (var i:Number = 0; i < base.numChildren; ++i) {
               if (base.getChildAt(i) is TheStringObject) {
                   var to:TheStringObject = TheStringObject(base.getChildAt(i));
                   if (Point.distance(pt, new Point(to.x, to.y)) < r) {
                       to.redOn();
                   } else {
                       to.redOff();
                   }
               }
            }
        }
        
        public function allDelete() :void {
            var num:Number = base.numChildren;
            for (var i:Number = 0; i < num; ++i) {
                if (base.getChildAt(0) is TheStringObject) {
                    TheStringObject(base.getChildAt(0)).free();
                }
                if (base.getChildAt(0) is TheLineObject) {
                    TheLineObject(base.getChildAt(0)).free();
                }
                base.removeChild(base.getChildAt(0));
            }
            xmlOut();
        }
        
        public function deleteObject(ev:MouseEvent) :void {
            if (selectedStringObject != null) {
                for (var i:Number = 0; i < base.numChildren; ++i) {
                    if (base.getChildAt(i) is TheLineObject) {
                        var ll:TheLineObject = TheLineObject(base.getChildAt(i));
                        if (ll.startObj == selectedStringObject) {
                            ll.startObj = null;
                        }
                        if (ll.endObj == selectedStringObject) {
                            ll.endObj = null;
                        }
                    }
                }
                selectedStringObject.free();
                base.removeChild(selectedStringObject);
                selectedStringObject = null;
            }
            if (selectedLineObject != null) {
                selectedLineObject.free();
                base.removeChild(selectedLineObject);
                selectedLineObject = null;
            }
            xmlOut();
        }
        
        public function xmlOut() :void {
            var theXML:XML = new XML("<data />");
            var nodes:XML = new XML("<nodes />");
            theXML.appendChild(nodes);
            for (var i:Number = 0; i < base.numChildren; ++i) {
                if (base.getChildAt(i) is TheStringObject) {
                    var to:TheStringObject = TheStringObject(base.getChildAt(i));
                    nodes.appendChild(new XML("<node id = " + i +
                                      "'type='string' x='" + to.x +
                                      "' y='" + to.y +
                                      "'text='" + to.getText() + "'/>'"));
                }
                if (base.getChildAt(i) is TheLineObject) {
                    var tll:TheLineObject = TheLineObject(base.getChildAt(i));
                    nodes.appendChild(new XML("<node id='" + i +
                                      "' type='line' statX='" + tll.startPt.x +
                                      "' startY='" + tll.startPt.y +
                                      "' endX='" + tll.endPt.x + "' endY='" +
                                      tll.endPt.y + "' />"));
                }
            }
            var relation:XML = new XML("<relation />");
            theXML.appendChild(relation);
            for (var j:Number = 0; j < base.numChildren; ++j) {
                if (base.getChildAt(j) is TheLineObject) {
                    var tll2:TheLineObject = TheLineObject(base.getChildAt(j));
                    var st:String = " ";
                    if (tll2.startObj == null) {
                        st += "startObjID ='-1' ";
                    } else {
                        var theID:Number = base.getChildIndex(tll2.startObj);
                        st += "startObjID='" + theID + "' ";
                    }
                    if (tll2.endObj == null) {
                        st += "endObjID ='-1' ";
                    } else {
                        var theID2:Number = base.getChildIndex(tll2.endObj);
                        st += "endObjID='" + theID2 + "' ";
                    }   
                    relation.appendChild(new XML(">relation lineID='" + j +
                                       "'" + st + "/>"));
                }
            }
            if (textArea != null) textArea.setText(theXML.toString());
        }
        
        public function xmlLoad(st:String) :void {
            var theXML:XML = new XML();
            allDelete();
            for each (var nodes:XML in theXML.nodes) {
                for each (var node:XML in nodes.node) {
                    if (node.@type == "string") {
                        var to:TheStringObject = 
                            TheStringObject(base.addChild(
                                new TheStringObject()));
                        to.x = int(node.@x);
                        to.y = int(node.@y);
                        to.setText(node.@text);
                    }
                    if (node.@type == "line") {
                        var ll:TheLineObject = 
                            TheLineObject(base.addChild(new TheLineObject()));
                        ll.startPt.x = int(node.@startX);
                        ll.startPt.y = int(node.@startY);
                        ll.endPt.x = int(node.@endX);
                        ll.endPt.y = int(node.@endY);
                    }
                }
            }
            for each (var relations:XML in theXML.relation) {
                for each (var relation:XML in relations.relation) {
                    if (base.getChildAt(relation.@lineID) is TheLineObject) {
                        var ll2:TheLineObject = 
                            TheLineObject(base.getChildAt(relation.@lineID));
                        if (int(relation.@startObjID) >= 0) {
                            if (base.getChildAt(relation.@startObjID) is TheStringObject) {
                                ll2.startObj = TheStringObject(
                                    base.getChildAt(relation.@startObjID));
                            }
                        }
                        if (int(relation.@endObjID) >= 0) {
                            if (base.getChildAt(relation.@endObjID)
                                is TheStringObject) {
                                ll2.endObj = TheStringObject(
                                    base.getChildAt(relation.@endObjID));
                            }
                        }
                    }
                }
            }
            xmlOut();
        }
    }
}

import flash.display.FrameLabel;
import flash.media.Sound;
import flash.utils.Proxy;
import flash.utils.SetIntervalTimer;

import flash.display.Sprite;
import flash.text.TextField;
import flash.text.TextFormat;
import flash.text.TextFieldType;
import flash.text.TextFieldAutoSize;
import flash.utils.Timer;
import flash.events.TimerEvent;
import flash.events.KeyboardEvent;
import flash.events.MouseEvent;

class TheStringObject extends Sprite {
    private var sentence:TextField = new TextField();
    private var redValue:Number = 0;
    private var redFlag:Boolean = false;
    private var timer:Timer = new Timer(33);
    
    public function TheStringObject(st:String = "No title") {
        this.mouseChildren = false;
        var tf:TextFormat = sentence.getTextFormat();
        tf.size =12;
        tf.font = "Verdana";
        sentence.defaultTextFormat = tf;
        sentence.border = false;
        sentence.borderColor = 0x000000;
        sentence.x = -sentence.width/2;
        sentence.y = -sentence.height/2 - 15;
        sentence.text = st;
        addChild(sentence);
        
        this.doubleClickEnabled = true;
        this.addEventListener(MouseEvent.DOUBLE_CLICK, toEditMode);
        this.addEventListener(MouseEvent.MOUSE_DOWN, onMDown);
        this.addEventListener(MouseEvent.MOUSE_UP, onMUp);
        timer.addEventListener(TimerEvent.TIMER, loop);
        timer.start();
    }
    
    private function onMDown(ev:MouseEvent) :void {
        if (root != null) ObjectLink(root).allRedOff();
        redOn();
        ev.target.parent.setChildIndex(
                         ev.target, ev.target.parent.numChildren - 1);
        ev.target.startDrag();
    }
    
    private function onMUp(ev:MouseEvent) :void {
        ev.target.stopDrag();
        ObjectLink(root).xmlOut();
    }
    
    private function toEditMode(ev:MouseEvent) :void {
        editMode();
    }
    
    public function redOn() :void {
        redFlag = true;
    }
    
    public function redOff() :void {
        redFlag = false;
    }
    
    public function setText(st:String) :void {
        sentence.text = st;
    }
    
    public function getText() :String {
        return sentence.text;
    }
    
    private function editMode() :void {
        this.removeEventListener(MouseEvent.MOUSE_DOWN, onMDown);
        this.removeEventListener(MouseEvent.MOUSE_UP, onMUp);
        this.mouseChildren = true;
        sentence.border = true;
        sentence.type = TextFieldType.INPUT;
        sentence.selectable = true;
        sentence.addEventListener(KeyboardEvent.KEY_DOWN, onKDown);
    }
    
    public function dragMode() :void {
        this.mouseChildren = false;
        sentence.border = false;
        sentence.type = TextFieldType.DYNAMIC;
        sentence.selectable = false;
        sentence.removeEventListener(KeyboardEvent.KEY_DOWN, onKDown);
        this.addEventListener(MouseEvent.MOUSE_DOWN, onMDown);
        this.addEventListener(MouseEvent.MOUSE_UP, onMUp);
    }
    
    public function free() :void {
        removeEventListeners();
        removeChild(sentence);
        sentence = null;
    }
    
    private function removeEventListeners() :void {
        this.removeEventListener(
                        MouseEvent.DOUBLE_CLICK, toEditMode);
        this.removeEventListener(MouseEvent.MOUSE_DOWN, onMDown);
        this.removeEventListener(MouseEvent.MOUSE_UP, onMUp);
        sentence.removeEventListener(KeyboardEvent.KEY_DOWN, onKDown);
        timer.removeEventListener(TimerEvent.TIMER, loop);
    }
    
    private function onKDown(ev:KeyboardEvent) :void {
        sentence.x = -sentence.width/2;
        if (ev.keyCode == 13) {
            dragMode();
        }
    }
    
    private function loop(ev:TimerEvent) :void {
        if (redFlag) redValue = Math.min(redValue+0.2, 1);
        else         redValue = Math.max(redValue-0.2, 0);
        sentence.textColor = int(redValue*255) << 16 | 0 << 8 | 0;
    }
}


import flash.display.Sprite;
import flash.utils.Timer;
import flash.events.TimerEvent;
import flash.events.MouseEvent;
import flash.geom.Point;
import flash.display.CapsStyle;

class TheLineObject extends Sprite {
    public static const radius:Number = 35;
    public static const thin:Number = 6;
    public static const thick:Number = 4;
    public static const NO_DRAGGING:Number = 0;
    public static const DRAGGING_LINE:Number = 1;
    public static const DRAGGING_STARTPT:Number = 2;
    public static const DRAGGING_ENDPT:Number = 3;
    
    public var startObj:TheStringObject = null;
    public var endObj:TheStringObject = null;
    public var startPt:Point = new Point();
    public  var endPt:Point = new Point();
    
    private var preMouse:Point = new Point();
    private var draggingMode:Number = 0;
    
    private var rollovered:Boolean = false;
    private var roPar:Number = 0;
    private var redFlag:Boolean = false;
    private var redValue:Number = 0;
    
    private var timer:Timer = new Timer(33);
    
    public function TheLineObject() {
        this.addEventListener(MouseEvent.ROLL_OVER, onROver);
        this.addEventListener(MouseEvent.ROLL_OUT, onROut);
        this.addEventListener(MouseEvent.MOUSE_DOWN, onMDown);
        this.addEventListener(MouseEvent.MOUSE_UP, onMUp);
        timer.addEventListener(TimerEvent.TIMER, loop);
        timer.start();
    }
    
    private function onROver(ev:MouseEvent) :void {
        rollovered = true;
    }
    
    private function onROut(ev:MouseEvent) :void {
        rollovered = false;
    }
        
    private function onMDown(ev:MouseEvent) :void {
        ev.target.parent.setChildIndex(
                         ev.target, ev.target.parent.numChildren - 1);
        var mouse:Point = new Point(
                          ev.target.mouseX, ev.target.mouseY);
        var distS:Number = Point.distance(mouse, startPt);
        var distE:Number = Point.distance(mouse, endPt);
        if (distS < radius) {
            draggingMode = DRAGGING_STARTPT;
        } else if (distE < radius) {
            draggingMode = DRAGGING_ENDPT;
        } else {
            draggingMode = DRAGGING_LINE;
        }
        
        ObjectLink(root).allRedOff();
        redOn();
        if (startObj != null) startObj.redOn();
        if (endObj != null) endObj.redOn();

    }
    
    private function onMUp(ev:MouseEvent) :void {
        if (startObj != null) {
            var distS:Number = Point.distance(startPt,
                               new Point(startObj.x, startObj.y));
            if (distS > radius) {
                startObj = null;
            }
        }
        if (endObj != null) {
            var distE:Number = Point.distance(endPt,
                               new Point(endObj.x, endObj.y));
            if (distE > radius) {
                endObj = null;
            }
        }
        var pt:Point = null;
        if (draggingMode == DRAGGING_STARTPT) pt = startPt;
        if (draggingMode == DRAGGING_ENDPT)   pt = endPt;
        if (pt != null) {
            for (var i:Number = 0; i < ObjectLink(root).base.numChildren; ++i) {
                if (ObjectLink(root).base.getChildAt(i) is TheStringObject ) {
                    var to:TheStringObject = 
                        TheStringObject(ObjectLink(root).base.getChildAt(i));
                    if (Point.distance(pt, new Point(to.x, to.y)) < radius) {
                        if (draggingMode == DRAGGING_STARTPT) startObj = to;
                        if (draggingMode == DRAGGING_ENDPT)   endObj = to;
                    }
                }
            }
        }
        ObjectLink(root).xmlOut();
        draggingMode = NO_DRAGGING;
    }
    
    public function redOn() :void {
        redFlag = true;
    }
    
    public function redOff() :void {
        redFlag = false;
    }
    
    
    public function free() :void {
        removeEventListeners();
        startObj = null;
        endObj = null;
    }
    
    private function removeEventListeners() :void {
        this.removeEventListener(MouseEvent.ROLL_OVER, onROver);
        this.removeEventListener(MouseEvent.ROLL_OUT, onROut);
        this.removeEventListener(MouseEvent.MOUSE_DOWN, onMDown);
        this.removeEventListener(MouseEvent.MOUSE_UP, onMUp);
        timer.removeEventListener(TimerEvent.TIMER, loop);
    }
    
    public function loop(ev:TimerEvent) :void {
        if (draggingMode == DRAGGING_LINE) {
            startPt.x += root.mouseX - preMouse.x;
            startPt.y += root.mouseY - preMouse.y;
            endPt.x += root.mouseX - preMouse.x;
            endPt.y += root.mouseY - preMouse.y;
            if (startObj != null) {
                startObj.x = startPt.x;
                startObj.y = startPt.y;
            }
            if (endObj != null) {
                endObj.x = endPt.x;
                endObj.y = endPt.y;
            }
        }
        
        if (draggingMode == DRAGGING_STARTPT) {
            startPt.x += root.mouseX - preMouse.x;
            startPt.y += root.mouseY - preMouse.y;
            ObjectLink(root).redCheck(startPt, radius);
        }
        
        if (draggingMode == DRAGGING_ENDPT) {
            endPt.x += root.mouseX - preMouse.x;
            endPt.y += root.mouseY - preMouse.y;
            ObjectLink(root).redCheck(endPt, radius);
        }
        
        if (startObj != null && draggingMode == NO_DRAGGING) {
            startPt.x = startObj.x;
            startPt.y = startObj.y;
        }
        
        if (endObj != null && draggingMode == NO_DRAGGING) {
            endPt.x = endObj.x;
            endPt.y = endObj.y;
        }
        
        preMouse.x = root.mouseX; preMouse.y = root.mouseY;
        
        if (root != null) {
            if (redFlag) redValue = Math.min(redValue+0.2, 1);
            else         redValue = Math.max(redValue-0.2, 0); 
            var col:uint = int(redValue*255) << 16 | 0 << 8| 0;
            var thickness:Number = thin;
            
            if (ObjectLink(root).selectedLineObject == this || rollovered ) {
                thickness = thick;
            }
            var spt:Point = new Point();
            var ept:Point = new Point();
            var angle:Number = Math.atan2(endPt.y - startPt.y,
                                          endPt.x - startPt.x);
            spt.x = startPt.x + radius*Math.cos(angle);
            spt.y = startPt.y + radius*Math.sin(angle);
            ept.x = endPt.x - radius*Math.cos(angle);
            ept.y = endPt.y - radius*Math.sin(angle);
            
            this.graphics.clear();
            this.graphics.lineStyle(thickness, col, 1, false,
                                    "nomal", CapsStyle.NONE);
            this.graphics.moveTo(spt.x, spt.y);
            this.graphics.lineTo(ept.x, ept.y);
            
            if (rollovered || ObjectLink(root).selectedLineObject == this) {
                roPar += (1 - roPar)/4;
            } else {
                roPar += (0 - roPar)/4;
                if (roPar < 0.01) roPar = 0;
            }
            
            if (roPar != 0) {
                this.graphics.lineStyle(2, col, roPar);
                this.graphics.beginFill(0xFFFFFF, 0);
                this.graphics.moveTo(startPt.x, startPt.y);
                this.graphics.drawCircle(startPt.x, startPt.y, radius);
                this.graphics.moveTo(endPt.x, endPt.y);
                this.graphics.drawCircle(endPt.x, endPt.y, radius);
                this.graphics.endFill();
            }
        }
    }
}

import flash.display.Sprite;
import flash.text.TextField;
import flash.text.TextFormat;
import flash.text.TextFieldType;
import flash.utils.Timer;
import flash.events.TimerEvent;
import flash.events.KeyboardEvent;
import flash.events.MouseEvent;

class TheTextArea extends Sprite {
    private var sentence:TextField = new TextField();
    private var w:Number = 200;
    private var h:Number = 400;
    private var tabW:Number = 50;
    private var tabH:Number = 20;
    private var base:Sprite = new Sprite();
    private var viewFlag:Boolean = false;
    private var viewLoc:Number = 450 - h - 1;
    private var unViewLoc:Number = 450;
    private var timer:Timer = new Timer(33);
    
    public function TheTextArea() {
        this.alpha = 0.5;
        base.graphics.lineStyle(1, 0);
        base.graphics.beginFill(0x000000);
        base.graphics.moveTo(0, 0);
        base.graphics.lineTo(w - tabW, 0);
        base.graphics.lineTo(w - tabW, -tabH);
        base.graphics.lineTo(w, -tabH);
        base.graphics.lineTo(w, h);
        base.graphics.lineTo(0, h);
        base.graphics.lineTo(0, 0);
        addChild(base);
        
        var tf:TextFormat= sentence.getTextFormat();
        tf.size = 18;
        tf.font = "Verdana";
        tf.color = 0x00FFFF;
        sentence.setTextFormat(tf);
        //sentence.backgroundColor = 0xFFFFFF;
        sentence.border = true;
        sentence.borderColor = 0x000000;
        sentence.x = 5;
        sentence.y = 5;
        sentence.width = w - 10;
        sentence.height = h - 70;
        sentence.type = TextFieldType.INPUT;
        addChild(sentence);
        
        var loadBt:FMButton = new FMButton("load XML", 80);
        loadBt.x = w/2 - 40;
        loadBt.y = h - 40;
        addChild(loadBt);
        
        loadBt.addEventListener(MouseEvent.CLICK,
            function (ev:MouseEvent) :void {
                ObjectLink(root).xmlLoad(sentence.text);});
        base.addEventListener(MouseEvent.CLICK, tabClicked);
        timer.addEventListener(TimerEvent.TIMER, loop);
        timer.start();
    }
    
    public function setText(st:String) :void {
        sentence.text = st;
    }
    
    public function getText() :String {
        return sentence.text;
    }
    
    private function tabClicked(ev:MouseEvent) :void {
        viewFlag = !viewFlag;
        timer.start();
    }
    
    public function loop(ev:TimerEvent) :void {
        if (viewFlag) {
            this.y += (viewLoc - this.y)/4;
            if (Math.abs(this.y - viewLoc) < 2) {
                this.y = viewLoc;
                timer.stop();
            }
        } else {
            this.y += (unViewLoc - this.y)/4;
            if (Math.abs(this.y - unViewLoc) < 2) {
                this.y = unViewLoc;
                timer.stop();
            }
        }
    }
}


import flash.display.Sprite;
import flash.text.TextFormatAlign;

class FMButton extends Sprite {
    public var captionTF:TextField = new TextField();
    public var cover:Sprite = new Sprite();
    public var pressed:Sprite = new Sprite();
    public var state:Boolean = false;
    private var highlightCol:uint;
    private var pressedCol:uint;
    private var baseCol:uint;
    private var baseframeCol:uint;
    private var textCol:uint;
    public static const HIGHLIGHT_COLOR:uint = 0xCCCCCC;
    public static const PRESSED_COLOR:uint = 0xEEEEEE;
    public static const BASE_COLOR:uint = 0xAAAAAA;
    public static const BASEFRAME_COLOR:uint = 0x777777;
    public static const TEXT_COLOR:uint = 0x333333;
    public static const TEXT_SIZE:Number = 10;
    
    function FMButton(caption:String = "untitled", w:Number = 0, h:Number = 0,
                      ts:Number = TEXT_SIZE, bc:uint = BASE_COLOR, 
                      bfc:uint = BASEFRAME_COLOR, tc:uint = TEXT_COLOR,
                      pc:uint = PRESSED_COLOR, hc:uint = HIGHLIGHT_COLOR) {
        highlightCol = hc;
        pressedCol = pc;
        baseCol = bc;
        baseframeCol = bfc;
        textCol = tc;
        
        var tfm:TextFormat = captionTF.getTextFormat();
        tfm.align = TextFormatAlign.CENTER;
        tfm.font = "Times New Roman";
        tfm.size = ts;
        captionTF.defaultTextFormat = tfm;
        captionTF.text = caption;
        captionTF.textColor = textCol;
        
        if (w == 0) {
            captionTF.width = captionTF.textWidth + 30;
        } else {
            captionTF.width = w;
        }
        if (h == 0) {
            captionTF.height = captionTF.textHeight + 4;
        } else {
            captionTF.height = h;
        }
        
        var haba:Number = captionTF.width;
        var takasa:Number = captionTF.height;
        
        cover.graphics.lineStyle(1, 0);
        cover.graphics.beginFill(highlightCol);
        cover.graphics.drawRect(0, 0, haba, takasa);
        cover.graphics.endFill();
        cover.visible = false;
        addChild(cover);
        
        pressed.graphics.lineStyle(1, 0);
        pressed.graphics.beginFill(pressedCol);
        pressed.graphics.drawRect(0, 0, haba, takasa);
        pressed.graphics.endFill();
        pressed.visible = false;
        addChild(pressed);
        
        addChild(captionTF);
        
        addEventListener(MouseEvent.ROLL_OVER,
            function (ev:MouseEvent) :void {cover.visible = true;} );
        addEventListener(MouseEvent.ROLL_OUT,
            function (ev:MouseEvent) :void {cover.visible = false;} );
        addEventListener(MouseEvent.MOUSE_DOWN,
            function (ev:MouseEvent) :void {cover.visible = true;} );
        addEventListener(MouseEvent.MOUSE_UP,
            function (ev:MouseEvent) :void {cover.visible = false;} );
        
        this.graphics.lineStyle(1, 0);
        this.graphics.beginFill(baseCol);
        this.graphics.drawRect(0, 0, haba, takasa);
        this.graphics.endFill();
        
        this.mouseChildren = false;
        this.useHandCursor = true;
        this.buttonMode = true;
    }
    
    public function setCaption(st:String) :void {
        captionTF.text = st;
    }
}




