/**
 * Copyright siouxcitizen ( http://wonderfl.net/user/siouxcitizen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hosF
 */

// forked from hacker_7daxapax's PV3DTest12　：セーブ・ロード機能追加
//初期画面の諸々を隠すためタイトル画面追加。。。
//ごまかし、ごまかしでのメニューやタイトル画面。。。

//★★★　ルール　：★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
//左手奥と右手手前にある2つの取得対象(青キューブ)を取得するとクリア　
//スタート時に選択肢が3つ表示されます　↑↓ボタンで選択　Zボタンで決定
//クリア時に選択肢が3つ表示されます　↑↓ボタンで選択　Zボタンで決定
//★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★

//★★★　操作オブジェクトについて　：★★★★★★★★★★★★★★★★★★★★★★
//操作オブジェクトが取得対象にふれる(通過する？)と取得したと判定します(取得判定微妙です。。。)
//←↑→↓ボタンで操作オブジェクトを移動させます　　←　→で方向決定、↑で前進、↓で後退
//Bボタン押しながら前進・後退で移動速度3倍(手足を動かす速さは変わらず。。。)
//★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★

//★★★　カメラについて　：★★★★★★★★★★★★★★★★★★★★★★★★★★★
//W、Sボタンでカメラ位置を上下に変更(カメラのX軸回転を行います)
//A、Dボタンで操作オブジェクトを中心にカメラが回転します(カメラのY軸回転を行います)
//Fボタンで操作キャラからのカメラの距離を変更します
//Rボタンでデフォルトのカメラ設定にもどります
//★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★

package {
    import flash.display.Sprite;
    import flash.display.StageDisplayState;
    import flash.events.Event;
    import flash.events.KeyboardEvent;
 
    import org.papervision3d.objects.primitives.Plane;
    import org.papervision3d.objects.primitives.Cube;
    import org.papervision3d.objects.primitives.Sphere;
    import org.papervision3d.objects.primitives.Cylinder;

    import org.papervision3d.materials.WireframeMaterial;
    import org.papervision3d.materials.ColorMaterial;
    import org.papervision3d.materials.utils.MaterialsList;
    
    import org.papervision3d.view.Viewport3D;
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.cameras.Camera3D;
    import org.papervision3d.render.BasicRenderEngine;
    import org.papervision3d.objects.DisplayObject3D;
    
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.text.AntiAliasType;
    import flash.events.TimerEvent;
    import flash.utils.Timer;
    import flash.net.SharedObject;
    import flash.net.SharedObjectFlushStatus;

    import flash.display.Shape;
    
    [SWF(width="500", height="500", frameRate="60", backgroundColor="#111111")]
 
    public class MovieFigure extends Sprite
    {
        private var container    : Sprite;
        private var viewport     : Viewport3D;
        private var scene        : Scene3D;
        private var camera       : Camera3D;
        private var wireFramMate : WireframeMaterial;
        private var materials    : MaterialsList;
        private var planeObj     : Plane;
        private var head         : Sphere; //頭部
        private var body         : Cube; //胴体部
        private var leftHand     : Cylinder; //画面向かって左側手
        private var rightHand    : Cylinder; //画面向かって右側手
        private var leftFoot     : Cylinder; //画面向かって左側足
        private var rightFoot    : Cylinder; //画面向かって右側足
        private var renderer     : BasicRenderEngine;
        private var target01     : Cube; //取得目標
        private var target02     : Cube; //取得目標
        
        private var planeSize : int = 4000; //Planeオブジェクト1辺の長さ
        private var status : int = 0; //操作オブジェクトの表示制御用ステータス　
        private var rotat : Boolean = false; //Y軸回転判定　
        private var rotatNum : int = 0; //Y軸回転角度　
        private var wardMove : Boolean = false; //前進後退判定　
        private var wardMoveNum : int = 0; //前進後退速度
        private var walkDispInterval : int = 0; //歩行表示間隔カウンター
        private const INTERVAL: int = 24; //歩行表示間隔
        private var bDash : Boolean = false; //Bダッシュ判定
        
        private var cameraYRotStat : int = 0; //カメラのY軸回転状態　0～3　
        private var cameraXRotStat : int = 0; //カメラのX軸回転状態　0～3　
        private var cameraPitch: int = 0; //カメラのX軸回転の値　
        private var cameraYaw : int = 0; //カメラのY軸回転の値　
        private var distStat: int = 1; //カメラ設置場所の距離種類　0～2　
        
        private var textarea  : TextField; // テキスト表示部分
        private var timerCnt : int = 0; // 経過時間
        private var timer : Timer;
        
        private var keyLastSelection : Boolean = false; //キー操作をクリア後の選択肢セレクトに変更するか判定
        private var clearInfo : TextField; // クリア情報表示テキスト
        private var clearSelection : TextField; // クリア後選択肢表示
        private var lastSelection : int = 0; // クリア後選択肢管理ステータス
        private var selectionNum : int = 3; // クリア後選択肢数
        private var leastTime : int = 999; // 最短クリア時間(ハイスコア)
        
        private var keyInitSelection : Boolean = true; //キー操作をクリア後の選択肢セレクトに変更するか判定
        private var initSelecTxt : TextField; // スタート時選択肢表示
        private var initSelection : int = 0; // スタート時選択肢管理ステータス
        
        private var menuComanndKey : Boolean = true; // クリア後選択肢数   
        private var rect : Shape; //　タイトル表示用矩形領域
        private var titleText : TextField; // タイトルテキスト
                  
        //MovieFigureクラスのコンストラクタ
        public function MovieFigure():void
        {          
            //ビューポート生成
            viewport = new Viewport3D(stage.stageWidth, stage.stageHeight);
            addChild(viewport);

            //シーン生成
            scene = new Scene3D();

            //レンダリングエンジン生成
            renderer = new BasicRenderEngine();
            
            //Planeオブジェクト用ワイヤーフレームマテリアル設定
            wireFramMate = new WireframeMaterial(0x0000FF);
             
            //Planeオブジェクト生成
            planeObj= new Plane(wireFramMate, planeSize, planeSize, 4, 4);
            planeObj.rotationX = 90;
            scene.addChild(planeObj);
            
            //操作用人型オブジェクトを作成
            //胴体部オブジェクトを親として頭部・手足を子オブジェクトとして加えていく
            //胴体部をCubeオブジェクトで作成
            materials = new MaterialsList( { all : new ColorMaterial(0xFF0000) } );
            body = new Cube(materials, 150, 100, 160);
            body.y = 230;
            scene.addChild(body);
              
            //頭部をSphereでオブジェクト作成
            head = new Sphere(new ColorMaterial(0xFF7700), 65, 8, 6);
            head.y = 150;
            body.addChild(head);
            
            //Cylinderオブジェクトで手足を作成
            //画面向かって左側の手をCylinderオブジェクトで生成
            leftHand = new Cylinder(new ColorMaterial(0xFF7700),20,130);
            leftHand.x = -110;
            leftHand.y = 10;
            body.addChild(leftHand);
            
            //画面向かって右側の手をCylinderオブジェクトで生成
            rightHand = new Cylinder(new ColorMaterial(0xFF7700),20,130);
            rightHand.x = 110;
            rightHand.y = 10;
            body.addChild(rightHand);
            
            //画面向かって左側の足をCylinderオブジェクトで生成
            leftFoot = new Cylinder(new ColorMaterial(0xFF7700),30,130);
            leftFoot.x = -50;
            leftFoot.y = -160;
            body.addChild(leftFoot);
            
            //画面向かって右側の足をCylinderオブジェクトで生成
            rightFoot = new Cylinder(new ColorMaterial(0xFF7700),30,130);
            rightFoot.x = 50;
            rightFoot.y = -160;
            body.addChild(rightFoot);

            materials = new MaterialsList( { all : new ColorMaterial(0x0000FF) } );
            target01 = new Cube(materials, 150, 100, 160);
            target01.y = 230;
            target01.x = 1750;
            target01.z = -1750;
            scene.addChild(target01);

            materials = new MaterialsList( { all : new ColorMaterial(0x0000FF) } );
            target02 = new Cube(materials, 150, 100, 160);
            target02.y = 230;
            target02.x = -1750;
            target02.z = 1750;
            scene.addChild(target02);
                        
            //カメラ設定
            camera = new Camera3D();
            camera.y = 200;
            camera.target = DisplayObject3D.ZERO;    
            
            //経過時間表示のためのテキストエリア設定
            setTestareaForTimerCount();
            //タイトル情報セット
            setTextareaForTitleSelection();
            
            //タイマーイベントを設定
            timer = new Timer(1000);
            timer.addEventListener(TimerEvent.TIMER, timerHandler);
            //timer.start();

            //イベント処理用リスナを設定
            stage.addEventListener(Event.ENTER_FRAME, onEnterFrame);
            stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
            stage.addEventListener(KeyboardEvent.KEY_UP, onKeyUp);
        }

        //フレーム毎の処理
        private function onEnterFrame(e:Event):void{
            calcMove();
            renderer.renderScene(scene, camera, viewport);          
        }
        
        //設定された値をもとに操作オブジェクトの位置・表示を計算
        //フレーム毎に呼び出される
        private function calcMove():void{
            //←　→ボタンが押され続けている間、操作オブジェクトを回転させる
            if (rotat) {
               body.rotationY += rotatNum; 
            }
            //↑　↓ボタンが押され続けている間、操作オブジェクトを前進・後退させる
            if (wardMove) {
               //Bボタンが押されていないときの前進・後退は通常の移動速度
               if (!bDash) {
                   body.moveForward(wardMoveNum);
               //Bボタンが押されているときの前進・後退は通常の3倍速    
               } else {
                   body.moveForward(wardMoveNum*3);    
               }              
            }
            
            //walkDispInterval：
            //操作ボタン押下時は1の値、
            //操作ボタン押下継続中は1以上の値、
            //操作ボタンリリース時は0を設定
            
            //操作ボタンの最初の押下時の歩行表示を行う
            if(walkDispInterval == 1) {
                //歩行表示
                ctrlWaklDisp();
            }
            //操作ボタン押下継続の間、指定した間隔で歩行表示
            if((rotat || wardMove) && walkDispInterval >= 1) {
                //いずれかの操作ボタン押下継続時に歩行表示カウンタをカウントアップ
                walkDispInterval++;
                //指定したインターバルを経過時に歩行表時
                if(walkDispInterval > INTERVAL) {
                    //歩行表示
                    ctrlWaklDisp();
                    //歩行表示カウンタを2にもどす(1にもどした場合上記の最初の押下時処理を必ず通り表示がおかしくなるため)
                    walkDispInterval = 2;
                }
            }
            //カメラ視点設定            
            setCamera();
        }
        
        //カメラ視点設定
        private function setCamera():void{
            var cameraDist : int = -1000; //デフォルトの距離、ステータスは1
            if (distStat == 0) {
                cameraDist = -500;
            } else if (distStat == 1) {
                cameraDist = -1000;
            } else if (distStat == 2) {
                cameraDist = -1500;
            }
            
            //camera.x=-1000*Math.cos((90-body.rotationY)*Math.PI/180)+body.x;  
            //camera.z=-1000*Math.sin((90-body.rotationY)*Math.PI/180)+body.z;
            camera.x=cameraDist*Math.cos((90-body.rotationY)*Math.PI/180)+body.x;  
            camera.z=cameraDist*Math.sin((90-body.rotationY)*Math.PI/180)+body.z;
            camera.target.x=body.x;
            camera.target.y=body.y;
            camera.target.z=body.z;
                        
            //カメラX軸回転設定
            if (cameraXRotStat == 0) {
                cameraPitch = 90; //デフォルトのカメラの高さ
            } else if (cameraXRotStat == 1) {
                cameraPitch = 70; //デフォルトより1段階高いのカメラの高さ
            } else if (cameraXRotStat == 2) {
                cameraPitch = 50; //デフォルトより2段階高いのカメラの高さ
            } else if (cameraXRotStat == 3) {
                cameraPitch = 100; //地面近いカメラの高さ
            }
            
            //カメラY軸回転設定
            if (cameraYRotStat == 0) {
                cameraYaw = 270; //デフォルト設定のための値がわからないので、便宜的に1回転してから元の位置に戻す。。。
            } else if (cameraYRotStat == 1) {
                cameraYaw = 0;
            } else if (cameraYRotStat == 2) {
                cameraYaw = 90;
            } else if (cameraYRotStat == 3) {
                cameraYaw = 180;
            }

            camera.orbit(cameraPitch, cameraYaw, true, body);
            
            //カメラのX軸回転(カメラの上下位置)
            //camera.orbit(50, yaw, true, body);//1番高いカメラ位置
            //camera.orbit(70, yaw, true, body);//2番目に高いカメラ位置
            //camera.orbit(90, yaw, true, body);//デフォルトのカメラの高さ
            //camera.orbit(100, yaw, true, body);//地面近いカメラの高さ
        
            //カメラのY軸回転設定　
            //操作オブジェクトのデフォルトの↑ボタン進行方向を上または北側として、
            //camera.orbit(90, 0, body);//右(または東側)から操作オブジェクトへの視点
            //camera.orbit(90, 90, body);//上(または北側)から操作オブジェクトへの視点
            //camera.orbit(90, 180, body);//左(または西側)から操作オブジェクトへの視点
            //camera.orbit(90, 270, body);//下(または南側)から操作オブジェクトへの視点(360度、一回転してデフォルト位置へもどる設定)
        }    
            
        
        //キーボードを押したときの処理
        //←↑→↓ボタン押下時処理(操作オブジェクト移動のための設定)
        //A、D、W、Sボタン押下時処理(カメラ視点変更処理)
        //F、Rボタン処理　F：カメラ距離変更　R：カメラ設定デフォルト
        //Bボタン処理　Bダッシュを行う
        private function onKeyDown(event:KeyboardEvent):void{
            
            //タイトル画面選択肢操作を受け付ける
            if(keyInitSelection) {
                if (event.keyCode == 38) {//↑ボタン
                    initSelection = initSelection - 1;
                    setInitSelection();
                } else if (event.keyCode == 40) {//↓ボタン
                    initSelection = initSelection + 1;
                    setInitSelection();
                } else if (event.keyCode == 90) {//Zボタン
                    execInitSelection();
                }
                return; 
            }
            //クリア後はクリア後選択肢操作のみ受け付ける
            if(keyLastSelection) {
                if (event.keyCode == 38) {//↑ボタン
                    lastSelection = lastSelection - 1;
                    setClearSelection();
                } else if (event.keyCode == 40) {//↓ボタン
                    lastSelection = lastSelection + 1;
                    setClearSelection();
                } else if (event.keyCode == 90) {//Zボタン
                    execClearSelection();
                }
                return; 
            }
            
            //←ボタンDOWN 左回転の設定    
            if (event.keyCode == 37) {
                rotat = true;
                rotatNum = -5;
                //操作ボタン押下時の値：1を設定
                if(walkDispInterval < 1) {
                    walkDispInterval = 1;
                }
                checkTargetGain();
                
            //→ボタンDOWN 右回転の設定
            } else if (event.keyCode == 39) {
                rotat = true;
                rotatNum = 5;
                if(walkDispInterval < 1) {
                    walkDispInterval = 1;
                }
                checkTargetGain();
                
            //↑ボタンDOWN 前進の設定
            } else if (event.keyCode == 38) {
                wardMove = true;
                wardMoveNum = 10;
                if(walkDispInterval < 1) {
                    walkDispInterval = 1;
                }
                checkTargetGain();
                
            //↓ボタンDOWN 後退の設定
            } else if (event.keyCode == 40) {
                wardMove = true;
                wardMoveNum = -5;
                if(walkDispInterval < 1) {
                    walkDispInterval = 1;
                }
                checkTargetGain();
                
            //Bボタン　Bボタン押下中は前進・後退中の移動速度3倍
            } else if (event.keyCode == 66) {
                bDash= true;
                
            //Aボタン　操作オブジェクトを中心にカメラを左回り回転(Y軸回転)
            //90度づつ左回り回転　南→西→北→東→南 の順番でカメラ位置変更   
            } else if (event.keyCode == 65) {
                cameraYRotStat--;
                if(cameraYRotStat < 0) {cameraYRotStat = 3;}
                
            //Dボタン　操作オブジェクトを中心にカメラを右回り回転(Y軸回転)    
            //90度づつ右回り回転　南→東→北→西→南 の順番でカメラ位置変更   
            } else if (event.keyCode == 68) {
                cameraYRotStat++;
                if(cameraYRotStat > 3) {cameraYRotStat = 0;}
                
            //Wボタン　操作オブジェクトを中心にカメラを上下移動(X軸回転)
            } else if (event.keyCode == 87) {
                cameraXRotStat++;
                if(cameraXRotStat > 3) {cameraXRotStat = 0;}
                
            //Sボタン　操作オブジェクトを中心にカメラを上下移動(X軸回転)
            } else if (event.keyCode == 83) {
                cameraXRotStat--;
                if(cameraXRotStat < 0) {cameraXRotStat = 3;}
                
            //Fボタン　カメラと操作オブジェクトの距離を変更
            } else if (event.keyCode == 70) {
                distStat -= 1;
                if(distStat < 0) {distStat = 2;}
                
            //Rボタン　カメラの設定をデフォルトにもどす
            } else if (event.keyCode == 82) {
                distStat = 1;
                cameraXRotStat = 0;
                cameraYRotStat = 0;

            }
        }
        
        //キーボードを離したときの処理
        //←↑→↓ボタンリリース時処理(操作オブジェクト移動のための設定解除)
        private function onKeyUp(event:KeyboardEvent):void{
            if(keyLastSelection || keyInitSelection) {
                return;
            }
            //←ボタンUP 左回転の設定設定解除     
            if (event.keyCode == 37) {
                rotat = false;
                //操作ボタンリリース時の値：0を設定　他の操作ボタン押下中には設定しない
                if(!rotat && !wardMove) {
                    walkDispInterval = 0;
                }
            //→ボタンUP 右回転の設定設定解除
            } else if (event.keyCode == 39) {
                rotat = false; 
                if(!rotat && !wardMove) {
                    walkDispInterval = 0;
                }               
            //↑ボタンUP 前進の設定設定解除
            } else if (event.keyCode == 38) {
                wardMove = false;
                if(!rotat && !wardMove) {
                    walkDispInterval = 0;
                }
            //↓ボタンUP 後退の設定設定解除
            } else if (event.keyCode == 40) {
                wardMove = false;
                if(!rotat && !wardMove) {
                    walkDispInterval = 0;
                }
            //BボタンUP　Bダッシュ解除
            } else if (event.keyCode == 66) {
                bDash = false;
            }
        }
        
        //捜査対象オブジェクトの手足表示を制御
        private function ctrlWaklDisp():void{
            //status：操作オブジェクトの表示制御用ステータス　
            //0:直立　
            //1:左手、右足前方＆右手、左足後方
            //2:左手、右足後方＆右手、左足前方
            //前進・後退時は1と2の状態を交互に繰り返す
            //直立状態(0)からは(1)の状態へ遷移
            if (status == 0) {status = 1;}
            //(1)の状態をセット後、ステータスを(2)に変更
            if (status == 1) {
                //左手、右足前方
                leftHand.z = 70;
                leftHand.rotationX = -40;
                rightFoot.z = 50;
                rightFoot.rotationX = -30;
                //右手、左足後方
                rightHand.z = -70;
                rightHand.rotationX = 40;
                leftFoot.z = -50;
                leftFoot.rotationX = 30;
                status = 2;
            //(2)の状態をセット後、ステータスを(1)に変更
            } else if (status == 2) {
                //左手、右足後方
                leftHand.z = -70;
                leftHand.rotationX = 40;
                rightFoot.z = -50;
                rightFoot.rotationX = 30;
                //右手、左足前方
                rightHand.z = 70;
                rightHand.rotationX = -40;
                leftFoot.z = 50;
                leftFoot.rotationX = -30;
                status = 1;
            }
        }
        
        //取得目標(青いCube)を取得したか(=胴体部分がクリスタルもどきを通過したか)判定
        private function checkTargetGain():void{
            //右手手前配置の取得目標を通過したか判定
            //クリスタルもどき表示中かつ触れた場合に、クリスタルもどきを消す(表示を停止)
            if(target01.visible && body.hitTestObject(target01)) {
                target01.visible = false;
            }
            //左手奥配置の取得目標を通過したか判定
            //クリスタルもどき表示中かつ触れた場合に、クリスタルもどきを消す(表示を停止)
            if(target02.visible && body.hitTestObject(target02)) {
                target02.visible = false;
            }   
            //取得目標が2つとも消された場合の処理
            if(!target01.visible && !target02.visible) {
                //タイマーを止める
                timer.stop();
                
                //hiscore更新時にhiscore表示を変更
                if (leastTime > timerCnt-1) {
                    //最短クリア時間(hiscore)入れ替え
                    leastTime = timerCnt-1;
                    //hiscore表示を変更
                    textarea.text = new String(leastTime) + "秒経過"
                                  + "\nhiscore：" + leastTime;
                }
                //クリア情報を表示
                setTestareaForClearInfo();                
                clearInfo.text = "YOU CLEARED IN " + (timerCnt-1) + " SECONDS!!!";
                
                //クリア時の選択肢を表示                 
                setTextareaForClearSelection();
                
                //キー操作をクリア後の選択肢セレクトに変更
                keyLastSelection = true;
                wardMove = false; //前後移動停止
                rotat = false; //回転運動停止
                walkDispInterval = 0; //移動インターバルを初期化
            }
        }         
        
        //経過時間表示のためのテキストエリアを設定
        private function setTestareaForTimerCount():void
        {
            var txtFmt:TextFormat = new TextFormat();
            txtFmt.font  = 'Courier New'; // 等幅フォント
            txtFmt.color = '0xFFFFFF';
            txtFmt.size  = 30;
            textarea = new TextField();
            textarea.defaultTextFormat = txtFmt;
            textarea.height = 100;
            textarea.width = 200;
            textarea.antiAliasType = AntiAliasType.ADVANCED;
            addChild(textarea);
        }
        
        private function timerHandler(event:TimerEvent):void
        {
            textarea.text = new String(timerCnt) + "秒経過"
                          + "\nhiscore：" + leastTime;
            timerCnt++
        }

        private function initTitleGraphic():Shape
        {
            var rect = new Shape();
            rect.graphics.beginFill(0x0000FF, 1.0);  // 単一色のスタイル設定
            rect.graphics.drawRect(0, 0, 500, 500);  // 矩形を描画
            return rect;
        }
        
        private function initTitleTextField():TextField
        {          
            var txtFmt:TextFormat = new TextFormat();
            txtFmt.font  = 'Courier New'; // 等幅フォント
            txtFmt.color = '0x00FFFF';
            txtFmt.size  = 50;
            var txtFld = new TextField();
            txtFld.defaultTextFormat = txtFmt;
            txtFld.x = 20;
            txtFld.y = 60;
            txtFld.height = 90;
            txtFld.width = 490;
            txtFld.text = "げ～むたいとる画面！";
            initSelecTxt.antiAliasType = AntiAliasType.ADVANCED;
            return txtFld;
        }
                
        //ゲームタイトル選択肢を表示
        private function setTextareaForTitleSelection():void
        {
            var txtFmt:TextFormat = new TextFormat();
            txtFmt.font  = 'Courier New'; // 等幅フォント
            txtFmt.color = '0xFFFFFF';
            txtFmt.size  = 25;
            initSelecTxt = new TextField();
            initSelecTxt.defaultTextFormat = txtFmt;
            initSelecTxt.x = 60;
            initSelecTxt.y = 250;
            initSelecTxt.height = 90;
            initSelecTxt.width = 380;
            initSelecTxt.multiline = true;
            initSelecTxt.background = true;
            initSelecTxt.backgroundColor = 0x000000;
            initSelecTxt.border= true;
            initSelecTxt.borderColor = 0xFFFFFF;
            initSelecTxt.antiAliasType = AntiAliasType.ADVANCED;
            rect = initTitleGraphic(); // タイトル背景生成
            addChild(rect); //　タイトル背景表示
            titleText = initTitleTextField(); // タイトル文字生成
            addChild(titleText); //　タイトル文字表示
            addChild(initSelecTxt);
            loadSaveData();
            initSelecTxt.text = "　最初から　:ハイスコア999秒から　 \n"//管理しやすいように1行15文字に設定
                              + " つづきから:ハイスコア" + leastTime + "秒から  \n"
                              + " セーブデータ削除　　　　　　　　　  \n";
            initSelection = 0; //0～2
            setInitSelection();
        }
        
        //ゲームタイトル画面選択肢選択機能
        private function setInitSelection():void
        {
            var txtFmt:TextFormat = new TextFormat();

            txtFmt.color = '0xFFFFFF';
            initSelecTxt.setTextFormat(txtFmt);
            
            txtFmt.color = '0x00FF00';
            if (initSelection < 0) {initSelection = 2}
            if (initSelection > 2) {initSelection = 0;}
            
            var beginIndex : int = 20 * initSelection;
            var endIndex : int = beginIndex + 20;
            initSelecTxt.setTextFormat(txtFmt, beginIndex, endIndex);
        }
        
        //ゲームタイトル画面選択肢実行
        private function execInitSelection():void
        {
            if (initSelection == 0) { //ゲームを最初からはじめる
                startGame();
            } else if (initSelection == 1) { //ゲームを記録されたハイスコアでスタート
                loadGame();
            } else if (initSelection == 2) { //記録されたハイスコアを削除
                deleteSaveData();
                loadSaveData();
                rewriteTitleSelection();
                setInitSelection();
            } 
        }
        
        //タイトル画面選択肢から、ゲームを新規にはじめる
        private function startGame():void
        {
            removeChild(rect);
            removeChild(titleText);            
            removeChild(initSelecTxt);
            keyInitSelection = false;
            leastTime = 999;
            //タイマーイベントを設定
            timer = new Timer(1000);
            timer.addEventListener(TimerEvent.TIMER, timerHandler);
            timer.start();
        }
            
        //タイトル画面選択肢から、記録されたハイスコアを引き継いでゲームスタート
        private function loadGame():void
        {
            loadSaveData();
            removeChild(rect);
            removeChild(titleText); 
            removeChild(initSelecTxt);
            keyInitSelection = false;
            //タイマーイベントを設定
            //timer = new Timer(1000);
            //timer.addEventListener(TimerEvent.TIMER, timerHandler);
            timer.start();
        }  

        //共有オブジェクトからセーブされたハイスコアデータを取得する
        private function loadSaveData():void
        {
            var so : SharedObject = SharedObject.getLocal("my_data");
            if(so){
	        var obj : Object = so.data;
                if (obj.num == undefined) {leastTime = 999;}
                else {leastTime = obj.num;}	        
            } else {leastTime = 999;}
        }
        
        //共有オブジェクトからセーブされたハイスコアデータを削除する
        private function deleteSaveData():void
        {
            var so : SharedObject = SharedObject.getLocal("my_data");
            if(so){
	        so.clear();	        
            }
        } 

        //共有オブジェクトからセーブされたハイスコアデータを削除する
        private function rewriteTitleSelection():void
        {
            initSelecTxt.text = "　最初から　:ハイスコア999秒から　 \n"//管理しやすいように1行15文字に設定
                              + " つづきから:ハイスコア" + leastTime + "秒から  \n"
                              + " セーブデータ削除　　　　　　　　　  \n";
        }
                       
        //ゲームクリア情報表示のためのテキストエリアを設定
        private function setTestareaForClearInfo():void
        {
            var txtFmt:TextFormat = new TextFormat();
            txtFmt.font  = 'Courier New'; // 等幅フォント
            txtFmt.color = '0xFFFFFF';
            txtFmt.size  = 25;
            clearInfo = new TextField();
            clearInfo.defaultTextFormat = txtFmt;
            clearInfo.x = 20;
            clearInfo.y = 200;
            clearInfo.height = 100;
            clearInfo.width = 450;
            clearInfo.antiAliasType = AntiAliasType.ADVANCED;
            addChild(clearInfo);
        }

        //ゲームクリア後選択肢を表示
        private function setTextareaForClearSelection():void
        {
            var txtFmt:TextFormat = new TextFormat();
            txtFmt.font  = 'Courier New'; // 等幅フォント
            txtFmt.color = '0xFFFFFF';
            txtFmt.size  = 25;
            clearSelection = new TextField();
            clearSelection.defaultTextFormat = txtFmt;
            clearSelection.x = 100;
            clearSelection.y = 250;
            clearSelection.height = 90;
            clearSelection.width = 300;
            clearSelection.multiline = true;
            clearSelection.background = true;
            clearSelection.backgroundColor = 0x000000;
            clearSelection.border= true;
            clearSelection.borderColor = 0xFFFFFF;
            clearSelection.antiAliasType = AntiAliasType.ADVANCED;
            addChild(clearSelection);
            clearSelection.text = "　もう一度プレイ　　　　　　\n"//管理しやすいように1行15文字に設定
                                + " ハイスコアを記録　　　　　　\n"
                                + " タイトルへ戻る　　　　　\n";
            lastSelection = 0; //0～2
            setClearSelection();
        }

        //ゲームクリア後選択肢選択機能
        private function setClearSelection():void
        {
            var txtFmt:TextFormat = new TextFormat();

            txtFmt.color = '0xFFFFFF';
            clearSelection.setTextFormat(txtFmt);
            
            txtFmt.color = '0x00FF00';
            if (lastSelection < 0) {lastSelection = selectionNum -1;}
            if (lastSelection > selectionNum - 1) {lastSelection = 0;}
            //if (lastSelection < 0) {lastSelection = 2;}
            //if (lastSelection > 2) {lastSelection = 0;}
            
            var beginIndex : int = 15 * lastSelection;
            var endIndex : int = beginIndex + 15;
            clearSelection.setTextFormat(txtFmt, beginIndex, endIndex);
        }       
        
        //ゲームクリア後選択肢実行
        private function execClearSelection():void
        {
            if (lastSelection == 0) { //ゲームを再スタート
                restartGame();
            } else if (lastSelection == 1) { //ゲームをセーブ
                saveGame();
            } else if (lastSelection == 2) { //ゲームを終了、タイトル画面へ戻る
                backToTitle();
            }
        } 
        
        //ゲームクリア後の選択で再スタートの処理
        private function restartGame():void
        {
            keyLastSelection = false; //通常キー入力に戻す
            removeChild(clearInfo); //クリア情報を非表示
            removeChild(clearSelection); //クリア後選択肢を非表示
            target01.visible = true; //取得対象１を再表示
            target02.visible = true; //取得対象１を再表示
            body.x = 0; //操作オブジェクトをスタート座標に戻す(ｘ座標)
            body.z = 0; //操作オブジェクトをスタート座標に戻す(ｚ座標)
            body.rotationY = 0; //操作オブジェクト方向を初期化
            timerCnt = 0; //タイムカウンターを0に初期化
            timer.start(); //タイムカウンターを再スタート
            //プレイ中変更カメラ位置はそのまま保持
        }
 
        //ゲームクリア後の選択でセーブの処理
        private function saveGame():void
        {
            var so : SharedObject = SharedObject.getLocal("my_data");
            if(so){
	        var obj : Object = so.data;
	        obj.num = leastTime;
                obj.str = "書き込みテスト";
                try {
                    var str:String = so.flush(300);
                    switch (str) {
                    case SharedObjectFlushStatus.FLUSHED :
                        clearInfo.text = "正常にハードディスクに書き込めました";
                        trace ("正常にハードディスクに書き込めました");
                        break;
                    case SharedObjectFlushStatus.PENDING :
                        clearInfo.text = "ユーザーにハードディスク書き込み要求を出します";
                        trace ("ユーザーにハードディスク書き込み要求を出します");
                        break;
                    }
                } catch (e:Error) {
                    clearInfo.text = "書き込みに失敗しました";
                    trace ("書き込みに失敗しました");
                }
            }
        }
        
        //タイトル画面にもどる
        private function backToTitle():void
        {

            removeChild(clearInfo); //クリア情報を非表示
            removeChild(clearSelection); //クリア後選択肢を非表示
            target01.visible = true; //取得対象１を再表示
            target02.visible = true; //取得対象１を再表示
            body.x = 0; //操作オブジェクトをスタート座標に戻す(ｘ座標)
            body.z = 0; //操作オブジェクトをスタート座標に戻す(ｚ座標)
            body.rotationY = 0; //操作オブジェクト方向を初期化
            timerCnt = 0; //タイムカウンターを0に初期化
            timer.stop(); //タイムカウンターを再スタート
            
            keyLastSelection = false;
            keyInitSelection = true;
            
            //setTextareaForTitleSelection();
            
            loadSaveData();
            rewriteTitleSelection();
            
            addChild(rect);
            addChild(titleText); 
            addChild(initSelecTxt);
            initSelection = 0; //0～2
            setInitSelection();
            //プレイ中変更カメラ位置はそのまま保持
        }
                                                                    
    }  //クラス終わり
}  //パッケージ終わり


