/**
 * Copyright Aquioux ( http://wonderfl.net/user/Aquioux )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/honF
 */

// forked from Aquioux's Glynn Fractal
package {
    //import aquioux.display.colorUtil.CycleRGB;
    import com.bit101.components.HSlider;
    import com.bit101.components.PushButton;
    import com.bit101.components.VSlider;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Rectangle;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    [SWF(width = "465", height = "465", frameRate = "60", backgroundColor = "#000000")]
    
    /**
     * Glynn Fractal の描画
     * @see    http://aquioux.net/blog/?p=2152
     * @author Aquioux(Yoshida, Akio)
     */
    public class Main extends Sprite {
        // ステージサイズ
        private const WIDTH:int  = 450;
        private const HEIGHT:int = 450;
        // スライダー関連
        private const SLIDER_LONG:int  = WIDTH;
        private const SLIDER_SHORT:int = stage.stageWidth - WIDTH;
        private var sliderValueMin:Number;
        private var sliderValueMax:Number;
        
        // 初期値
        private const REAL_NUMBER:Number      = -0.2;    // c の実数部
        private const IMAGINARY_NUMBER:Number =  0;      // c の虚数部

        // ジュリア集合でない部分の色
        private var colors_:Vector.<uint>;
        
        // 計算クラス
        private var julia_:Julia;
        // 走査クラス
        private var scan_:Scan;
        // 表示用 BitmapData
        private var bmd_:BitmapData;
        private var rect_:Rectangle;    // bmd_ 用 Rectangle
        
        // スライダー
        private var hslider_:HSlider;
        private var vslider_:VSlider;

        // 現在の c の値を表示するテキストフィールド
        private var textField1_:TextField;
        private var textField2_:TextField;
        
        private var isDown_:Boolean = true;
        
        // 前回押したボタン
        private var prevButton_:PushButton;


        public function Main():void {
            // カラーセット
            colors_ = new Vector.<uint>();
            var degree:int = 120;
            var step:Number = 360 / degree;
            for (var i:int = 0; i < degree; i++) colors_[i] = CycleRGB.getColor(i * step + 180);
            colors_.reverse();
            colors_.fixed = true;
            
            // Julia クラスのセットアップ
            julia_ = new Julia();
            julia_.colors = colors_;

            // Scan クラスのセットアップ
            scan_ = new Scan(WIDTH, HEIGHT, julia_);
            
            // Viewer の作成
            bmd_ = new BitmapData(WIDTH, HEIGHT, false, 0x0);
            addChild(new Bitmap(bmd_));
            rect_ = new Rectangle(0, 0, WIDTH, HEIGHT);
            
            // スライダーの作成
            sliderValueMin = -0.225;// julia_.rect.x;
            sliderValueMax =  0.225;// julia_.rect.width + julia_.rect.x;
            // 横スライダー（複素数 c の実数部）
            hslider_ = new HSlider(this, 0, HEIGHT);
            hslider_.width  = SLIDER_LONG;
            hslider_.height = SLIDER_SHORT;
            hslider_.setSliderParams(sliderValueMin, sliderValueMax, REAL_NUMBER);
            hslider_.tick = 0.001;
            // 縦スライダー（複素数 c の虚数部）
            vslider_ = new VSlider(this, WIDTH, 0);
            vslider_.width  = SLIDER_SHORT;
            vslider_.height = SLIDER_LONG;
            vslider_.setSliderParams(sliderValueMin, sliderValueMax, IMAGINARY_NUMBER);
            vslider_.tick = 0.001;
            
            // テキストフィールドの作成
            textField1_ = new TextField();
            textField2_ = new TextField();
            textField1_.autoSize = TextFieldAutoSize.LEFT;
            textField2_.autoSize = TextFieldAutoSize.LEFT;
            var fontSize:int = 12;
            var textFormat:TextFormat = new TextFormat("_typewriter", fontSize, 0x000000);
            textField1_.defaultTextFormat = textFormat;
            textField2_.defaultTextFormat = textFormat;
            textField1_.y = 0;
            textField2_.y = fontSize * 1.25 >> 0;
            addChild(textField1_);
            addChild(textField2_);
            
            // マウスハンドラの設定
            // スライダーに直接ハンドラを設定すると ENTER_FRAME のタイミングで更新がかかり、
            // 処理負荷が大きくなるため、マウスアップ時にスライダハンドラを実行させる
            stage.addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);
            stage.addEventListener(MouseEvent.MOUSE_UP, mouseUpHandler);
            stage.addEventListener(Event.MOUSE_LEAVE,   mouseLeaveHandler);
            
            // 初回状態の表示
            mouseUpHandler(null);
        }
        
        
        // 描画
        private function draw():void {
            scan_.update(bmd_, this);
        }
        

        // マウスハンドラ
        private function mouseDownHandler(e:MouseEvent):void {
            isDown_ = true;
        }
        private function mouseUpHandler(e:MouseEvent):void {
            if (isDown_) {
                hsliderHandler();
                vsliderHandler();
                isDown_ = false;
            }
        }
        private function mouseLeaveHandler(e:Event):void {
            mouseUpHandler(null);
        }
        

        // スライダーハンドラ
        private function hsliderHandler():void {
            var value:Number = hslider_.value;
            textField1_.text = "real : " + String(value);
            julia_.c.real = value;
            draw();
        }
        private function vsliderHandler():void {
            var value:Number = vslider_.value;
            textField2_.text = "imag : " + String(value);
            julia_.c.imag = value;
            draw();
        }
    }
}


//package {
    //import aquioux.math.Complex;
    import flash.geom.Rectangle;
    /**
     * ジュリア集合描画クラス
     * _scale = 1.0 のとき (-2, -2) ～ (2, 2) の領域を対象に計算する
     * @author Aquioux(Yoshida, Akio)
     */
    /*public*/ class Julia implements ICalculator {
        /**
         * 描画範囲
         */
        public function get rect():Rectangle { return RECTANGLE; }
        private const RECTANGLE:Rectangle = new Rectangle(MIN_X, MIN_Y, (MAX_X - MIN_X), (MAX_Y - MIN_Y));
        // 個別の開始座標、終了座標
        private const MIN_X:Number = -2.0;        // X軸最小値
        private const MIN_Y:Number = -2.0;        // Y軸最小値
        private const MAX_X:Number =  2.0;        // X軸最大値
        private const MAX_Y:Number =  2.0;        // Y軸最大値

        /**
         * 集合に該当する部分の色（一般的には色なし＝黒）
         */
        private var _color:uint = 0x000000;
        public function set color(value:uint):void { _color = value; }
        /**
         * 発散部分の色階調
         */
        private var _colors:Vector.<uint>;
        public function set colors(value:Vector.<uint>):void {
            _colors = value;
            degree_ = value.length;
        }
        
        /**
         * 漸化式の c
         */
        public function get c():Complex { return _c; }
        private var _c:Complex = new Complex( -0.2, 0);
        
        
        // 発散チェックループ回数（_colors.length の値）
        private var degree_:int;
        
        
        /**
         * Scan クラスからの走査データを受け、計算をおこなう
         * @param    x    X座標値
         * @param    y    Y座標値
         * @return    計算結果
         */
        public function calculate(x:Number, y:Number):uint {
            var r:int = formula(x, y, _c.real, _c.imag);
            return (r >= 0) ? _colors[r] : _color;
        }
        /**
         * 漸化式　z ← z^1.5 + c
         * @param    zRl    複素数 z の実数部
         * @param    zIm    複素数 z の虚数部
         * @param    cRl    複素数 c の実数部
         * @param    cIm    複素数 c の虚数部
         * @return    発散評価値
         * @private
         */
        private function formula(zRl:Number, zIm:Number, cRl:Number, cIm:Number):int {
            // 漸化式の計算要素の複素数
            var zRlSqr:Number;        // 実数部の2乗
            var zImSqr:Number;        // 虚数部の2乗
            var zSqr:Number;        // zRlSqr + zImSqr
            // ド・モアブルの定理
            var r1:Number;    // 局座標形式複素数の距離（計算前）
            var t1:Number;    // 局座標形式複素数の偏角（計算前）
            var r2:Number;    // 局座標形式複素数の距離（計算後）
            var t2:Number;    // 局座標形式複素数の偏角（計算後）
            
            var i:int = degree_;
            while (i--) {
                // 発散の評価
                zRlSqr = zRl * zRl;
                zImSqr = zIm * zIm;
                zSqr   = zRlSqr + zImSqr;
                if (zSqr > 4) break;
                
                // 発散していなかった場合、再評価へ向けて z_n の値を更新する
                // 複素数を局座標化
                r1 = Math.sqrt(zRlSqr + zImSqr);
                t1 = Math.atan2(zIm, zRl);
                // 冪乗計算
                r2 = Math.sqrt(r1 * r1 * r1);    // 距離
                t2 = t1 * 1.5;                    // 偏角
                zRl = Math.cos(t2) * r2 + cRl;
                zIm = Math.sin(t2) * r2 + cIm;
            }
            return i;
            // break で脱しなかった（発散しなかった）場合、while を回りきるので -1 になる
        }
    }
//}


//package {
    import flash.geom.Rectangle;
    /**
     * 計算クラスの interface
     * @author YOSHIDA, Akio (Aquioux)
     */
    /*public*/ interface ICalculator {
        function get rect():Rectangle;
        function calculate(x:Number, y:Number):uint;
    }
//}


//package {
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.ColorTransform;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    /**
     * 二次元走査クラス
     * @author Aquioux(Yoshida, Akio)
     */
    /*public*/ class Scan {
        /**
         * 描画領域
         */
        private var _rect:Rectangle;
        public function set rect(value:Rectangle):void {
            _rect = value;
            
            // 複素平面の中心座標を計算
            centerX_ = _rect.x + _rect.width  * 0.5;
            centerY_ = _rect.y + _rect.height * 0.5;
            
            calcStart();    // 走査開始座標
            calcStep();        // 走査加算値
        }
        
        /**
         * スケール値
         */
        private var _scale:Number = 1.0;
        public function set scale(value:Number):void {
            var prevScale:Number = _scale;    // 現在の _scale を退避
            _scale = value;                    // 新たな _scale を代入

            // _scale 変更に伴う _rect の更新
            var rate:Number = prevScale / _scale;
            _rect.width  *= rate;
            _rect.height *= rate;
            _rect.x = centerX_ - _rect.width  * 0.5;
            _rect.y = centerY_ - _rect.height * 0.5;

            calcStart();    // 走査開始座標
            calcStep();        // 走査加算値
        }
        
        
        // 計算クラス
        private var _calculator:ICalculator;
        
        // 表示領域サイズ
        private var displayWidth_:int;        // 幅
        private var displayHeight_:int;        // 高
        

        // 複素平面の中心座標
        private var centerX_:Number;        // 実数座標
        private var centerY_:Number;        // 虚数座標
        // 平面走査の計算加算値
        private var stepX_:Number;            // 実数軸
        private var stepY_:Number;            // 虚数軸
        // 走査開始座標
        private var startX_:Number;            // 実数座標
        private var startY_:Number;            // 虚数座標
        
        // Viewer
        private var canvas_:BitmapData;        // 表示 BitmapData
        private var rect_:Rectangle;        // canvas_ 用 Rectangle
        private var FADE:ColorTransform = new ColorTransform(0.95, 0.95, 0.95);

        // 現在描画中の行
        private var currentY_:int;

        // Viewer へ渡すデータ
        private var data_:Vector.<uint>;
        private var idx_:int;                // data_ のインデックス
        
        
        /**
         * コンストラクタ
         * @param    width    表示幅
         * @param    height    表示高
         * @param    calculator    計算クラス
         */
        public function Scan(width:int, height:int, calculator:ICalculator) {
            // 表示領域
            displayWidth_  = width;
            displayHeight_ = height;
            
            // 計算クラス
            _calculator = calculator;
            reset();
        
            // data_ の生成
            data_ = new Vector.<uint>(width, true);
            // rect_ の生成
            rect_ = new Rectangle(0, 0, width, 1);
        }

        /**
         * 複素数平面を走査し、その値を計算クラスに渡す
         * @return    計算クラスから返ってきた値を格納した Vector
         */
        public function update(canvas:BitmapData, parent:Sprite):void {
            canvas_ = canvas;
            canvas_.colorTransform(canvas_.rect, FADE);
            currentY_ = 0;
            parent.addEventListener(Event.ENTER_FRAME, draw);
        }
        private function draw(e:Event):void {
            var posY:Number = startY_ + currentY_ * stepY_;
            idx_ = 0;
            for (var x:int = 0; x < displayWidth_; x++) {
                data_[idx_++] = _calculator.calculate(startX_ + x * stepX_, posY);
            }
            rect_.y = currentY_;
            canvas_.lock();
            canvas_.setVector(rect_, data_);
            currentY_++;
            canvas_.unlock();
            if (currentY_ >= displayHeight_) e.target.removeEventListener(Event.ENTER_FRAME, arguments.callee);
        }
        
        /**
         * 描画領域のリセット
         */
        public function reset():void {
            rect = _calculator.rect;
            scale = 1;
        }


        // 複素平面の走査開始座標を計算する
        private function calcStart():void {
            startX_ = _rect.x;
            startY_ = _rect.y;
        }
        // 複素平面の走査加算値を計算する
        private function calcStep():void {
            stepX_ = _rect.width  / (displayWidth_  - 1);
            stepY_ = _rect.height / (displayHeight_ - 1);
        }
    }
//}


//package aquioux.math {
    /**
     * 複素数
     * @author Aquioux(Yoshida, Akio)
     */
    /*public*/ final class Complex {
        // 実数部
        public function get real():Number { return _rl; }
        public function set real(value:Number):void { _rl = value; }
        private var _rl:Number;
        // 虚数部
        public function get imag():Number { return _im; }
        public function set imag(value:Number):void { _im = value; }
        private var _im:Number;
        

        // コンストラクタ
        public function Complex(rl:Number = 0, im:Number = 0) {
            _rl = rl;
            _im = im;
        }
        
        // 複製
        public function clone():Complex {
            return new Complex(_rl, _im);
        }
        
        public function toString():String {
            return _rl + " + " + _im + "i";
        }
    }
//}


//package aquioux.display.colorUtil {
    /**
     * コサインカーブで色相環的な RGB を計算
     * @author Aquioux(YOSHIDA, Akio)
     */
    /*public*/ class CycleRGB {
        /**
         * 32bit カラーのためのアルファ値（0～255）
         */
        static public function get alpha():uint { return _alpha; }
        static public function set alpha(value:uint):void {
            _alpha = (value > 0xFF) ? 0xFF : value;
        }
        private static var _alpha:uint = 0xFF;
    
        private static const PI:Number = Math.PI;        // 円周率
        private static const DEGREE120:Number  = PI * 2 / 3;    // 120度（弧度法形式）
        
        /**
         * 角度に応じた RGB を得る
         * @param    angle    HSV のように角度（度数法）を指定
         * @return    色（0xNNNNNN）
         */
        public static function getColor(angle:Number):uint {
            var radian:Number = angle * PI / 180;
            var r:uint = (Math.cos(radian)             + 1) * 0xFF >> 1;
            var g:uint = (Math.cos(radian + DEGREE120) + 1) * 0xFF >> 1;
            var b:uint = (Math.cos(radian - DEGREE120) + 1) * 0xFF >> 1;
            return r << 16 | g << 8 | b;
        }
        
        /**
         * 角度に応じた RGB を得る（32bit カラー）
         * @param    angle    HSV のように角度（度数法）を指定
         * @return    色（0xNNNNNNNN）
         */
        public static function getColor32(angle:Number):uint {
            return _alpha << 24 | getColor(angle);
        }
    }
//}
