/**
 * Copyright jerryrom ( http://wonderfl.net/user/jerryrom )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hnnZ
 */

// forked from jerryrom's Run away from Pacman 
package {
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Point;
	import flash.ui.Mouse;
	import net.hires.debug.Stats;
    import net.wonderfl.widget.Wanco;
         
	[SWF(width=465, height=465, backgroundColor=0x000000, frameRate=30)]
	public class Main extends Sprite {
		
		private const POINT_MAX:int = 60;
		private var p:Vector.<Point>;
		private var pacman:Pacman;
		private var wanco:Wanco;
		private var cur:int = 0;
		private var cur2:int = 0;
		private var px:int;
		private var py:int;
		private var prev:Point;
		private var move:Boolean;
		private var draw:Boolean = false;
		
		public function Main():void {
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void {
			removeEventListener(Event.ADDED_TO_STAGE, init);
			// entry point
			graphics.beginFill(0x000000);
			graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
			graphics.endFill();
			Wonderfl.capture_delay(3);
			
			//addChild(new Stats());
			
			p = new Vector.<Point>();
			for (var i:int; i < POINT_MAX; i++) {
				p.push(new Point(0, 0));
			}
			
			wanco = new Wanco();
			addChild(wanco);
						
			prev = new Point(0,0);
			
			addEventListener(Event.ENTER_FRAME, onEnter);
		}
		
		private function onEnter(e:Event):void {
			if (cur >= POINT_MAX/2) {
				move = true;
			}
			if (cur >= POINT_MAX) {
				cur = 0;
			}
			if (cur2 >= POINT_MAX) {
				cur2 = 0;
				move = false;
			}
			
			if (draw) {
				graphics.moveTo(mouseX, mouseY);
				graphics.lineStyle(3, 0x8A4B08);
				graphics.lineTo(px, py);
			}
			draw = !draw;
			
			// eat mouse cursor
			if ((p[cur2].x - 15 < mouseX && mouseX < p[cur2].x + 30) &&
				(p[cur2].y - 15 < mouseY && mouseY < p[cur2].y + 30)) {
				Mouse.hide();
			} else {
				Mouse.show();
			}

			if (move) {
				//var r:Number = Math.atan2(p[cur2].y - prev.y, p[cur2].x - prev.x) / Math.PI * 180;
				//wanco.rotation = r;
				wanco.x = p[cur2].x;
				wanco.y = p[cur2].y;
				graphics.moveTo(p[cur2].x, p[cur2].y);
				graphics.lineStyle(10, 0x000000);
				graphics.lineTo(prev.x, prev.y);
				prev = p[cur2];
				cur2++;
			}
			
			px = p[cur].x = mouseX;
			py = p[cur].y = mouseY;
			cur++;
		}
	}
}

import flash.display.Sprite;
import flash.geom.Point;
internal class Pacman extends Sprite {
	private var op:Sprite;
	private var cl:Sprite;
	private var o:Boolean;
	private var count:int = 0;
	private var r:Number;
	
	public function Pacman() {
		op = new Sprite();
		op.graphics.beginFill(0xffff00);
		op.graphics.drawCircle(0, 0, 30);
		op.graphics.beginFill(0x000000);
		op.graphics.drawTriangles(Vector.<Number>([-15,0,30,20,30,-20]));
		op.graphics.endFill();
		op.visible = true;
		addChild(op);
		
		cl = new Sprite();
		cl.graphics.beginFill(0xffff00);
		cl.graphics.drawCircle(0, 0, 30);
		cl.graphics.endFill();
		cl.visible = false;
		addChild(cl);
	}
	
	public function move(p:Point, p2:Point):void {
		if (count >= 5) {
			r = Math.atan2(p.y - p2.y, p.x - p2.x) / Math.PI * 180;
			//r = Math.round(r/10)*10;
			if (r != 0 && r != 180) {
				rotation = r;
			}
			if (o) {
				open();
			} else {
				close();
			}
			o = !o;
			count = 0;
		}
		x = p.x;
		y = p.y;
		count++;
	}
	
	public function open():void {
		op.visible = true;
		cl.visible = false;
	}
	
	public function close():void {
		op.visible = false;
		cl.visible = true;
	}
}