/**
 * Copyright yoyo_hamdan ( http://wonderfl.net/user/yoyo_hamdan )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hnPh
 */

// forked from nemu90kWw's MASSMEDIAN合体ゲーム forked from: massmedian challenge
// forked from checkmate's massmedian challenge

/*
 * ゲーム作ってみた。
 * お題の趣旨とは大幅にズレてるけど・・・。
 * 
 * ◆ ゲームのルール
 * マウスで文字を拾って「MASSMEDIAN」にしてください。
 * 右２つは白くないとダメです。
 * 完成したらクリアタイムが表示されます。
 */

package
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.DisplayObject;
	import flash.display.Loader;
	import flash.display.LoaderInfo;
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.display.StageQuality;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.filters.ColorMatrixFilter;
	import flash.geom.ColorTransform;
	import flash.geom.Matrix;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	import flash.net.URLRequest;
	import flash.system.LoaderContext;
	import flash.text.TextField;
	import flash.text.TextFormat;
	import flash.text.TextFormatAlign;
	import flash.ui.Mouse;
	import flash.utils.getTimer;
	
	[SWF(width="465", height="465", frameRate="50")]
	public class Begineer extends Sprite
	{
		//-------------------------------//
		// Use properties as follows.
		//-------------------------------//
		private var _sliceList:Array;
		private var grp_char:Array = null;
		
		private var buffer:BitmapData;
		private var screen:Sprite;
		
		private var count:int;
		private var action:String;
		private var bgcolor:uint;
		private var bg:Shape;
		private var buffer2:BitmapData;
		
		private var textfield:TextField;
		private var textfield2:TextField;
		
		private var massmedian:Array;
		private var massmedian_width:int;
		
		private var player:Object;
		private var charpool:Array;
		private var particlepool:Array;
		
		private var time:Number;
		
		private var mouse_x:Number = 0;
		private var mouse_y:Number = 0;
		private var mouse_down_temp:Boolean = false;
		private var mouse_down:Boolean = false;
		private var mouse_press:Boolean = false;
		private var mouse_release:Boolean = false;
		
		private var Player:Function = function():void
		{
			var count:int = -1;
			
			this.x = 0;
			this.y = 0;
			this.action = "act_title";
			this.deleteflag = false;
			
			this.formation = new Array();
			
			var light:Shape = new Shape();
			var matrix:Matrix = new Matrix();
			matrix.createGradientBox(48, 48, 0, -24, -24);
			light.graphics.beginGradientFill
			(
				"radial",
				[0xFFFFFF, 0xFFFFFF],
				[0.5, 0],
				[0x40, 0xFF],
				matrix
			);
			light.graphics.drawRect(-24, -24, 48, 48);
			light.graphics.endFill();
			
			this.main = function():void
			{
				count++;
				for(var i:int = 0; i < this.formation.length; i++)
				{
					if(this.formation[i].action != "act_player"
						|| this.formation[i].deleteflag == true)
					{
						this.formation.splice(i, 1);
						i--;
					}
				}
				
				this[this.action]();
				return;
			};
			
			this.draw = function(buffer:BitmapData):void
			{
				matrix.identity();
				matrix.translate(mouse_x, mouse_y);
				buffer.draw(light, matrix);
				return;
			};
			
			this.getWidth = function():int
			{
				var result:int = 0;
				for(var i:int = 0; i < this.formation.length; i++)
				{
					result += this.formation[i].getWidth();
				}
				return result;
			};
			
			this.changeAction = function(name:String):void
			{
				this.action = name;
				
				count = -1;
				return;
			};
			
			var logo_size:Number;
			this.act_title = function():void
			{
				var i:int;
				
				if(count == 0)
				{
					this.x = 465/2;
					this.y = 210;
					
					logo_size = 450;
				}
				
				if(count >= 70 && count < 80)
				{
					this.y -= 4;
				}
				
				var temp_x:int = this.x - this.getWidth() / 2;
				for(i = 0; i < this.formation.length; i++)
				{
					if(i == 0)
					{
						temp_x += this.formation[i].getWidth()/2;
					}
					
					this.formation[i].x = (this.formation[i].x + (temp_x + Math.cos(count/10-i/2+7)*(logo_size+5))) / 2;
					this.formation[i].y = (this.formation[i].y + (this.y + Math.sin(count/10-i/2+7)*(logo_size+5))) / 2;
					
					logo_size /= 1.0075;
					
					if(i < this.formation.length - 1)
					{
						temp_x += this.formation[i].getWidth()/2 + this.formation[i+1].getWidth()/2;
					}
				}
				return;
			};
			
			this.act_main = function():void
			{
				this.x = mouse_x;
				this.y = mouse_y;
				
				var temp:int = this.x - this.getWidth() / 2;
				for(var i:int = 0; i < this.formation.length; i++)
				{
					if(i == 0)
					{
						temp += this.formation[i].getWidth()/2;
					}
					
					this.formation[i].x = (this.formation[i].x + temp) / 2;
					this.formation[i].y = (this.formation[i].y + this.y) / 2;
					
					if(i < this.formation.length - 1)
					{
						temp += this.formation[i].getWidth()/2 + this.formation[i+1].getWidth()/2;
					}
				}
				return;
			};
			
			this.act_complete = function():void
			{
				this.x = 465/2;
				this.y = 200;
				
				var temp:int = this.x - this.getWidth() / 2;
				for(var i:int = 0; i < this.formation.length; i++)
				{
					if(i == 0)
					{
						temp += this.formation[i].getWidth()/2;
					}
					
					this.formation[i].x = (this.formation[i].x + temp) / 2;
					this.formation[i].y = (this.formation[i].y + this.y) / 2;
					
					if(i < this.formation.length - 1)
					{
						temp += this.formation[i].getWidth()/2 + this.formation[i+1].getWidth()/2;
					}
				}
				return;
			};
		};
		
		public var Character:Function = function(x:Number = 0, y:Number = 0, type:int = 0, action:String = "act_player"):void
		{
			var count:int = -1;
			this.deleteflag = false;
			
			this.x = x;
			this.y = y;
			this.type = type;
			this.action = action;
			this.visible = true;
			
			var vx:Number = 0;
			var vy:Number = 0;
			var div:Number = 0;
			
			this.main = function():void
			{
				count++;
				
				this[this.action]();
				return;
			};
			
			this.changeAction = function(name:String):void
			{
				this.action = name;
				
				count = -1;
				return;
			};
			
			this.draw = function(buffer:BitmapData):void
			{
				buffer.copyPixels
				(
					grp_char[this.type],
					grp_char[this.type].rect,
					new Point(this.x-grp_char[this.type].width/2, this.y-grp_char[this.type].height/2),
					null,
					null,
					true
				);
				return;
			};
			
			this.getWidth = function():int
			{
				return grp_char[this.type].width;
			};
			
			this.getHeight = function():int
			{
				return grp_char[this.type].height;
			};
			
			this.isOutside = function():Boolean
			{
				if(this.x < -64)
				{
					return true;
				}
				else if(this.y < -64)
				{
					return true;
				}
				else if(this.x > 465+64)
				{
					return true;
				}
				else if(this.y > 465+64)
				{
					return true;
				}
				else
				{
					return false;
				}
			};
			
			this.vanish = function():void
			{
				this.deleteflag = true;
				return;
			};
			
			this.act_player = function():void
			{
				return;
			};
			
			this.act_item = function():void
			{
				if(count == 0)
				{
					vy = 1.8;
					div = 7+Math.random()*2;
				}
				
				this.x += Math.cos(count/(div*2)+Math.PI/2);
				this.y += Math.sin(count/div);
				
				if(this.y > 465-10)
				{
					vy = -1.8;
				}
				
				this.y += vy;
				
				if(this.isOutside() == true)
				{
					this.vanish();
				}
				return;
			};
			
			this.act_futtobi = function():void
			{
				if(count == 0)
				{
					vx = -4 + Math.random()*8;
					vy = -6 - Math.random()*4;
				}
				
				this.x += vx;
				this.y += vy;
				
				vy += 0.3;
				
				this.visible = !this.visible;
				
				if(this.isOutside() == true)
				{
					this.vanish();
				}
				return;
			};
		};
		
		private var Particle:Function = function(x:int, y:int, dir:Number, speed:Number):void
		{
			this.deleteflag = false;
			
			this.x = x;
			this.y = y;
			var dir:Number = dir;
			var speed:Number = speed;
			var size:Number = 16;
			
			this.main = function():void
			{
				this.x += Math.cos(Math.PI/128*dir)*speed;
				this.y += Math.sin(Math.PI/128*dir)*speed;
				
				speed /= 1.1;
				size -= 0.5;
				if(size <= 1) {this.vanish();}
				return;
			};
			
			this.draw = function(buffer:BitmapData):void
			{
				buffer.fillRect(new Rectangle(this.x-size/2, this.y-size/2, size, size), 0xFFFFFF);
				return;
			};
			
			this.vanish = function():void
			{
				this.deleteflag = true;
				return;
			};
		};
		
		//-------------------------------//
		// Change functions as follows.
		//-------------------------------//
		public function updateEnterFrame( e:Event ):void
		{
			if(grp_char == null)
			{
				init();
			}
			
			if(mouse_down_temp == true)
			{
				if(mouse_down == false)
				{
					mouse_press = true;
				}
				else
				{
					mouse_press = false;
				}
				
				mouse_down = true;
				mouse_release = false;
			}
			else
			{
				if(mouse_down == true)
				{
					mouse_release = true;
				}
				else
				{
					mouse_release = false;
				}
				
				mouse_down = false;
				mouse_press = false;
			}
			
			count++;
			
			buffer.lock();
			buffer2.lock();
			main();
			draw();
			buffer.unlock();
			buffer2.unlock();
			
			return;
		}
		
		private function init():void
		{
			Wonderfl.capture_delay(5);
			stage.quality = StageQuality.BEST;
			
			var temp:BitmapData = new BitmapData(262, 34, true);
			temp.draw(this, new Matrix(0.5, 0, 0, 0.5, 0, 0));
			bgcolor = temp.getPixel(0, 0);
			
			temp.applyFilter
			(
				temp,
				new Rectangle(0, 0, 200, 34),
				new Point(0, 0),
				new ColorMatrixFilter
				([
					0, 0, 0, 0, 0,
					0, 0, 0, 0, 0,
					0, 0, 0, 0, 0,
					-1, 0, 0, 0, 230
				])
			);
			temp.applyFilter
			(
				temp,
				new Rectangle(200, 0, 62, 34),
				new Point(200, 0),
				new ColorMatrixFilter
				([
					0, 0, 0, 0, 255,
					0, 0, 0, 0, 255,
					0, 0, 0, 0, 255,
					0, 1, 0, 0, 0
				])
			);
			
			for each(var o:DisplayObject in _sliceList)
			{
				removeChild(o);
			}
			
			bg = new Shape();
			bg.graphics.beginFill(bgcolor, 0.2);
			bg.graphics.drawRect(0, 0, 465, 465);
			bg.graphics.endFill();
			
			grp_char = new Array();
			var cell:BitmapData;
			
			cell = new BitmapData(33, 29);
			cell.copyPixels(temp, new Rectangle(4, 3, 33, 29), new Point(0, 0));
			grp_char.push(cell);
			cell = new BitmapData(28, 29);
			cell.copyPixels(temp, new Rectangle(37, 3, 28, 29), new Point(0, 0));
			grp_char.push(cell);
			cell = new BitmapData(21, 29);
			cell.copyPixels(temp, new Rectangle(87, 3, 21, 29), new Point(0, 0));
			grp_char.push(cell);
			cell = new BitmapData(20, 29);
			cell.copyPixels(temp, new Rectangle(143, 3, 20, 29), new Point(0, 0));
			grp_char.push(cell);
			cell = new BitmapData(25, 29);
			cell.copyPixels(temp, new Rectangle(163, 3, 25, 29), new Point(0, 0));
			grp_char.push(cell);
			cell = new BitmapData(11, 29);
			cell.copyPixels(temp, new Rectangle(189, 3, 11, 29), new Point(0, 0));
			grp_char.push(cell);
			cell = new BitmapData(28, 29);
			cell.copyPixels(temp, new Rectangle(200, 3, 28, 29), new Point(0, 0));
			grp_char.push(cell);
			cell = new BitmapData(28, 29);
			cell.copyPixels(temp, new Rectangle(229, 3, 28, 29), new Point(0, 0));
			grp_char.push(cell);
			
			massmedian = [0, 1, 2, 2, 0, 3, 4, 5, 6, 7];
			for(var i:int = 0; i < massmedian.length; i++)
			{
				massmedian_width += grp_char[massmedian[i]].width;
			}
			
			player = new Player();
			charpool = new Array();
			particlepool = new Array();
			
			buffer = new BitmapData(465, 465, false, bgcolor);
			buffer2 = new BitmapData(465, 465, false, bgcolor);
			screen = new Sprite();
			screen.graphics.beginBitmapFill(buffer);
			screen.graphics.drawRect(0, 0, buffer.width, buffer.height);
			
			addChild(screen);
			
			screen.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
			screen.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
			stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
			
			count = -1;
			stage.quality = StageQuality.LOW;
			
			changeScene("act_title");
			return;
		}
		
		private function onMouseMove(event:Event):void
		{
			mouse_x = event.target.mouseX;
			mouse_y = event.target.mouseY;
			
			flash.ui.Mouse.hide();
			return;
		}
		
		private function onMouseDown(event:Event):void
		{
			mouse_down_temp = true;
			return;
		}
		
		private function onMouseUp(event:Event):void
		{
			mouse_down_temp = false;
			return;
		}
		
		private function main():void
		{
			var i:int;
			this[action]();
			
			player.main();
			for(i = 0; i < charpool.length; i++)
			{
				charpool[i].main();
				if(charpool[i].deleteflag == true)
				{
					charpool.splice(i, 1);
					i--;
				}
			}
			for(i = 0; i < particlepool.length; i++)
			{
				particlepool[i].main();
				if(particlepool[i].deleteflag == true)
				{
					particlepool.splice(i, 1);
					i--;
				}
			}
			return;
		}
		
		private function draw():void
		{
			var i:int;
			
			buffer2.colorTransform(buffer2.rect, new ColorTransform(-1, -1, -1, 1, 255, 255, 255, 0));
			for(i = 0; i < charpool.length; i++)
			{
				if(charpool[i].visible == false)
				{
					continue;
				}
				charpool[i].draw(buffer2);
			}
			buffer2.colorTransform(buffer2.rect, new ColorTransform(-1, -1, -1, 1, 255, 255, 255, 0));
			buffer2.scroll(0, 1);
			buffer2.draw(bg);
			
			buffer.fillRect(buffer.rect, bgcolor);
			buffer.copyPixels(buffer2, buffer2.rect, new Point(0, 0));
			
			player.draw(buffer);
			for(i = 0; i < charpool.length; i++)
			{
				if(charpool[i].visible == false)
				{
					continue;
				}
				charpool[i].draw(buffer);
			}
			for(i = 0; i < particlepool.length; i++)
			{
				particlepool[i].draw(buffer);
			}
			return;
		}
		
		private function changeScene(name:String):void
		{
			action = name;
			count = -1;
			return;
		}
		
		private function addCharacter(char:Object):Object
		{
			charpool.push(char);
			return char;
		}
		
		private function addItem(x:int, y:int, type:int):Object
		{
			var char:Object = new Character(x, y, type, "act_item");
			return addCharacter(char);
		}
		
		private function addParticle(x:int, y:int, dir:Number, speed:Number):Object
		{
			var particle:Object = new Particle(x, y, dir, speed);
			particlepool.push(particle);
			return particle;
		}
		
		private function act_title():void
		{
			if(count == 0)
			{
				var x:int = 50;
				for(var i:int = 0; i < massmedian.length; i++)
				{
					player.formation.push(addCharacter(new Character(x, 100, massmedian[i])));
				}
			}
			
			var format:TextFormat;
			if(count == 70)
			{
				format = new TextFormat();
				format.font = "_等幅";
				format.bold = true;
				format.size = 28;
				format.color = 0xFFFFFF;
				format.align = TextFormatAlign.CENTER;
				
				textfield2 = new TextField();
				textfield2.defaultTextFormat = format;
				textfield2.text = "合体ゲーム";
				textfield2.x = 0;
				textfield2.y = 200;
				textfield2.width = 465;
				textfield2.selectable = false;
				textfield2.mouseEnabled = false;
				
				addChild(textfield2);
			}
			
			if(count == 80)
			{
				format = new TextFormat();
				format.font = "_sans";
				format.bold = true;
				format.size = 24;
				format.color = 0xFFFF00;
				format.align = TextFormatAlign.CENTER;
				
				textfield = new TextField();
				textfield.defaultTextFormat = format;
				textfield.text = "CLICK TO START";
				textfield.x = 0;
				textfield.y = 300;
				textfield.width = 465;
				textfield.selectable = false;
				textfield.mouseEnabled = false;
				
				addChild(textfield);
			}
			
			if(count >= 80)
			{
				if(count % 80 == 0)
				{
					textfield.visible = true;
				}
				if(count % 80 == 60)
				{
					textfield.visible = false;
				}
				
				if(mouse_press == true)
				{
					for each(var o:Object in charpool)
					{
						if(o.type != 6)
						{
							o.changeAction("act_futtobi");
						}
					}
					removeChild(textfield);
					removeChild(textfield2);
					player.changeAction("act_main");
					changeScene("act_game");
					return;
				}
			}
			return;
		}
		
		private function act_game():void
		{
			if(count == 0)
			{
				time = getTimer();
			}
			
			if(count % 50 == 0)
			{
				addItem(20+Math.random()*425, -16-Math.random()*40, Math.floor(Math.random()*8));
			}
			
			collision_item();
			
			if(player.formation.length == massmedian.length)
			{
				for(var i:int = 0; i < player.formation.length; i++)
				{
					if(player.formation[i].type != massmedian[i])
					{
						return;
					}
				}
				
				for(var j:int = 0; j < charpool.length; j++)
				{
					if(charpool[j].action != "act_player")
					{
						charpool[j].changeAction("act_futtobi");
					}
				}
				time = (getTimer() - time)/1000;
				
				player.changeAction("act_complete");
				changeScene("act_complete");
				return;
			}
			return;
		}
		
		private function collision_item():void
		{
			for(var i:int = 0; i < player.formation.length; i++)
			{
				for(var j:int = 0; j < charpool.length; j++)
				{
					if(charpool[j].action == "act_item")
					{
						if((player.formation[i].x-player.formation[i].getWidth()/2 < charpool[j].x)
						 && (player.formation[i].y-player.formation[i].getHeight()/2 < charpool[j].y)
						 && (player.formation[i].x+player.formation[i].getWidth()/2 > charpool[j].x)
						 && (player.formation[i].y+player.formation[i].getHeight()/2 > charpool[j].y))
						{
							for(var k:int = 0; k < 8; k++)
							{
								addParticle(player.formation[i].x, player.formation[i].y, k*32, 6);
							}
							if(player.formation.length < massmedian.length)
							{
								if(player.formation[i].x > charpool[j].x)
								{
									player.formation.splice(i, 0, charpool[j]);
								}
								else
								{
									player.formation.splice(i+1, 0, charpool[j]);
								}
							}
							else
							{
								player.formation[i].changeAction("act_futtobi");
								player.formation.splice(i, 1, charpool[j]);
							}
							charpool[j].changeAction("act_player");
							return;
						}
					}
				}
			}
			return;
		}
		
		private function act_complete():void
		{
			if(count == 0)
			{
				var format:TextFormat = new TextFormat();
				format.font = "_明朝";
				format.bold = true;
				format.size = 60;
				format.color = 0xFFFFFF;
				format.align = TextFormatAlign.CENTER;
				
				textfield = new TextField();
				textfield.defaultTextFormat = format;
				textfield.text = "完成";
				textfield.x = 0;
				textfield.y = 280;
				textfield.width = 465;
				textfield.selectable = false;
				textfield.mouseEnabled = false;
				
				format = new TextFormat();
				format.font = "_等幅";
				format.bold = true;
				format.size = 24;
				format.color = 0xFFFFFF;
				format.align = TextFormatAlign.CENTER;
				
				textfield2 = new TextField();
				textfield2.defaultTextFormat = format;
				textfield2.text = "Time : "+time+"秒";
				textfield2.x = 0;
				textfield2.y = 360;
				textfield2.width = 465;
				textfield2.selectable = false;
				textfield2.mouseEnabled = false;
				
				addChild(textfield);
				addChild(textfield2);
			}
			
			if(count >= 120)
			{
				if(mouse_press == true)
				{
					for(var i:int = 0; i < player.formation.length; i++)
					{
						player.formation[i].vanish();
					}
					removeChild(textfield);
					removeChild(textfield2);
					player.changeAction("act_title");
					changeScene("act_title");
					return;
				}
			}
			return;
		}
		
		//-------------------------------//
		// Do not change following codes.
		//-------------------------------//
		public function Begineer(){
            var ctxt  :LoaderContext = new LoaderContext(true);
			var loader:Loader = new Loader();
			loader.contentLoaderInfo.addEventListener( Event.COMPLETE, onLoadComplete );
			loader.load( new URLRequest("http://swf.wonderfl.net/static/assets/massmedian.png"), ctxt );
        }
		
		public function onLoadComplete(e:Event):void {
			var loader:Loader = LoaderInfo( e.target ).loader;
			loader.contentLoaderInfo.removeEventListener( Event.COMPLETE, onLoadComplete );
			
			var bitmapdata:BitmapData = new BitmapData( loader.width, loader.height, true, 0xFF0000 );
			bitmapdata.draw( loader );
			
			_sliceList = sliceBanner( bitmapdata, bitmapdata.width );
			
			addEventListener( Event.ENTER_FRAME, updateEnterFrame );
		}
		
		
		private function sliceBanner( banner:BitmapData, length:int = 100 ):Array{
			var sliceList:Array = [];
			var w:int = Math.floor( banner.width/length );
			var h:int = Math.floor( banner.height );
			
			var t:int = Math.ceil( banner.width - w*length );
			var mat:Matrix = new Matrix();
				
			for( var i:int = 0; i<length; i++ ) {
				var bmpd :BitmapData = new BitmapData( w, h, true, 0xFFFF00 );
				mat.tx = -w*i;
				bmpd.draw( banner, mat );
				var part:DisplayObject = addChild( new Bitmap( bmpd ) );
				part.x = w*i;
				sliceList.push( part );
			}
			return sliceList;
		}
		
	}
}