/**
 * Copyright shevchenko ( http://wonderfl.net/user/shevchenko )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hmRu
 */

// forked from Yasu_Tana9870's forked from: Mesh Clock
// forked from Kazshliu's Mesh Clock
package {
	
	import gs.TweenLite;
	import gs.easing.*;
	import flash.events.Event;
	import flash.events.TimerEvent;
	import flash.utils.Timer;
	import org.papervision3d.core.geom.renderables.Triangle3D;
	import org.papervision3d.core.geom.renderables.Vertex3D;
	import org.papervision3d.core.math.Number3D;
	import org.papervision3d.lights.PointLight3D;
	import org.papervision3d.materials.shadematerials.FlatShadeMaterial;
	import org.papervision3d.objects.DisplayObject3D;
	import org.papervision3d.objects.primitives.Sphere;
	import org.papervision3d.view.BasicView;
	
	/**
	 * @author Ryan Liu | www.ryan-liu.com
	 * @since 2009-12-2 15:19
	 */
	[SWF(backgroundColor=0x0)]
	public class MeshTransform extends BasicView {
		
		private var light:PointLight3D
		private var mat:FlatShadeMaterial
		private var mesh:DisplayObject3D;
		private var n3dArr:Array = [];
		private var timer:Timer
		
		public function MeshTransform() {
			initMesh();			
			initData();
			startRendering();
			doTransform();
			timer = new Timer(1000);
			timer.addEventListener(TimerEvent.TIMER, onTimer);
			timer.start();
			
			addEventListener(Event.ENTER_FRAME, loop);
		}
		
		private function initMesh():void {
			light = new PointLight3D();
			light.y = -8000;
			light.x = -8000;
			light.z = -8000;
			mat = new FlatShadeMaterial(light, 0xffff99, 0xff9900);
			
			mesh = new Sphere(mat, 250, 8, 8);
			scene.addChild(mesh);
			
		}
		private function initData():void {
			for each( var vertice:Vertex3D in mesh.geometry.vertices) {
				n3dArr.push(vertice.toNumber3D());
			}
		}
		private function doTransform():void {
			for ( var index:* in mesh.geometry.vertices) {
				var vertice:Vertex3D = mesh.geometry.vertices[index] as Vertex3D;
				var n3d:Number3D = n3dArr[index] as Number3D;
				var tx:Number = (.5 + Math.random() * 1.5) * n3d.x;
				var ty:Number = (.5 + Math.random() * 1.5) * n3d.y;
				var tz:Number = (.5 + Math.random() * 1.5) * n3d.z;
				TweenLite.to(vertice, .8, { x:tx, y:ty, z:tz, ease:Elastic.easeOut } );
			}
			var rx:Number = mesh.rotationX + (Math.random() - Math.random() ) * 45;
			var ry:Number = mesh.rotationY  + (Math.random() - Math.random() ) * 45;
			var rz:Number = mesh.rotationZ  + (Math.random() - Math.random() ) * 45;
			TweenLite.to(mesh, .5, { rotationX:rx, rotationY:ry, rotationZ:rz, ease:Elastic.easeOut } );

		}
		private function onTimer(e:TimerEvent):void {
			doTransform();
		}
		private function loop(e:Event):void {
			//mesh.rotationY++
			for each(var vertice:Vertex3D in mesh.geometry.vertices) {
				vertice.calculateNormal();
			}
			for each(var face:Triangle3D in mesh.geometry.faces) {
				
				face.createNormal();
			}
		}
		
	}
	
}