/**
 * Copyright CZQ ( http://wonderfl.net/user/CZQ )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hm8U
 */

package {
import flash.events.MouseEvent;
import flash.display.Sprite;
[SWF(width="465", height="465", backgroundColor="0", frameRate="60")]
public class LevelClear extends Sprite {
    private var spt:SpecialText;
    
    public function LevelClear() {
        spt = new SpecialText();
        spt.create();
        addChild(spt);
        spt.y = 230;
        stage.addEventListener(MouseEvent.CLICK,onClick);
    }
    
    private function onClick(e:MouseEvent):void
    {
        spt.show();
    }
}
}
import com.greensock.TweenLite;
import flash.display.*;
import flash.filters.*;
import flash.geom.*;
import flash.text.*;
    
class SpecialText extends Sprite
{
    private var _texts:Array;
    private var _size:int = 40;
        
    public function SpecialText()
    {
        mouseEnabled = false;
    }
    
    public function create():void {
        var str:String = "Level Clear!" ;
        createChars(str); 
    }
    
    private function createChars(str:String):void 
    {
        _texts = [];
        var tf:TextField = new TextField();
        tf.defaultTextFormat = new TextFormat("Arial", _size, 0xFFFFFF, true);
        for(var i:int = 0; i < str.length; i++){
            trace(str.charAt(i));
            tf.text = str.charAt(i);
            var bmd:BitmapData = new BitmapData(_size * 2,_size * 2, true,0x00);
            bmd.draw(tf, new Matrix(1,0,0,1,5,0));
            var matrix:Array = [0,1,0,
                1,1,1,
                0,1,0
            ];
            bmd.applyFilter(bmd, bmd.rect,new Point(), new GlowFilter(0x000000,1.0,2.0,2.0,10,2));
            bmd.applyFilter(bmd, bmd.rect, new Point(), new ConvolutionFilter(3,3,matrix,3));
            var bm:Bitmap = new Bitmap(bmd);
            bm.alpha = 0;
            _texts.push(bm);
        }
    }
    
    public function show(from:Rectangle = null,time:Number = 0.3):void
    {
        if (from == null) from = new Rectangle(0,0,465,465);
        for (var i:int = 0;i < _texts.length; i++){
            var bm:Bitmap = _texts[i];
            if (bm.parent) bm.parent.removeChild(bm);
            bm.alpha = 0;
            bm.x = from.x;
            bm.y = from.y;
            bm.width = from.width;
            bm.height = from.height;
            addChild(bm);
            TweenLite.to(bm,time,{x:i * _size, y:0, width:_size * 2, height:_size * 2, alpha:1,delay: i * time / 2});
        }
    }
}