/**
 * Copyright bellonieta ( http://wonderfl.net/user/bellonieta )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hm5p
 */

package 
{
	import flash.display.*;
	import flash.events.*;
	import flash.net.*;
	import flash.text.*;
	import org.papervision3d.materials.*;
	import org.papervision3d.materials.utils.*;
	import org.papervision3d.objects.primitives.*;
	import org.papervision3d.view.*;
	
	public class Main extends BasicView 
	{
		private var plane:Plane;
		
		/**
		 * Constructor
		 */
		public function Main():void 
		{
			initStage();
			init3D();
		}
		
		private function initStage(e:Event = null):void 
		{			
			stage.align = StageAlign.TOP_LEFT;
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.quality = StageQuality.BEST;
		}
		
		private function init3D():void
		{
			plane = new Plane(getBmpMaterial());
			scene.addChild(plane);
			
			stage.addEventListener(Event.ENTER_FRAME, onEnterFrame);
			
			_camera.zoom = 60;
			startRendering();
		}
				
		private function getBmpMaterial():BitmapMaterial
		{
			var txtField:TextField = new TextField();
			//txtField.autoSize = "center";
			txtField.width = 500;
			txtField.height = 500;
			txtField.backgroundColor = 0xfff;
			txtField.text = "こんにちわ，世界！";
			var bmpData:BitmapData = new BitmapData(txtField.width, txtField.height);
			bmpData.draw(txtField);
			var bmpMaterial:BitmapMaterial = new BitmapMaterial(bmpData);
			bmpMaterial.doubleSided = true;
			bmpMaterial.smooth = true;
			return bmpMaterial;
		}
				
		private function onEnterFrame(e:Event):void
		{
			plane.yaw(mouseX / 30);
			plane.pitch(mouseY / 30);
		}
	}
}
