/**
 * Copyright nicotroia ( http://wonderfl.net/user/nicotroia )
 * GNU General Public License, v3 ( http://www.gnu.org/licenses/quick-guide-gplv3.html )
 * Downloaded from: http://wonderfl.net/c/hkxK
 */

package {
    import flash.text.TextField;
    import flash.filters.GlowFilter;
    import flash.geom.Point;
    import flash.geom.Matrix;
    import flash.display.Bitmap;
    import flash.geom.Rectangle;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.display.DisplayObject;
    import flash.display.DisplayObjectContainer;
    import flash.filters.BitmapFilter;
    
    import com.demonsters.debugger.MonsterDebugger;
    
    public class FlashTest extends Sprite { 
    
        private var bitmap:Bitmap;
        private var bmd:BitmapData;
        
        private var copyPixels:BitmapData;
        private var copyBitmap:Bitmap;
        
        public function FlashTest() {
            // write as3 code here..
            MonsterDebugger.initialize(this);
            debug("start");
            
            /*
                CREATE INITIAL SPRITE
            */
            
            var spriteSheet:Sprite = new Sprite();
            spriteSheet.x = spriteSheet.y = 50; 
            //addChild(spriteSheet); //blitting! 
            
            //moral of the story: spriteSheet needs to be on the stage when processDisplayObjectContainer() runs...
            //or fix the function.
            
            var rect:Sprite = new Sprite();
            rect.graphics.beginFill(0xff333333);
            rect.graphics.drawRect(0,0,100,100);
            rect.graphics.endFill();
            
            rect.x = rect.y = 0; //this is no longer true for some reason.. //give room for filter or else draw will clip any negative top/left pixels
            
            var glow:GlowFilter = new GlowFilter(0x666666, 1, 20, 20, 1, 1);
            rect.filters = [glow];
            
            spriteSheet.addChild(rect);
            
            
            /*
                COPY SPRITE WITH BITMAP_DATA DRAW
            */
            
            bmd = new BitmapData( rect.getBounds(spriteSheet).width + rect.x + spriteSheet.x, rect.getBounds(spriteSheet).height + rect.y + spriteSheet.y, true, 0 );
            var processedSpriteBounds:Rectangle = bmd.generateFilterRect(rect.getBounds(spriteSheet), glow);
            
            bmd = new BitmapData( processedSpriteBounds.width, processedSpriteBounds.height, true, 0 );
            bmd.fillRect(bmd.rect, 0xccffffcc);
            
            bmd.draw(
                spriteSheet, 
                //new Matrix(1,0,0,1, -processedSpriteBounds.x + spriteSheet.x, -processedSpriteBounds.y + spriteSheet.y ), 
                new Matrix(1,0,0,1, -processedSpriteBounds.x, -processedSpriteBounds.y ), 
                null, 
                null, 
                new Rectangle(0,0, processedSpriteBounds.width, processedSpriteBounds.height), 
                false
            );
            
            bitmap = new Bitmap(bmd, "never");
            bitmap.x = 175, bitmap.y = 40;
            
            addChild(bitmap);
            
            
            /*
                COPY BITMAP REPEATEDLY WITH COPY_PIXELS
            */
            
            copyPixels = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0);
            //this will be our "particle canvas" 
            
            for( var i:uint = 0; i < 7; i++ ) { 
                
                var x:Number, y:Number;
                
                //no math for me today
                switch( i ) { 
                    case 0 : x = 310, y = 40; 
                    break;
                    case 1 : x = 40, y = 175; 
                    break;
                    case 2 : x = 175, y = 175; 
                    break;
                    case 3 : x = 310, y = 175; 
                    break;
                    case 4 : x = 40, y = 310; 
                    break;
                    case 5 : x = 175, y = 310; 
                    break;
                    case 6 : x = 310, y = 310; 
                    break;
                }
                
                copyPixels.copyPixels( 
                    bitmap.bitmapData, //bmd, 
                    bitmap.getRect(bitmap), 
                    //rect.globalToLocal(new Point(x,y)), //NO!!!! this translates with the spriteSheet x,y
                    new Point(x,y), 
                    null, null, true
                ); 
            
            } //endfor
            
            copyBitmap = new Bitmap(copyPixels);
            
            addChild(copyBitmap);
        }
        
        public function debug(string:*):void
        {
            MonsterDebugger.trace(this, string);
        }
        
        //decent helper function here: //issue with it because sprite needs to be on the stage for proper calculations..
        //http://stackoverflow.com/questions/466280/get-bounds-of-filters-applied-to-flash-sprite-within-sprite
        
    }
}