/**
 * Copyright k3lab ( http://wonderfl.net/user/k3lab )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hkts
 */

package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Matrix;
    import flash.geom.Point;
    [SWF(width = "465", height = "465", frameRate = "60")]
    public class FlashTest extends Sprite {
        private var canvas:BitmapData;
        private var w:int=250;
        private var h:int=250;
        private var sp:Sprite;
        private var app:Array = new Array();
        private var dpp:Array = new Array();
        private var random:int;
        private var ptArray:Array;
        private var baseYArray:Array;
        public function FlashTest() {
            canvas = new BitmapData(w, h, true);
            sp = addChild(new Sprite()) as Sprite;
            sp.x = 11;
            sp.y = 200;
            random=Math.random()*10;
            var n:int;
            while (n < 15) {
                app[n] = new Point(Math.random() * w, Math.random() * h);
                dpp[n] = new Point(Math.random() * 10 - 5, Math.random() * 10 - 5);
                ++n;
            }
            ptArray = [];
            baseYArray=[];
            for (var i:int = 0; i < 15; i++ ) {
                for (var j:int = 0; j < 15; j++ ) {
                    var _pt:Sprite = sp.addChild(new Sprite()) as Sprite;
                    _pt.x=11*(i-j)+200;
                    _pt.y= 6 * (i + j) + 120;
                    baseYArray[i+"_"+j]=_pt.y;
                    var bar:Sprite = _pt. addChild(new Sprite()) as Sprite;
                    var left:Sprite = bar. addChild(new Sprite()) as Sprite;
                    var right:Sprite = bar. addChild(new Sprite()) as Sprite;
                    left.graphics.clear();
                    left.graphics.beginFill(0x657df3);
                    left.graphics.drawRect(11, 0, 11, 1);
                    bar.y=11;
                    bar.graphics.endFill();
                    right.graphics.clear();
                    right.graphics.beginFill(0x3d5bf1,1);
                    right.graphics.drawRect(22, 0, 11, 1);
                    var tops:Sprite = _pt.addChild(new Sprite()) as Sprite;
                    tops.graphics.beginFill(0x94a6fc, 1);
                    tops.graphics.moveTo(22,  6);   
                    tops.graphics.lineTo(33, 12);   
                    tops.graphics.lineTo(22, 18);   
                    tops.graphics.lineTo(11, 12);   
                    tops.graphics.lineTo(22,  6); 
                    tops.graphics.endFill(); 
                    var bottom:Sprite = sp.addChild(new Sprite()) as Sprite;
                    var bleft:Sprite = bottom. addChild(new Sprite()) as Sprite;
                    var bright:Sprite = bottom. addChild(new Sprite()) as Sprite;
                    bleft.graphics.beginFill(0x657df3, 1);
                    bleft.graphics.moveTo(22,  6);   
                    bleft.graphics.lineTo(22, 18); 
                    bleft.graphics.lineTo(11, 12);   
                    bleft.graphics.lineTo(22,  6); 
                    bleft.graphics.endFill();
                    bright.graphics.beginFill(0x3d5bf1, 1);
                    bright.graphics.moveTo(22,  6);   
                    bright.graphics.lineTo(33, 12); 
                    bright.graphics.lineTo(22, 18);   
                    bright.graphics.lineTo(22,  6); 
                    bright.graphics.endFill();
                    bottom.x=11*(i-j)+200;
                    bottom.y = 6 * (i + j) + 120;
                    ptArray[i+"_"+j]={top:_pt,middle:bar};	
                }
            }
            addEventListener(Event.ENTER_FRAME, update);
            stage.addEventListener(MouseEvent.MOUSE_DOWN, _down);
        }
        private function update(e:Event):void {
            for (var i:int = 0; i < 15; i++ ) {
                for(var j:int = 0; j < 15; j++ ) {
                    var px:Number = canvas.getPixel(i * 15, j * 15);
                    px = px /40000;
                    ptArray[i + "_" + j].top.y = (-5 - px);
                    ptArray[i + "_" + j].middle.height = (baseYArray[i + "_" + j] + px + 6);
                }
            }
            var n:int;
            while (n < 15) {
                app[n].x +=  dpp[n].x;
                app[n].y +=  dpp[n].y;
                ++n;
            }
            canvas.perlinNoise(w, h, 1, random, false, false, 1, true, app);		
        }
        private function _down(e:MouseEvent):void {
            var n:int;
            while (n < 15) {
                dpp[n] = new Point(Math.random() * 10 - 5, Math.random() * 10 - 5);
                ++n;
            }
        }
    }
}