/**
 * Copyright clockmaker ( http://wonderfl.net/user/clockmaker )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hke4
 */

package {
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.utils.getTimer;
    
    import org.papervision3d.core.effects.BitmapLayerEffect;
    import org.papervision3d.core.geom.Pixels;
    import org.papervision3d.core.geom.renderables.Pixel3D;
    import org.papervision3d.lights.PointLight3D;
    import org.papervision3d.materials.shadematerials.FlatShadeMaterial;
    import org.papervision3d.objects.primitives.Sphere;
    import org.papervision3d.view.BasicView;
    import org.papervision3d.view.layer.BitmapEffectLayer;
    import org.papervision3d.view.layer.ViewportLayer;
    
    [SWF(frameRate="60")]
    public class Main extends BasicView {
        public function Main():void {
            // ビットマップエフェクトレイヤーを作成
            var bitmapEffectLayer:BitmapEffectLayer = new BitmapEffectLayer(viewport, 640, 480);
            viewport.containerSprite.addLayer(bitmapEffectLayer);
            // ブラーエフェクトを設定
            bitmapEffectLayer.addEffect(new BitmapLayerEffect(new BlurFilter(2, 2, 4), false));
            // Picelsを作成
            var pixels:Pixels = new Pixels(bitmapEffectLayer);
            scene.addChild(pixels);
            for (var i:int = 0; i < 1000; i++) {
                // 座標を設定
                var rot:Number = (i / 1000) * 360 * 4; // 4回転
                var pointX:Number = 500 * Math.sin(rot * Math.PI / 180);
                var pointZ:Number = 500 * Math.cos(rot * Math.PI / 180);
                var pointY:Number = i - 500; // らせん状に配置
                // 点を描写する
                var pixel:Pixel3D = new Pixel3D(0xFF0099FF, pointX, pointY, pointZ);
                pixels.addPixel3D(pixel);
            }
            // プリミティブ
            var sphere:Sphere = new Sphere(new FlatShadeMaterial(new PointLight3D()), 300);
            scene.addChild(sphere);
            // 入れ替え〜
            var sphereLayer:ViewportLayer = sphere.createViewportLayer(viewport);
            viewport.containerSprite.setChildIndex(bitmapEffectLayer, 0);
            viewport.containerSprite.setChildIndex(sphereLayer, 1);
            // レンダリング
            startRendering();
            // エンターフレームイベントの登録
            addEventListener(Event.ENTER_FRAME, loop);
        }
        
        private function loop(e:Event):void {
            // カメラの運動を設定
            camera.x = 1500 * Math.sin(getTimer() / 2000);
            camera.z = 1500 * Math.cos(getTimer() / 2000);
            camera.y = 800 * Math.sin(getTimer() / 1000);
        }
    }
}