/**
 * Copyright WLAD ( http://wonderfl.net/user/WLAD )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hk68
 */

package {

	import flash.display.Sprite;
	
	[SWF( width="465", height="465" )]
	public class ComplexRotation extends Sprite
	{
		public function ComplexRotation()
		{
			graphics.clear();
			graphics.beginFill(0);
			graphics.drawRect(0, 0, 1000, 1000);
			graphics.endFill();
			
			stage.frameRate = 40;
			
			
			var maxSpeed:Number = 8;
			var count:Number = 25;
			var radius:Number = 40;
			
			for ( var i:int = 0; i < 7; i ++ )
			{
				make( count + i * count, 1, radius + radius * i, i * 180, maxSpeed / ( Math.pow( 2, i ) ), 0xFF0000 );
			}
			
			//make( 100, 1, 160, 0, 0.25, 0xFF0000 );
			//make( 100, 1, 160, 0, 0.25, 0xFF0000 );
			//make( 75, 1, 120, 0, 0.5, 0xFF0000 );
			//make( 50, 1, 80, 0, 1, 0xFF0000 );
			//make( 25, 1, 40, 0, 2, 0xFF0000 );

			
		}
		
		private function make( count:int, type:int, radius:Number, angle:int, speed:Number, color:uint, radius2:Number = NaN ):void
		{
			var c:Container = new Container( count, type );
			c.rotation = angle;
			addChild( c );
			c.radius = radius;
			c.color = color;
			c.speed = speed;
			if ( !isNaN( radius2 ) ) c.particleRadius = radius2;
			c.x = stage.stageWidth >> 1;
			c.y = stage.stageHeight >> 1;
		}
	}
}
import flash.display.DisplayObject;
import flash.display.Sprite;
import flash.geom.Point;

class Container extends Sprite
{
	public var speed:Number = 2;
	public var radius:Number = 80;
	public var particleRadius:Number = 20;
	public var color:uint = 0xFF0000;
	
	public function Container( particles:int, type:int = 0 ) {
		
		addEventListener('enterFrame', function(e:*):void
		{
			rotation += speed;
			
			var p:Point;
			var a:Number = ( 2 * Math.PI ) / numChildren;
			
			forEach( function( particle:Particle, i:int ):void {
				
				particle.rotation = -rotation;
				p = Point.polar( radius , a * i );
				particle.x = p.x;
				particle.y = p.y;
				particle.render( particleRadius, color );
			});
			
		});
		
		while ( --particles >= 0 ) addChild( new Particle( particles == 0 ? 0 : type ) );
	}
	
	
	/// A: function( p:Particle ):void, B: function( p:Particle, index:int ):void
	public function forEach( callBack:Function ):void
	{
		var i:int;
		if ( callBack.length == 1 ) for ( i = 0; i < numChildren; i++ ) callBack( Particle ( getChildAt(i) ) );
		if ( callBack.length == 2 ) for ( i = 0; i < numChildren; i++ ) callBack( Particle ( getChildAt(i) ), i );
		
	}
}


class Particle extends Sprite
{
	private var type:int;
	public function Particle( type:int ) {
		this.type = type;
	}
	
	public function render( radius:Number, color:uint ):void
	{
		graphics.clear();
		graphics.beginFill( 0 );
		graphics.lineStyle( 2, 0x717171 );
		graphics.drawCircle( 0 , 0, radius );
		graphics.endFill();
		
		var r:Number = radius * 0.6;
		
		switch( type )
		{
			case 0:
				
				break;
			case 1:
				
				graphics.lineStyle( r * 0.2, color, 1, false, 'normal', 'none' );
				graphics.moveTo( r, r );
				graphics.lineTo( -r, -r );
				graphics.moveTo( -r, r );
				graphics.lineTo( r, -r );
				
				break;
			case 2:
				
				graphics.lineStyle( r * 0.2, color );
				graphics.drawCircle( 0 , 0 , r );
				
				break;
		}
	}
}