/**
 * Copyright hacker_rur__k1j ( http://wonderfl.net/user/hacker_rur__k1j )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hjTw
 */

// forked from mex_takagi's forked from: Saqoosha challenge for professionals
package 
{
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.display.Bitmap;
	import flash.events.Event;
	import flash.filters.BlurFilter;
	import flash.filters.GlowFilter;
	import flash.filters.GradientGlowFilter;
	import flash.geom.Matrix;
	
	[SWF(width = 465, height = 465, backgroundColor = 0xffffff, frameRate = 30)]
	public class FlashTest extends Sprite
	{
		private var _figureArray:Array;
		private var _canvasSprite:Sprite;
		private var _canvasBmd:BitmapData;
		private var _canvas:Bitmap;
		private var _blurFileter:BlurFilter;
		private var _glowFileter:GradientGlowFilter;
		/**
		 * constructor
		 */
		public function FlashTest()
		{
			_figureArray = [[0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 1],
							[0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0],
							[0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0],
							[1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1],
							[0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0],
							[0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0],
							[0, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0],
							[0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0],
							[0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0],
							[0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0],
							[0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0]];
			
			_canvasSprite = new Sprite();
			_canvasBmd = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0xFF000000);
			_canvas = new Bitmap(_canvasBmd);
			
			_glowFileter = new GradientGlowFilter(10, 90, [0xFF0000, 0xFFFF00, 0xFFFFFF], [0.8, 0.6, 1], [0, 120, 255], 8, 10, 1, 1);
			_blurFileter = new BlurFilter(10, 10, 1);
			_canvasSprite.filters = [_blurFileter, _glowFileter];
			
			var i:uint = 0;
			var row:uint = _figureArray.length;
			for (i = 0; i < row;i++ )
			{
				var line:uint = _figureArray[i].length;
				for (var j:uint = 0; j < line;j++ )
				{
					if (_figureArray[i][j] == 1)
					{
						var unit:BallUnit = new BallUnit();
						unit.x = j * 20;
						unit.y = i * 20;
						_canvasSprite.addChild(unit);
					}
				}
			}
			
			addChild(_canvas);
			addEventListener(Event.ENTER_FRAME, enterFrameHandler);
		}
		/**
		 * enterFrameHandler
		 * @param event Event
		 */
		private function enterFrameHandler(event:Event):void 
		{
			_canvas.bitmapData.dispose();
			var bmd:BitmapData = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0xFF000000);
			var matrix:Matrix = new Matrix();
			matrix.translate( 150, 160);
			bmd.lock();
			bmd.draw(_canvasSprite, matrix);
			bmd.unlock();
			bmd.paletteMap(bmd, bmd.rect, bmd.rect.topLeft, null, null, null);
			_canvas.bitmapData = bmd;
		}
	}
}

import flash.display.Sprite
class BallUnit extends Sprite
{
	private var _ballArray:Array;
	/**
	 * constructor
	 */
	public function BallUnit()
	{
		_ballArray = new Array();
		
		for (var i:uint = 0; i < 5;i++ )
		{
			var ball:Ball = new Ball(35 - (i * 4));
			ball.y = -i * 5;
			_ballArray.push(ball);
			if (i != 0)
			{
				_ballArray[i - 1].addChild(ball);
			}
			else
			{
				addChild(ball);
			}
		}
	}
}

import flash.display.Sprite
import flash.events.Event;
import flash.filters.BlurFilter;
class Ball extends Sprite
{
	/**
	 * constructor
	 * @param size
	 */
	public function Ball(size:uint)
	{
		var sprite:Sprite = new Sprite();
		sprite.graphics.beginFill(0xFFFFFF);
		sprite.graphics.drawCircle(0, 0, size / 2);
		sprite.graphics.endFill();
		sprite.x = -size / 2;
		sprite.y = -size / 2;
		
		var filter:BlurFilter = new BlurFilter();
		sprite.filters = [filter];
		
		addChild(sprite);
		addEventListener(Event.ENTER_FRAME, enterFrameHandler);
	}
	/**
	 * enterFrameHandler
	 * @param event
	 */
	private function enterFrameHandler(event:Event):void
	{
		x += Math.random() * Math.random()*(2 - (-2) + 1) + (-2) - x;
		y += Math.random() * Math.random()*(6 - (-6) + 1) + (-6) - y - 6;
	}
}