/**
 * Copyright rickyhk ( http://wonderfl.net/user/rickyhk )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hjE7
 */

// forked from bradsedito's ff: X'mas present
// forked from dory's クリスマスモノ X'mas present
package 
{
    import flash.display.BlendMode;
    import flash.display.LoaderInfo;
    import flash.events.SecurityErrorEvent;
    import flash.system.System;
    import flash.system.Security;
    import flash.display.Loader;
    import flash.system.LoaderContext;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Rectangle;
    import flash.net.URLRequest;

    /**
     * クリスマスもの
     * 
     * ほっぺた触ると女の子が顔を赤らめます
     * 
     * @author dory
     */
    [SWF(backgroundColor="#000000", width="465", height="465", frameRate="60")]
     
    public class Main extends Sprite 
    {
        public static var instance:Main;
        
        private const WONDEFL_IMAGE_PATH:String = "http://assets.wonderfl.net/images/related_images/8/83/8305/8305445b4e41f37856f0c9d0751937e30e21c496m";
        private const IMG_PATH:String = WONDEFL_IMAGE_PATH + "";
        public static const STAGE_WIDTH:Number = 465;
        public static const STAGE_HEIGHT:Number = 465;
        public static const CHEEK_MAX_COUNT:int = 60;
        private const LEFT_CHEEK_X:Number = 200;
        private const LEFT_CHEEK_Y:Number = 160;
        private const RIGHT_CHEEK_X:Number = 290;
        private const RIGHT_CHEEK_Y:Number = 220;
        
        private var overCount:int = 0;
        private var effect:Effect;
        private var _cheekList:Array;
        
        public function Main():void 
        {
            Security.allowDomain("*");
            instance = this;
            init();
        }
        
        private function init():void 
        {
            drawBackImage();
            //drawCheeks();
            
            effect = new Effect();
            addChild( effect );
            
            addEventListener( Event.ENTER_FRAME, enterFrameHandler );
        }
        
        private function enterFrameHandler( event:Event ):void {
            effect.update();
            checkOver();
        }
        
        private function checkOver():void {
            var overed:Boolean = false;
            var cheek:Cheek;
            var i:int;
            for ( i = 0; i < _cheekList.length; i++ ) {
                cheek = _cheekList[ i ];
                if ( cheek.hitTestPoint( mouseX, mouseY ) ) {
                    overCount++;
                    if ( overCount > CHEEK_MAX_COUNT )
                        overCount = CHEEK_MAX_COUNT;
                    overed = true;
                    break;
                }
            }
            if ( !overed ) {
                overCount--;
                if ( overCount < 0 )
                    overCount = 0;
            }
                
            for ( i = 0; i < _cheekList.length; i++ ) {
                cheek = _cheekList[ i ];
                cheek.update( overCount );
            }
        }

        
        private function drawBackImage():void {
            var back:Sprite = new Sprite();
            back.graphics.beginFill( 0xffffff);
            back.graphics.drawRect( 0, 0, STAGE_WIDTH, STAGE_HEIGHT  );
            back.graphics.endFill();
            addChild( back );
            
            var loader:Loader = new Loader();
            var req:URLRequest = new URLRequest( IMG_PATH );
            loader.contentLoaderInfo.addEventListener( Event.COMPLETE, imgLoadCompleteHandler );
            loader.load( req ,new LoaderContext(true));
            addChild( loader );
        }
        
        private function drawCheeks():void {
            _cheekList = new Array();
            var cheek:Cheek;
            cheek = drawCheek( LEFT_CHEEK_X, LEFT_CHEEK_Y );
            _cheekList.push( cheek );
            cheek = drawCheek( RIGHT_CHEEK_X, RIGHT_CHEEK_Y );
            _cheekList.push( cheek );
        }
        
        private function drawCheek( x:Number, y:Number ):Cheek {
            var cheek:Cheek = new Cheek();
            cheek.x = x;
            cheek.y = y;
            addChild( cheek );
            return cheek;
        }
        
        private function imgLoadCompleteHandler( event:Event ):void {
            var info:LoaderInfo = event.currentTarget as LoaderInfo;
            info.removeEventListener( Event.COMPLETE, imgLoadCompleteHandler );
        }
    }
}

import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Sprite;
import flash.filters.BlurFilter;
import flash.geom.Point;
import flash.geom.Rectangle;
import flash.display.BlendMode;
import flash.geom.ColorTransform
/**
 * ...
 * @author dory
 */
class Effect extends Sprite
{
    private const LIGHT_MAX:int = 50;
    private const CHANGE_COL_SPEED:int = 2;
    private const BASE_COL:uint = 0xcc;
    private const MIN_COL:uint = 0x00;
    private var _container:Sprite;
    private var _lightList:Array;
    private var _colorTrans:ColorTransform;
    private var _blur:BlurFilter;
    private var _bitmapData:BitmapData;
    private var _bitmap:Bitmap;
    private var _rect:Rectangle;
    private var _point:Point;
    private var _changeCol:uint = MIN_COL;
    private var _dc:int = CHANGE_COL_SPEED;
    
    public function Effect() 
    {
        birth();
    }
    
    private function birth():void {
        _rect = new Rectangle( 0, 0, Main.STAGE_WIDTH, Main.STAGE_HEIGHT );
        _point = new Point( 0, 0 );            
        
        _bitmapData = new BitmapData( Main.STAGE_WIDTH, Main.STAGE_HEIGHT, true, 0x00000000);
        _bitmap = new Bitmap( _bitmapData );
        addChild(_bitmap);
        
        _lightList = new Array();
        _container = new Sprite();
        addChild( _container ); 
        _colorTrans = new ColorTransform();
        _colorTrans.color = BASE_COL << 16 | BASE_COL << 16 | BASE_COL << 16;
        _blur = new BlurFilter(18, 18, 3);
        var light:Light;
        for (var i:int = 0; i < LIGHT_MAX; i++) {
            light = new Light();
            _container.addChild(light );
            _lightList.push( light );
        }
    }
    
    public function update():void {
        _bitmapData.lock();
        for ( var i:int = 0; i < _lightList.length; i++ ) {
            var light:Light = _lightList[ i ];
            light.move();
        }

        colorChange();
        _bitmapData.draw( _container, null, _colorTrans, BlendMode.SCREEN, null, true );
        _bitmapData.applyFilter( _bitmapData, _rect, _point, _blur );
        _bitmapData.unlock();
    }
    
    private function colorChange():void {
        _changeCol += _dc;
        if ( _changeCol < MIN_COL ) {
            _changeCol = MIN_COL;
            _dc = CHANGE_COL_SPEED;
        } else if ( _changeCol > BASE_COL ) {
            _changeCol = BASE_COL;
            _dc = -CHANGE_COL_SPEED;
        }
            
        _colorTrans.color = BASE_COL << 16 | _changeCol << 8 | _changeCol;
    }
    
}

import flash.display.Graphics;
import flash.display.Sprite;
import flash.display.BlendMode;
/**
 * ...
 * @author dory
 */
class Light extends Sprite
{
    private var color:uint = 0xFFFFFF;
    private const MAX_ALPHA_SPEED:Number = 0.05;
    private const MIN_ALPHA_SPEED:Number = 0.005;
    
    private const MAX_SIZE:Number = 40;
    private const MIN_SIZE:Number = 1;

    private const MAX_SPEED:Number = 0.05;
    private const MIN_SPEED:Number = -( MAX_SPEED / 8 );
    
    private var dx:Number;
    private var dy:Number;
    private var dalpha:Number;
    private var rad:Number;
    
    public function Light() 
    {
        blendMode = BlendMode.ADD;
        birth();
    }
    
    private function birth():void {
        alpha = 1;
        rad = Math.random() * MAX_SIZE + MIN_SIZE;
        dx = Math.random() * MAX_SPEED + MIN_SPEED;
        dy = Math.random() * MAX_SPEED + MIN_SPEED;
        dalpha = Math.random() * MAX_ALPHA_SPEED + MIN_ALPHA_SPEED;
        draw();
        x = Main.STAGE_WIDTH * Math.random();
        y = Main.STAGE_HEIGHT * Math.random();
    }
    
    private function draw():void {
        graphics.beginFill( color );
        graphics.drawCircle( 0, 0, rad );
        graphics.endFill();
    }
    
    public function move():void {
        x += ( Main.instance.mouseX - x ) * dx;
        y += ( Main.instance.mouseY - y ) * dy;
        alpha -= dalpha;
        if ( alpha < 0 ) {
            graphics.clear();
            birth();
        }
    }
    
}



import flash.display.Sprite;
/**
 * ...
 * @author dory
 */
class Cheek extends Sprite
{
    private const RAD:Number = 30;
    private const CHEEK_COL:uint = 0xFF6666;
    
    public function Cheek() 
    {
        draw();
    }
    
    public function draw():void {
        graphics.beginGradientFill( "radial", [CHEEK_COL, CHEEK_COL], [1, 0], [0, 80]);
        graphics.drawCircle( 0, 0, RAD );
        graphics.endFill();
    }
    
    public function update( count:int ):void {
        var num:Number;
        
        if ( count > Main.CHEEK_MAX_COUNT )
            num = Main.CHEEK_MAX_COUNT;
        else
            num = count;
        
        alpha = num / Main.CHEEK_MAX_COUNT;
    }
    
}
