/**
 * Copyright mimshwright ( http://wonderfl.net/user/mimshwright )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hi8q
 */

// Loads image from a Flickr RSS feed using KitchenSync's loading functions.

package
{
	import flash.text.TextField;
	import flash.display.DisplayObject;
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.events.MouseEvent;
	import flash.net.URLRequest;
	
	import org.as3lib.kitchensync.KitchenSync;
	import org.as3lib.kitchensync.core.*;
	import org.as3lib.kitchensync.action.*;
	import org.as3lib.kitchensync.action.group.*;
	import org.as3lib.kitchensync.action.loading.*;
	import org.as3lib.kitchensync.action.tween.*;
	import org.as3lib.kitchensync.easing.*;
	
	[SWF(backgroundColor="#999999")]
	public class LoaderDemo extends Sprite
	{
		private const url:String = "http://api.flickr.com/services/feeds/photos_public.gne?lang=en-us&id=7981170@N04&format=rss_200";
		private var loadedXML:Array = [];
		private var imageList:Array; 
		private var loadQueue:KSLoadQueue;
		private var tf:TextField;
		public function LoaderDemo()
		{
			super();
			
			KitchenSync.initialize(this, "2.0");
			
			tf = new TextField(); 
			tf.text = "Loading xml file";
			tf.y = 450;
			tf.autoSize = "left";
			addChild(tf);
			
			var loader:KSXMLLoader = new KSXMLLoader(new URLRequest(url), loadedXML);
			var processAction:KSFunction = new KSFunction(processXML);
			
			loadQueue = new KSLoadQueue( [], KSLoader );
			loadQueue.addEventListener(KitchenSyncEvent.CHILD_ACTION_COMPLETE, onImageLoaded);
			
			var seq:KSSequenceGroup = new KSSequenceGroup (
				loader,
				processAction,
				loadQueue
			);
			seq.start();
				
		}
		
		public function processXML():void {
			tf.text = "xml load complete";
			
			var xml:XML = new XML(loadedXML[0]);
			
			var ns:Namespace = xml.namespace();
			var media:Namespace = xml.namespace("media");
			default xml namespace = ns;
			imageList = xml.channel.item.media::thumbnail.@url.toXMLString().split("\n");
			
			var i:int=0, l:int = imageList.length;
			for (;i<l;i+=1) { 
				tf.text = (i + ": " + imageList[i]);
				loadQueue.addURL(imageList[i] as String, KSLoader);
			}
		}
		
		private var i:int = 0;
		private const SPACE:int = 100;
		private const COL_WIDTH:int = 5;
		public function onImageLoaded(event:KitchenSyncEvent):void {
			var queue:KSLoadQueue= (event.target as KSLoadQueue);
			var loader:Loader = (queue.currentAction as KSLoader).loader;
			
			if (loader != null) {
				tf.text =  ("Image " + i + " loaded : " + loader.contentLoaderInfo.url);
				
				addChild(loader);
				loader.x = SPACE * (i % COL_WIDTH);
				loader.y = SPACE * Math.floor(i / COL_WIDTH);
				loader.addEventListener(MouseEvent.MOUSE_OVER, onMouseOverImage);
				loader.addEventListener(MouseEvent.MOUSE_OUT, onMouseOutImage);
				i++;
			}
		}
		
		private var tween:KSTween;
		private function onMouseOverImage(event:MouseEvent):void {
			var img:DisplayObject = event.target as DisplayObject;
			if (tween && tween.isRunning) tween.jumpToTime(tween.duration);
			tween = TweenFactory.newScaleTween(img, AUTO_TWEEN_VALUE, 1.5, "0.25s", 0, Quintic.easeOut);
			tween.start();
			swapChildrenAt(getChildIndex(img), numChildren - 1);
		}
		
		private function onMouseOutImage(event:MouseEvent):void {
			var img:DisplayObject = event.target as DisplayObject;
			if (tween && tween.isRunning) tween.jumpToTime(tween.duration);
			tween = TweenFactory.newScaleTween(img, AUTO_TWEEN_VALUE, 1, "0.1s", 0, Cubic.easeOut);
			tween.start();
		} 
	}
}