/**
 * Copyright nayu ( http://wonderfl.net/user/nayu )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hi7W
 */

// forked from alumican_net's forked from: flash on 2009-8-23
// forked from nayu's flash on 2009-8-23
/*
　質問：クラスが２つ混在する場合の書き方。
　ボールを作成するためのクラスを作成するには
　この中でどのように記述したらいいんでしょうか？
　教えてください。
 
  09.08.23 alumican_net
  ・一つのasファイル内で2つ以上のクラスを使用するには、
   package{～} の外にクラスを記述します。
   
  ・その際、package 外のクラス用の import 文は
  　package 内の import とは別に、package 外に書く必要があります。
  
  ・wonderflだと関係ないですが、package 外に書いたクラスは
   別のasファイルから使えないので注意が必要です。
  
  以下はあくまで一つの回答例ですが、ボールの生成から addChid までの処理を
  新しく作った Particle に移してみました。
*/

package 
{
    import flash.display.Sprite;
    import flash.events.Event;
    //import flash.display.MovieClip;

    public class particle44 extends Sprite 
    {
       private var particles:Array;
       private var numParticles:uint = 50;
       
        public function particle44() 
        {
            init();    
        }
        
        public function init():void
        {
            particles = new Array();
            for(var i:uint = 0; i < numParticles; i++)
            {
                /*
                
                ここの処理を Particle クラスのコンストラクタに移しています
                
                //ボールの大きさ
                var shape1:MovieClip = new MovieClip();
                shape1.graphics.beginFill(0x0000FF);
                var size:uint = Math.random() * 10 + 5;
                shape1.graphics.drawCircle(0,0,size);
                shape1.graphics.endFill();
                
                var particle:MovieClip = shape1;
                //ボールの配置する位置
                particle.x = Math.random() * stage.stageWidth;
                particle.y = Math.random() * stage.stageHeight;
                particle.vx = 0;
                particle.vy = 0; 
                //質量
                particle.mass = Math.random() * 20 + 10;
                addChild(particle);
                */
                
                particles.push( new Particle(this) );    
            }
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        public function onEnterFrame(event:Event):void
        {
            for(var i:uint = 0; i < numParticles; i++)
	    {
		var particle:Particle = particles[i];
		particle.x += particle.vx;
		particle.y += particle.vy;
	    }
	    for(i = 0; i < numParticles - 1; i++)
	    {
	        var partA:Particle = particles[i];
	        for(var j:uint = i + 1; j < numParticles; j++)
	        {
	            var partB:Particle = particles[j];
	            gravitate(partA, partB);
                }
            }
        }
	
        //
        public function gravitate(partA:Particle, partB:Particle):void
	{
            //2点間のXの差とyの差を求める
	    var dx:Number = partB.x - partA.x;
	    var dy:Number = partB.y - partA.y;
            //2点間の距離を求める（ピタゴラスの定理）
	    var distSQ:Number = dx * dx + dy * dy;
	    var dist:Number = Math.sqrt(distSQ);
            //物体に及ぼす引力
	    var force:Number = partA.mass * partB.mass / distSQ;
            //加速度を求める
	    var ax:Number =  force * dx / dist;
	    var ay:Number =  force * dy / dist;
	    partA.vx += ax / partA.mass;
	    partA.vy += ay / partA.mass;
	    partB.vx -= ax / partB.mass;
	    partB.vy -= ay / partB.mass;
        }
    }
}

//packageの外に定義したクラスのためのimport
import flash.display.DisplayObjectContainer;
import flash.display.Sprite;

//packageの外に定義したクラス
class Particle extends Sprite
{
    public var mass:Number;
    public var vx:Number;
    public var vy:Number;
    
    public function Particle(base:DisplayObjectContainer):void
    {
        //ボールの大きさ
        var size:uint = Math.random() * 10 + 5;
        graphics.beginFill(0x0000FF);
        graphics.drawCircle(0,0,size);
        graphics.endFill();
        
        //ボールの配置する位置
        x  = Math.random() * base.stage.stageWidth;
        y  = Math.random() * base.stage.stageHeight;
        vx = 0;
        vy = 0;
        
        //質量
        mass = Math.random() * 20 + 10;
        
        //表示リストへ追加
        base.addChild(this);
    }
}