/**
 * Copyright termat ( http://wonderfl.net/user/termat )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hhLX
 */

package
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Point;
	import flash.geom.PerspectiveProjection;
	import flash.display.BitmapData;
    import flash.display.Bitmap;
	import flash.filters.BlurFilter;
	import flash.geom.ColorTransform;

	[SWF(width=480,height=480,backgroundColor=0x000000,frameRate=30)]
	public class Practice24 extends Sprite {
		private var view:PerspectiveProjection;
		private var lines:Vector.<Line>;
		private var iter:int = 0;
        private var bmpdata:BitmapData;
		private var bmp:Bitmap;
        private var colortrans:ColorTransform;
        private var filter:BlurFilter;
		
		public function Practice24() {
            bmpdata = new BitmapData( stage.stageWidth, stage.stageWidth, false, 0x000000);
			bmp = new Bitmap(bmpdata);
            addChild(bmp);
            colortrans = new ColorTransform( 0.95, 0.99, 0.99 );
            filter = new BlurFilter(4, 4, 4);			
			view = this.transform.perspectiveProjection;
			view.fieldOfView = 175;
			lines = new Vector.<Line>();
			addEventListener(Event.ENTER_FRAME, update);
		}
		
		private function addLine():void {
			iter = (iter + 1) % 36;
			var l:Line = new Line(getColor(iter*10));
			lines.push(l);
			addChild(l);
		}
		
		private function update(e:Event):void {
			view.projectionCenter = new Point(mouseX,mouseY);
			var n:int = lines.length;
			for (var i:int = 0; i < n; i++) {
				var l:Line = lines.shift();
				l.z -= 10;
				if (l.z < 0) {
					removeChild(l);
				}else {
					lines.push(l);
				}
			}
			if (Math.random() < 0.4)addLine();
			bmpdata.lock();
			bmpdata.applyFilter( bmpdata, bmpdata.rect, bmpdata.rect.topLeft, filter );
			bmpdata.colorTransform( bmpdata.rect, colortrans );
			bmpdata.draw(this);
			bmpdata.unlock();
		}
		
		private function getColor(i:int):uint {
			var h:Number = i / 60;
			var ii:Number = Math.floor(h);
			var ff:Number = h - ii;
			var p1:Number = 0.0;
			var p2:Number = 1.0 - ff;
			var p3:Number = 1.0 - (1.0 - ff);
			var rv:Number;
			var gv:Number;
			var bv:Number;
			switch(ii) {
				case 0:
					rv = 1.0;	gv = p3;	bv = p1;
					break;
				case 1:
					rv = p2;	gv = 1.0;	bv = p1;
					break;
				case 2:
					rv = p1;	gv = 1.0;	bv = p3;
					break;
				case 3:
					rv = p1;	gv = p2;	bv = 1.0;
					break;
				case 4:
					rv = p3;	gv = p1;	bv = 1.0;
					break;
				default:
					rv = 1.0;	gv = p1;	bv = p2;
			}
			var rr:int = Math.max(0, Math.min(255, rv * 255));
			var gg:int = Math.max(0, Math.min(255, gv * 255));
			var bb:int = Math.max(0, Math.min(255, bv * 255));
			var color:uint = (rr << 16) + (gg << 8) + bb;
			return color;
		}
	}
}
import flash.display.MovieClip;
import flash.display.Sprite;
import flash.geom.Matrix;
import flash.geom.Point;
class Line extends Sprite {
	public function Line(color:uint):void {
		this.x = 240; this.y = 240;
		this.z = 300;
		this.alpha = 0.5;
		graphics.beginFill(color);
		graphics.drawCircle(0, 0, 300);
		graphics.endFill();
	}
}