/**
 * Copyright OKASUKE ( http://wonderfl.net/user/OKASUKE )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hgy4
 */

/*@OKASUKE
*2010/02/26
*　Alternativa3D discipline(Alternativa3Dの鍛錬)
*　たまに小Boxがくっつきます。。。そのうち分裂・・・
* 小Box数を多くするとＰｌａｎｅにちかちか線がはしる。。。なして？

* narutohyperさんにより解決↓ ありがとうございます！極めるとはこういうことだっ！
* http://wonderfl.net/code/3fc75f72cc19de739cdf8ec2ba03a45a3166d893
* ↑こっち見てっ！＞＜  
*/

package {
    
	import alternativ5.engine3d.materials.FillMaterial;
	import alternativ5.engine3d.primitives.Box;
	import alternativ5.engine3d.events.MouseEvent3D
	import alternativ5.types.Point3D;
	import alternativ5.engine3d.primitives.Plane;
	import alternativ5.engine3d.materials.WireMaterial;
	import alternativ5.engine3d.core.Object3D;
	
	import flash.display.Sprite;
	import flash.display.BlendMode;	
	import flash.display.DisplayObject;
	import net.hires.debug.Stats;
	
        [SWF(width = 465, height = 465, frameRate = 60, backgroundColor=0x00000000)]	
	public class Main extends Sprite {

		public static const COUNTBOX:Number = 15;　//小Ｂｏｘ数
		private var _materialList:Vector.<FillMaterial> = new Vector.<FillMaterial>;
		private var _boxList:Vector.<Ball> = new Vector.<Ball>;
	
		public function Main():void {
			
                        stage.addChild(new Stats());
			
                        var template:BasicTemplate = new BasicTemplate();
			addChild(template);				
			
			var top:Plane = new Plane(500, 500, 10, 10, true);
			top.cloneMaterialToAllSurfaces(new WireMaterial(1, 0xFF00FFFF, 1, BlendMode.HARDLIGHT));
            top.z = 250;
			
			var bottom:Plane = new Plane(500, 500, 10, 10, true);
			bottom.cloneMaterialToAllSurfaces(new WireMaterial(1, 0xFF00FFFF, 1, BlendMode.HARDLIGHT));
			bottom.z = -250;
			
			var left:Plane = new Plane(500, 500, 10, 10, true);
			left.cloneMaterialToAllSurfaces(new WireMaterial(1, 0xFF00FFFF, 1, BlendMode.HARDLIGHT));
			left.x = -250;		
			left.rotationY = 90 * Math.PI / 180;
			
			var right:Plane = new Plane(500, 500, 10, 10, true);
			right.cloneMaterialToAllSurfaces(new WireMaterial(1, 0xFF00FFFF, 1, BlendMode.HARDLIGHT));
			right.x = 250;
			right.rotationY = -90 * Math.PI / 180;
		

			var front:Plane = new Plane(500, 500, 10, 10, true);
			front.cloneMaterialToAllSurfaces(new WireMaterial(1, 0xFF00FF00, 1, BlendMode.HARDLIGHT));
			front.y = -250;
			front.rotationX = 90 * Math.PI / 180;
						
			var back:Plane = new Plane(500, 500, 10, 10, true);
			back.cloneMaterialToAllSurfaces(new WireMaterial(1, 0xFF00FF00, 1, BlendMode.HARDLIGHT));
			back.y = 250;
			back.rotationX = -90 * Math.PI / 180;
			    
			template.scene.root.addChild(top);			
			template.scene.root.addChild(right);
			template.scene.root.addChild(left);
			template.scene.root.addChild(bottom);
			template.scene.root.addChild(front);
			template.scene.root.addChild(back);
			
			for (var i:uint = 0; i <= COUNTBOX; i++) {
				_materialList[i] = new FillMaterial(Math.random() * 0xFFFFFF, 1, BlendMode.HARDLIGHT, -1, 0x000000);
				_boxList[i] = new Ball(template.scene, 30, 30, 30, _materialList[i]); 
				//_boxList[i].cloneMaterialToAllSurfaces(_materialList[i]);
				template.scene.root.addChild(_boxList[i]);		
			}
			
			/*var po:Vector.<int> = new Vector.<int>
			for (var j:uint = 0; j <= _boxList.length-1; j++) {
				_boxList[j].x = Math.random() * 460 - 230;
				_boxList[j].y = Math.random() * 460 - 230;
				_boxList[j].z = Math.random() * 460 - 230;				
				template.scene.root.addChild(_boxList[j]);
			
				po[j] = (Math.floor(Math.random() * 10) - 5); 
				trace(po[j]);				
			}*/
			
			template.onPreRender = function():void {			
										
				var rateZ:Number = (mouseY - stage.stageHeight/2)/2;
				var rateX:Number = (mouseX - stage.stageWidth/ 2)/ 2;					
									
				for (var i:int = 0; i <= _boxList.length - 1; i++) {
					//_boxList[i].rotationX += po[i]*0.1;
					//_boxList[i].rotationY += po[i]*0.1;
					//_boxList[i].rotationZ += po[i]*0.1;
					
					_boxList[i].doAction();
					//_boxList[i].x += po[i];
					//_boxList[i].y += po[i];
					//_boxList[i].x += po[i];						
				}			
					
				trace(template.camera.y)
				if (template.camera.y  >= 640) {					
						template.camera.z  += ( rateZ - template.camera.z) * 0.02;
						template.camera.y  += ( rateX - template.camera.x) * 0.02;							
				} else {
					if (template.camera.y <= -640 ) {
						template.camera.z  += ( rateZ - template.camera.z) * 0.01;
						template.camera.y  += ( rateX - template.camera.x) * 0.01;
					} else {
						template.camera.z  += ( rateZ - template.camera.z) * 0.1;
						template.camera.y  += ( rateX - template.camera.x) * 0.1;
					}
					
				}				
				template.cameraContoller.lookAt(new Point3D());
			}		
		}
	}
}


import alternativ5.engine3d.core.Surface;
import alternativ5.engine3d.primitives.Box;
import alternativ5.types.Set;
import alternativ5.engine3d.physics.Collision;
import alternativ5.engine3d.physics.EllipsoidCollider;
import alternativ5.types.Point3D;
import alternativ5.engine3d.materials.TextureMaterial;
//import alternativ5.engine3d.materials.SpriteTextureMaterial;
import alternativ5.engine3d.materials.SurfaceMaterial;
import alternativ5.engine3d.materials.FillMaterial;
import alternativ5.types.Texture;

import flash.display.Sprite;
import flash.filters.BlurFilter;
import flash.display.GradientType;
import flash.geom.Matrix;
import flash.display.Bitmap;
import flash.display.BitmapData;

//Ballクラスはnarutohyperさんのを参考
//ここらへんかな、
//http://marubayashi.net/tips/alternativa3d/step2/a2-3/index.html
class Ball extends Box {

	private var collider:EllipsoidCollider;

	private var collision:Collision;

	private var nowPoint:Point3D;			//現在の位置
	private var newPoint:Point3D;			//移動位置
	private var speed:Point3D;				//スピード
	private var deceleration:Number;		//跳ね
	private var acceleration:Point3D;		//加速

	private var tempPoint:Point3D;
	private var _firstmaterial:FillMaterial;
	
	public function Ball(scene:Scene3D,w:Number,h:Number,l:Number, mate:FillMaterial) {
		super(w,h,l);

		tempPoint= new Point3D();
		nowPoint = new Point3D();
		newPoint = new Point3D();
		speed=new Point3D();					//スピード
		deceleration=0.6;						//減速
		acceleration=new Point3D(0.4,0.6,0.5);	//加速
		
		collider = new EllipsoidCollider (scene,w,h,l);
		collision = new Collision();
		collider.collisionSet = new Set()
		
		collider.collisionSet.add(this);
		nowPoint = new Point3D (Math.random() * 460 - 230,Math.random() * 460 - 230,Math.random() * 460 - 230);
		this.coords = nowPoint;	
		_firstmaterial = mate;
		changeMaterial();
	}
		
	public function doAction():void {
		speed.add(acceleration);
		
		if (collider.getCollision (nowPoint, speed, collision)) {			
			tempPoint.copy(collision.normal);
			acceleration.x *= -1;
			acceleration.y *= -1;
			acceleration.z *= -1;			
			tempPoint.multiply(2*Point3D.dot(tempPoint, speed));
			speed.subtract(tempPoint);
			speed.multiply(deceleration);
			//Allに変更
			//this.setMaterialToSurface(_textureMaterialArray[0], "back");
			this.cloneMaterialToAllSurfaces(_textureMaterialArray[0]);
		}else {			
			collider.calculateDestination(nowPoint, speed , newPoint);
			this.cloneMaterialToAllSurfaces(_firstmaterial);
		}		
		nowPoint.copy(newPoint);
		this.coords = nowPoint;
		this.rotationX += 5;
		this.rotationY += 5;
		this.rotationZ += 5;
	}
	
	private var _textureMaterialArray:Array = [];	
	private function changeMaterial():void {
		
		var canvas:Sprite = new Sprite();		
		var colors:Array=new Array(0xFFB6C1,0x00FFFF)
		var alphas:Array=new Array(0.7,0.6)
		var ratios:Array=new Array(0,255)
		var matrix:Matrix=new Matrix()
		matrix.createGradientBox(10,10,45*Math.PI/180,0,0)
		canvas.graphics.beginGradientFill(GradientType.RADIAL,colors, alphas, ratios, matrix)
		canvas.graphics.drawRect(0,0,10,10)

		var bmp:BitmapData=new BitmapData(10,10);
		bmp.draw(canvas);

		_textureMaterialArray.push(new TextureMaterial(new Texture(bmp), 1, true, true));		
	}	
}


import alternativ5.engine3d.controllers.CameraController;
import alternativ5.engine3d.core.Camera3D;
import alternativ5.engine3d.core.Object3D;
import alternativ5.engine3d.core.Scene3D;
import alternativ5.engine3d.display.View;
import flash.display.Sprite;
import flash.display.StageAlign;
import flash.display.StageQuality;
import flash.display.StageScaleMode;
import flash.events.Event;

/**
 * BasicTemplate for Alternativa3D
 * Alternativa3Dを扱いやすくするためのテンプレートです
 * @author Yasu
 */
class BasicTemplate extends Sprite{
	/**
	 * シーンインスタンスです。
	 */
	public var scene:Scene3D;
	/**
	 * ビューインスタンスです。
	 */
	public var view:View;
	/**
	 * カメラインスタンスです。
	 */
	public var camera:Camera3D;
	/**
	 * カメラコントローラーです。
	 */
	public var cameraContoller:CameraController;
	
	private var _viewWidth:int;
	private var _viewHeight:int;
	private var _scaleToStage:Boolean;

	/**
	 * 新しい BasicTemplate インスタンスを作成します。
	 * @param	viewWidth
	 * @param	viewHeight
	 * @param	scaleToStage
	 */
	public function BasicTemplate(viewWidth:int=640, viewHeight:int=480, scaleToStage:Boolean = true) {
		_viewWidth = viewWidth;
		_viewHeight = viewHeight;
		_scaleToStage = scaleToStage;
		
		// Creating scene
		scene = new Scene3D();
		scene.splitAnalysis = false; // not analysis for performance
		scene.root = new Object3D();
		
		// Adding camera
		camera = new Camera3D();
		camera.y = -500;
		scene.root.addChild(camera);
		
		// camera contoller
		cameraContoller = new CameraController(this);
		cameraContoller.camera = camera;
		
		// set view
		view = new View();
		view.camera = camera;
		addChild(view);
		
		// stage
		if (stage) init();
		else addEventListener(Event.ADDED_TO_STAGE, init);
	}
	
	/**
	 * 初期化されたときに実行されるイベントです。
	 * 初期化時に実行したい処理をオーバーライドして記述します。
	 */
	protected function atInit():void {}
	
	/**
	 * 初期化されたときに実行されるイベントです。
	 * 初期化時に実行したい処理を記述します。
	 */
	private var _onInit:Function = function():void { };
	public function get onInit():Function { return _onInit; }
	public function set onInit(value:Function):void {
		_onInit = value;
	}
	
	/**
	 * Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
	 * レンダリング前に実行したい処理をオーバーライドして記述します。
	 */
	protected function atPreRender():void {}
	
	/**
	 * Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
	 * レンダリング前に実行したい処理を記述します。
	 */
	private var _onPreRender:Function = function():void{};
	public function get onPreRender():Function { return _onPreRender; }
	public function set onPreRender(value:Function):void {
		_onPreRender = value;
	}
	
	/**
	 * Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
	 * レンダリング後に実行したい処理をオーバーライドして記述します。
	 */
	protected function atPostRender():void {
	}
	
	/**
	 * Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
	 * レンダリング後に実行したい処理を記述します。
	 */
	protected var _onPostRender:Function = function():void{};
	public function get onPostRender():Function { return _onPostRender; }
	public function set onPostRender(value:Function):void {
		_onPostRender = value;
	}
	
	/**
	 * レンダリングを開始します。
	 */
	public function startRendering():void {
		addEventListener(Event.ENTER_FRAME, onRenderTick);
	}
	/**
	 * レンダリングを停止します。
	 */
	public function stopRendering():void {
		removeEventListener(Event.ENTER_FRAME, onRenderTick);
	}
	
	/**
	 * シングルレンダリング(レンダリングを一回だけ)を実行します。
	 */
	public function singleRender():void {
		onRenderTick();
	}
	
	/**
	 * @private
	 */
	private function init(e:Event = null):void {
		stage.scaleMode = StageScaleMode.NO_SCALE;
		stage.align = StageAlign.TOP_LEFT;
		stage.quality = StageQuality.HIGH;

		// resize
		stage.addEventListener(Event.RESIZE, onResize);
		onResize(null);
		
		// render
		startRendering();
		
		atInit();
		_onInit();
		
	}
	
	/**
	 * @private
	 */
	private function onRenderTick(e:Event = null):void {
		atPostRender();
		_onPostRender();
		scene.calculate();
		atPreRender();
		_onPreRender();
	}
	
	/**
	 * @private
	 */
	private function onResize(event:Event = null):void {
		if (_scaleToStage) {
			view.width = stage.stageWidth;
			view.height = stage.stageHeight;
		}else {
			view.width = _viewWidth;
			view.height = _viewHeight;
		}
	}
}
