/**
 * Copyright Glidias ( http://wonderfl.net/user/Glidias )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hgPs
 */

package {

import flash.display.Sprite;
    import flash.events.Event;
    import idv.cjcat.stardust.common.actions.*;
    import idv.cjcat.stardust.common.clocks.*;
    import idv.cjcat.stardust.common.initializers.*;
    import idv.cjcat.stardust.common.math.*;
    import idv.cjcat.stardust.twoD.actions.*;
    import idv.cjcat.stardust.twoD.emitters.*;
    import idv.cjcat.stardust.twoD.initializers.*;
    import idv.cjcat.stardust.twoD.renderers.*;
    import idv.cjcat.stardust.twoD.zones.*;
     import idv.cjcat.stardust.twoD.handlers.*;
     
    public class StardustLeavesFall extends Sprite {
        
        private var emitter:Emitter2D;
        
        public function StardustLeavesFall() {
           emitter =new Emitter2D(new SteadyClock(.1));
        
            var sprite:Sprite = new Sprite();
            addChild(sprite);
            var handler:DisplayObjectHandler;
            handler = new DisplayObjectHandler(sprite);
               var renderer:DisplayObjectRenderer = new DisplayObjectRenderer(sprite);
                renderer.addEmitter(emitter);
            var displayObjectClass:DisplayObjectClass=new DisplayObjectClass( Leaf );
            var position:Position=new Position(new Line(0,0,500,0));
            var velocity:Velocity=new Velocity(new SinglePoint(0,2));
            emitter.addInitializer(displayObjectClass);
            emitter.addInitializer(position);
           emitter.addInitializer(velocity);
            var move:Move = new Move();
            var deathZone:DeathZone=new DeathZone(new RectZone(0,0,500,400),true);
           emitter.addAction(move);
            emitter.addAction(deathZone);
            var drift:RandomDrift = new RandomDrift();
            drift.randomX=new UniformRandom(16,32);
            var oriented:Oriented = new Oriented();
            oriented.offset=180;
            emitter.addAction(drift);
            emitter.addAction(oriented);
           
            emitter.particleHandler  = handler;
            addEventListener(Event.ENTER_FRAME, step);
           
        Leaf.loadedBitmap = new LoadedBitmap();
     Leaf.loadedBitmap.load();
        }
        
        public function step(e:Event):void {
            emitter.step();
            
        }


    }
}


import flash.net.*;
import flash.display.*;
import flash.events.Event;
import flash.system.LoaderContext;

class LoadedBitmap extends Bitmap {
    
    public function LoadedBitmap() {
        super();
        
    }
    
    public function load():void {
        var loader:Loader = new Loader();
        loader.contentLoaderInfo.addEventListener(Event.COMPLETE, onLoadComplete);
        loader.load( new URLRequest( "http://glidias.freehostia.com/autumnleaf_small.png"), new LoaderContext(true)  );
    }
    
    public function onLoadComplete(e:Event):void {
        bitmapData = Bitmap(e.target.content).bitmapData;
        dispatchEvent(e);
    }

}



class Leaf extends Sprite {
    
    public static var loadedBitmap:LoadedBitmap;
    
    public function Leaf() {
        if (loadedBitmap.bitmapData == null) {
           loadedBitmap.addEventListener(Event.COMPLETE, onLoaded);
            graphics.beginFill(0x00FF22);
             graphics.drawRect(-8,-8,16,16);
         
        }
        else  {
            var bmp:Bitmap = new Bitmap(loadedBitmap.bitmapData);
            bmp.smoothing = true;
            bmp.scaleX = bmp.scaleY = .25;
            bmp.x = -bmp.width * .5;
            bmp.y = -bmp.height * .5;
            
             addChild( bmp );
        }

      
        
    }
    
    private function onLoaded(e:Event):void {
        loadedBitmap.removeEventListener(Event.COMPLETE, onLoaded);
        graphics.clear();
       
    }

}


