/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hf2y
 */

// forked from lizhi's SphericalEnvironmentMapping
package  
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Point;
    import flash.geom.Vector3D;
    import sliz.miniui.Checkbox;
    /**
     * ...
     * u=Nx/2+0.5 
     * v=Ny/2+0.5
     * @author lizhi
     */
    public class SphericalEnvironmentMappingTest extends Sprite
    {
        private var bmd:BitmapData;
        private var spherical3D:BitmapData;
        private var r:Number;
        private var light:Vector3D;
        private var offsets:Array = [new Point, new Point];
        private var offset:Point = new Point(int.MAX_VALUE/2,int.MAX_VALUE/2);
        private var view:Bitmap;
        private var map:Array=[];
        private var isPerLin:Checkbox;
        
        public function SphericalEnvironmentMappingTest() 
        {
            bmd = new BitmapData(100, 100, false);
            addChild(new Bitmap(bmd));
            spherical3D = new BitmapData(200, 200, false);
            view = new Bitmap(spherical3D);
            view.x = 465 / 2 - view.width / 2;
            view.y = 465 / 2-view.height/2-50;
            addChild(view);
            r = spherical3D.width / 2;
            light = new Vector3D(0, 0, 10);
            addEventListener(Event.ENTER_FRAME, update);
            
            for (var y:int = 0; y < spherical3D.height; y++ ) {
                var r1:Number = Math.sqrt(r * r - (r - y) * (r - y));
                for (var x:int = 0; x < spherical3D.width; x++ ) {
                    if (map[x] == null) map[x] = [];
                    var v:V = new V;
                    v.p = getSpherizePoint(new Point(x, y), r, r, new Point(r, r));
                    var z:Number = -Math.sqrt(r1 * r1 - (r - x) * (r - x));
                    v.z = z;
                    var n:Vector3D = new Vector3D(x - r, y - r, z);
                    n.normalize();
                    v.n = n;
                    map[x][y] = v;
                }
            }
            isPerLin = new Checkbox("   BMP = checked  |  Perlin = unchecked", 120, 0, this);
        }
        
        private function update(e:Event):void 
        {
            light.x = -mouseX+view.x;
            light.y = -mouseY+view.y;
            light.z = 100;
            
            bmd.lock();
            spherical3D.lock();
            if(!isPerLin.getToggle())
            {
                offsets[0].x += light.x/30;
                offsets[1].y += light.y/30;
                bmd.perlinNoise(100, 100, 2, 4, true, true, 7, true, offsets);
                
            }
            else
            {
             
                offset.x += light.x/100;
                offset.y += light.y/100;
                for (var y:int = 0; y < bmd.height; y++ ) {
                    for (var x:int = 0; x < bmd.width;x++ ) {
                        bmd.setPixel(x, y, (x+offset.x) % 10 > 5 || (y+offset.y) % 10 > 5?0xffffff:0xffffff);
                    }
                }
            }
            for (y = 0; y < spherical3D.height; y++ ) {
                for (x = 0; x < spherical3D.width;x++ ) {
                    //var u:Number = Math.acos((r - x) / r) / Math.PI;
                    //var v:Number = Math.acos((r - y) / r) / Math.PI;
                    //var u:Number = n.x / 2 + 0.5;
                    //var v:Number = n.y / 2 + 0.5;
                    var v:V = map[x][y];
                    if (isNaN(v.z)) continue;
                    //var c:Number = bmd.getPixel(bmd.width * u, bmd.height * v);
                    var c:Number = bmd.getPixel(v.p.x, v.p.y);
                    var a:Number = Vector3D.angleBetween(v.n, light) / Math.PI;
                    spherical3D.setPixel(x, y,  (((c << 8 >>> 24) * a) << 16) | (((c << 16 >>> 24) * a) << 8) | ((c << 24 >>> 24) * a));
                }
            }
            bmd.unlock();
            spherical3D.unlock();
        }
        public function getSpherizePoint(point:Point, r:Number, h:Number, cp:Point):Point {
            var R:Number = (r * r + h * h) / (2 * h);
            var l:Number = Point.distance(point, cp);
            var p:Point = Point.interpolate(Point.interpolate(point, cp, r / l), cp, Math.asin(l / R) / Math.acos((R - h) / R));
            p.normalize(p.length*bmd.width/spherical3D.width);
            return p;
        }
    }
}

class V {
    public var p:flash.geom.Point;
    public var z:Number;
    public var n:flash.geom.Vector3D;
}