/**
 * Copyright rettuce ( http://wonderfl.net/user/rettuce )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hese
 */

// forked from soundkitchen's sample 5
package
{
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.events.Event;
    import flash.filters.DropShadowFilter;
    import caurina.transitions.Tweener;
    import caurina.transitions.properties.FilterShortcuts;

    [SWF(width=465, height=465, frameRate=30, backgroundColor=0xFFFFFF)]

    public class Sample extends Sprite
    {
        public static const STD_POINT:Number = 150;
        public static const STD_DISTANCE:Number = 32;
        public static const STD_BLUR:Number = 32;

        private var light:Sprite;
        private var ball:Sprite;
        private var nowDeg:Number;

        public function Sample():void
        {
            //  FilterShortcuts を有効化
            FilterShortcuts.init();

            //  light を作成
            light = new Sprite();
            light.x = stage.stageWidth / 2;
            light.y = stage.stageHeight / 2;

            light.graphics.beginFill(0xFF0000);
            light.graphics.drawCircle(0, 0, 20);
            light.graphics.endFill();

            addChild(light);

            //  ball を作成
            ball = new Sprite();
            ball.x = light.x;
            ball.y = light.y;
            ball.filters = [new DropShadowFilter(0, 0, 0, .5, 0, 0)];
            nowDeg =  Math.atan2(ball.y - stage.stageHeight/2,ball.x - stage.stageWidth/2) / Math.PI * 180;

            ball.graphics.beginFill(0);
            ball.graphics.drawCircle(0, 0, 20);
            ball.graphics.endFill();

            addChild(ball);

            //  stage のクリックイベントにリスナーを登録
            stage.addEventListener(MouseEvent.CLICK, clickHandler);
        }

        private function clickHandler(evt:MouseEvent):void
        {
            var dx:Number = mouseX - light.x;
            var dy:Number = mouseY - light.y;
            var dp:Number = Math.sqrt(dx * dx + dy * dy) / STD_POINT;
            var degrees:Number = Math.atan2(dy, dx) / Math.PI * 180;
			var deg:Number = degrees - nowDeg;
			
			if ( deg > 180 || deg < -180 )
			{
				if (deg < -180) { deg = 360 + deg; }
				else if (deg > 180) { deg = -(360 - deg); }
			}

            Tweener.addTween(ball, {
                x: mouseX,
                y: mouseY,
                _DropShadow_angle:  nowDeg + deg,
                _DropShadow_distance: dp * STD_DISTANCE,
                _DropShadow_blurX: dp * STD_BLUR,
                _DropShadow_blurY: dp * STD_BLUR,
                time: 1,
                transition: "easeInOutCubic"
            });
			nowDeg = nowDeg + deg;
			if (nowDeg > 360) nowDeg -= 360;
			else if (nowDeg < -360) nowDeg += 360;           
        }
    }
}
