/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/heo1
 */





package 
{
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BlendMode;
    import flash.display.PixelSnapping;
    import flash.display.BitmapDataChannel;
    import flash.filters.BlurFilter;
    import flash.filters.BitmapFilterQuality;
    import flash.geom.Matrix;
    import flash.geom.Rectangle;
    import flash.geom.ColorTransform;
    import flash.geom.Point;
    import flash.events.Event;
    import frocessing.color.ColorHSV;
    import net.hires.debug.Stats;
 
    //[SWF(width = "1000",height = "618",frameRate="90",backgroundColor = "0x00")]
    [SWF(frameRate="90",backgroundColor = "0x00")]
    public class LERF extends Sprite
    {
        public static const W:Number        = 1000/2;  //465;
        public static const H:Number        = 618/2  //;
        public static const RECT:Rectangle  = new Rectangle(0,0,W,H);
        public  var stats:Stats = new Stats(); 
        private       const RADIUS:int      = 180;//160;
        private var particles:Vector.<Particle > ;
        private var canvas:BitmapData;
        private var glowBmd:BitmapData;
        private var perlin:BitmapData;
        private var randomSeed:Number = Math.random() * uint.MAX_VALUE;
        private var offsets:Array=[new Point(),new Point(),new Point()];
        private var num:int = 618;//1000;//4000;
        private var color:ColorHSV = new ColorHSV( 0,0,0.618 );//new ColorHSV(0,0,0.5);


        public function LERF()
        {
            stats.y = 618/2;
            addChild( stats );
            canvas = new BitmapData(W,H,false,0x00);
            var bm:Bitmap = addChild(new Bitmap(canvas)) as Bitmap;

            glowBmd=new BitmapData(W/4,H/4,true,0x00);
            var g_bm:Bitmap = addChild(new Bitmap(glowBmd,"never",true)) as Bitmap;
            g_bm.scaleX = g_bm.scaleY = 4.0;
            g_bm.blendMode = BlendMode.OVERLAY;

            perlin = new BitmapData(W,H,true,0x00);
            
            particles=new Vector.<Particle> ();
            var i:int;
            var theta:Number;
            var r:Number;


            for (i=0; i<num; i++)
            {
                var p:Particle=new Particle ();
                theta = Math.random() * Math.PI * 2;
                r = Math.sqrt(Math.random()) * RADIUS;

                p.x = Math.cos(theta) * r + W / 2;
                p.y = Math.sin(theta) * r + H / 2;

                particles.push(p);

            }

            stage.addEventListener(Event.ENTER_FRAME ,update);

        }
        private function update(e:Event):void
        {
            layerMove();
            perlin.perlinNoise(W/4,H/4,3,randomSeed,false,true,BitmapDataChannel.RED | BitmapDataChannel.GREEN ,false,offsets);
            

            canvas.lock();
            canvas.applyFilter(canvas,RECT,new Point(),new BlurFilter( 3,3,3 ) );//BitmapFilterQuality.MEDIUM ));

            var n:int = particles.length;

            while (n--)
            {
                var p:Particle = particles[n];
                var col:uint = perlin.getPixel(p.x,p.y);
                var r:Number = col >> 16 & 0xff;
                var g:Number = col >> 8 & 0xff;

                var ax:Number = (r - 125) * 0.5;
                var ay:Number = (g - 125) * 0.5;


                p.vx +=  ax / W;
                p.vy +=  ay / H;

                color.h -=  0.1;
                p.col = color.h;

                p.x +=  p.vx;
                p.y +=  p.vy;
                p.vx *=  0.99;
                p.vy *=  0.99;
                ax *=  0.98;
                ay *=  0.98;
                canvas.setPixel(p.x,p.y,p.col);

                var posX:Number = p.x;
                var posY:Number = p.y;

                (posX<0)?p.x=W:
                (posX>W)?p.x=0:0;
                (posY<0)?p.y=H:
                (posY>H)?p.y=0:0;

            }
            canvas.unlock();
            glowBmd.draw(canvas,new Matrix(0.25,0,0,0.25),new ColorTransform(1,1,1,.98,-1,-1,-1));

        }
        private function layerMove():void
        {

            offsets[2].y=(offsets[0].y+=2);
            offsets[1].x=(offsets[2].x-=2);

        }

    }
}





//import flash.geom.*
class Particle 
{
    public var  x    :Number
    public var  y    :Number
    public var vx    :Number
    public var vy    :Number
    public var col   :uint


    public function Particle()
    {
        vx = vy = 0
    }

}








/*
 * Copyright tensyokuzoku ( http://wonderfl.net/user/tensyokuzoku )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/leRF
 */
