/**
 * Copyright ShutheSL ( http://wonderfl.net/user/ShutheSL )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hecs
 */

// forked from uwi's forked from: flash on 2009-10-5
// forked from yd_niku's flash on 2009-10-5
// なんとなく
package {
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    
    [SWF(backgroundColor=0x00,frameRate=60)]
    public class FlashTest extends Sprite {
        private function init( e:Event = null ):void {
            setupSnow();
            //testPaletteMap();
        }
        
        private function testPaletteMap():void {
            var colors:Array = Palette.getColors();
            var palette:Sprite = addChild( new ColorMap( colors ) ) as Sprite;
            palette.x = (stage.stageWidth - palette.width)/2 >>0;
            palette.y = (stage.stageHeight - palette.height)/2 >>0;    
        }
        
        private var _snow:Vector.<Snow> = new Vector.<Snow>();
        private const SLOW_LENGTH:int = 3000;
        private function setupSnow():void {
            const w:int = stage.stageWidth;
            const h:int = stage.stageHeight;
            
            const RADIAN:Number = Math.PI*2;
            const CENTER:Point = new Point( w/2>>0, h/2>>0 );
            const COLORS:Array = Palette.getColors();
            
            var snow:Snow;
            var speed:Number, angle:Number;
            for( var i :int = 0; i<SLOW_LENGTH; ++i ) {
                snow = new Snow;
                snow.y = Math.random()*h;
                snow.x = CENTER.x + (Math.random()-0.5)*(30 + snow.y / 2);
                snow.vx = Math.random()*2-1;
                snow.vy = Math.random()-1;
                snow.color = COLORS[COLORS.length*Math.random()>>0];
                _snow.push( snow );
            }
            
            _canvas = new BitmapData( w, h, true, 0 );
            var cbm :Bitmap = addChild( new Bitmap( _canvas ) ) as Bitmap;
            cbm.smoothing = true;
            
            _twincles = new BitmapData( w/4>>0, h/4>>0, true, 0 );
            _matrix = new Matrix(0.25, 0, 0, 0.25);
            var tbm:Bitmap = addChild( new Bitmap( _twincles ) ) as Bitmap;
            tbm.scaleX = tbm.scaleY = 4;
            tbm.smoothing = true;
            tbm.blendMode = BlendMode.ADD;
            
            addEventListener( Event.ENTER_FRAME, updateSnow );
        }
        private var _matrix:Matrix;
        private var _twincles:BitmapData;
        private var _canvas:BitmapData;
        private var _ctf:ColorTransform = new ColorTransform( 0.98, 0.98, 0.98, 0.99 );
        
        private function updateSnow(e:Event):void {
            const w:int = stage.stageWidth;
            const h:int = stage.stageHeight;
            const CENTER:Point = new Point( w/2>>0, h/2>>0 );
            _canvas.lock();
            for each( var snow:Snow in _snow ) {
                if(snow.color != 0xf0f0f0){
                    snow.vx += Math.random()*0.1-0.05;
                    snow.vy += 0.015;
                    snow.vx *= 0.99;
                    snow.vy *= 0.99;
                }else{
                    snow.x += Math.random()*0.3-0.15;
                }
                
                snow.x += snow.vx;
                snow.y += snow.vy;
                _canvas.setPixel32( snow.x, snow.y, snow.color | 0xFF<<24 );
                
                if( snow.x > w +50 || snow.x <-50|| snow.y > h + 50||  snow.y <-50 ) {
                    if(snow.color == 0xf0f0f0){
                        snow.y = Math.random() * h;
                        snow.x = Math.random() * 465;
                        snow.vx = 0;
                        snow.vy = Math.random() * 0.1 + 0.1;
                    }else{
                        snow.y = Math.random()*h;
                        snow.x = CENTER.x + (Math.random()-0.5)*(30 + snow.y / 2);
                        snow.vx = Math.random() -0.5;
                        snow.vy = Math.random()-1;
                    }
                }
            }
            _canvas.colorTransform( _canvas.rect, _ctf );
            _canvas.unlock();
            
            _twincles.draw( _canvas, _matrix );
        }
        
        
        public function FlashTest() {
            if( stage ) init();
            else addEventListener( Event.ADDED_TO_STAGE, init );
        }
    }
}


class Palette {
    public static const WHITE:uint = 0xF0F0F0;
    public static const GREEN:uint = 0x008800;
    public static const DARK_GREEN:uint = 0x004400;
    public static const RED:uint = 0xCC0000;
    public static const YELLOW:uint = 0xFFCC00;
    public static const BLACK:uint = 0x101010; 
    public static const COLORS:Array = [ WHITE, GREEN,  RED, YELLOW, GREEN, DARK_GREEN ];
    public static function getColors():Array { return COLORS.slice(); }
}



import flash.display.*;
class ColorMap extends Sprite {
    public function ColorMap(colors:Array) {
        var l:int = colors.length;
        var rect:Sprite;
        for( var i:int=0; i<l; ++i ) {
            addChild( rect = new ColorRect( colors[ i ] ) );
            rect.x =i * ColorRect.WIDTH;
            rect.y =0;
        }
    }
}

class ColorRect extends Sprite {
    public static const WIDTH:int = 140;
    public static const HEIGHT:int = 240;
    public function ColorRect( color:uint ) {
        super();
        graphics.beginFill( color, 1 );
        graphics.drawRect( 0, 0, WIDTH, HEIGHT );
        graphics.endFill();
    }
}


class Snow {
    public var x:Number = 0;
    public var y:Number = 0;
    public var vx:Number = 0;
    public var vy:Number = 0;
    public var color:uint = 0x00;
}