/**
 * Copyright djakarta_trap ( http://wonderfl.net/user/djakarta_trap )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/heHK
 */

// forked from clockmaker's [PV3D] Refrection Cube
// forked from mash's papervision3d simple example (cube)
/**
* ReflectionViewを使った反射バージョン
*/
package {
    import flash.events.*;
    import flash.filters.*;
    import flash.utils.*;
    import org.papervision3d.materials.shadematerials.*;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.core.effects.view.ReflectionView;
    import org.papervision3d.lights.*;
    import org.papervision3d.objects.DisplayObject3D;

    [SWF(frameRate="60")]
    public class Main extends ReflectionView {
        private var cameraRot:Number = 0;

        public function Main() {
            // 立方体を作成します
            var cube:Cube = Cube(scene.addChild(new Cube(new MaterialsList(
            {
                all : new FlatShadeMaterial(new PointLight3D(), 0x2288CC, 0x004466)
            }))));
            cube.z = 1000;
            camera.y = 500;
            camera.target= DisplayObject3D.ZERO;
            camera.zoom = 1;
            camera.focus = 1000/camera.zoom;
            
            // 反射を設定します
            surfaceHeight = -500;
            viewportReflection.filters = [new BlurFilter(8, 8, 2)];
            viewportReflection.alpha = .4;
            
            // アニメーションを設定してます
            addEventListener(Event.ENTER_FRAME,function():void {
                //cube.yaw(2)
                cameraRot += 0.5;
                camera.x = 2000* Math.cos(cameraRot / 180 * Math.PI);
		camera.z = 2000* Math.sin(cameraRot / 180 * Math.PI);
                //camera.y = 500 + 500 * Math.sin(getTimer() / 1000);
                singleRender()
            });
        }
    }
}
