/**
 * Copyright stenpel ( http://wonderfl.net/user/stenpel )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/heDe
 */

package
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.BitmapDataChannel;
	import flash.display.Sprite;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.events.Event;
	import flash.filters.BitmapFilter;
	import flash.filters.BlurFilter;
	import flash.filters.DisplacementMapFilter;
	import flash.filters.DisplacementMapFilterMode;
	import flash.geom.Matrix;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	import flash.media.Camera;
	import flash.media.Video;
	
	public class sampleCamera extends Sprite
	{
		private var camera:Camera;
		private var _video:Video;
		private var _bm:Bitmap;
		private var _bmd:BitmapData;
		private var _noise:BitmapData;
		private var disMap:DisplacementMapFilter;
		
		public function sampleCamera()
		{
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.align = StageAlign.TOP_LEFT;
			
			camera = Camera.getCamera();
			camera.setMode(stage.stageWidth, stage.stageHeight, 15);
			_video = new Video(camera.width, camera.height);
			_video.attachCamera(camera);
			
			_noise = new BitmapData(_video.width, _video.height);
			
			_bmd = new BitmapData(_video.width, _video.height);
			_bm = new Bitmap(_bmd);
			
			disMap = new DisplacementMapFilter();
			disMap.mapBitmap = _noise;
			disMap.componentX = BitmapDataChannel.RED;
			disMap.componentY = BitmapDataChannel.BLUE;
			disMap.scaleX = -100 * Math.random();
			disMap.scaleY = 100 * Math.random();
			disMap.mode = DisplacementMapFilterMode.CLAMP;
			
			this.addChild(_bm);
			this.addEventListener(Event.ENTER_FRAME, loop);
		}
		
		private function loop(e:Event):void {
			_noise.perlinNoise(_video.width, _video.height, 4, 100*Math.random(), true, true);	
			_bmd.draw(_video);
			_bmd.applyFilter(_bmd, new Rectangle(0,0,_video.width, _video.height), new Point(), disMap);
		}
	}
}