/**
 * Copyright Dan_Po ( http://wonderfl.net/user/Dan_Po )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hdtj
 */

package
{
    import flash.display.Stage;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.filters.BlurFilter;
    import flash.geom.Point;
    
    /**
     * ...
     * @author DanPo
     */
    public class BitmapDataParticlesTest1 extends Sprite 
    {
        private const numParticle:uint = 2000;
        private var bitmap:Bitmap = new Bitmap();
        private var bitmapData:BitmapData;
        private var particleList:Vector.<Particle> = new Vector.<Particle>();
        private var filter:BlurFilter = new BlurFilter(1.1, 1.1);
        
        public function BitmapDataParticlesTest1() 
        {
            addChild(bitmap);
            bitmap.scaleX = bitmap.scaleY = 2;
            
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            
            configureStage();
            
            stage.addEventListener(Event.RESIZE, onResize);
            resize();
            
            fillParticleList(numParticle);
            
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
            stage.addEventListener(MouseEvent.CLICK, onStageClick);
        }
        
        private function configureStage():void
        {
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
        }

        
        private function onStageClick(e:MouseEvent):void 
        {
            var i:uint = particleList.length;
            while (i--)
            {
                var particle:Particle = particleList[i];
                resetParticle(particle);
            }
        }
        
        private function resetParticle(particle:Particle):void
        {
            particle.x = bitmapData.width/2;
            particle.y = bitmapData.height/2;
            particle.fx = -1+Math.random()*2;
            particle.fy = -1+Math.random()*2;
        }

        
        private function fillParticleList(numParticle:uint):void
        {
            while (numParticle--)
            {
                var particle:Particle = new Particle();
                resetParticle(particle);
                particle.color = getHUEColor(Math.random() * 360);
                particleList.push(particle);
            }
        }
        
        private function getHUEColor(value:Number):Number
        {
            value = value % 360;
            var n:int = value / 60;
            var k:Number = (value - 60*n)/60;
            var red:int=0;
            var green:int=0;
            var blue:int=0;
            if (n == 0)
            {
                red = 0xFF;
                green = k * 0xFF;
            }
            else if (n == 1)
            {
                green = 0xFF;
                red = (1 - k) * 0xFF;
            }
            else if (n == 2)
            {
                green = 0xFF;
                blue = k * 0xFF;
            }
            else if (n == 3)
            {
                blue = 0xFF;
                green = (1 - k) * 0xFF;
            }
            else if (n == 4)
            {
                blue = 0xFF;
                red = k * 0xff;
            }
            else if (n == 5)
            {
                red = 0xFF;
                blue = (1 - k) * 0xFF;
            }
            else if (value < 0 || value>=360)
            {
                return 0xFF0000;
            }
            return red * 0x10000 + green * 0x100 + blue;
        }
        
        private function onEnterFrame(e:Event):void 
        {
            step();
        }
        
        private function step():void 
        {
            bitmapData.lock();
            
            var i:uint = 0;
            var l:uint = particleList.length;
            while (i < l)
            {
                var particle:Particle = particleList[i];
                particle.x += particle.fx;
                particle.y += particle.fy;
                
                if (particle.x < 0 || particle.x >= bitmapData.width || 
                    particle.y < 0 || particle.y >= bitmapData.height)
                {
                    particle.x = bitmapData.width/2;
                    particle.y = bitmapData.height/2;
                    particle.fx = 0;
                    particle.fy = 0;
                }
                
                bitmapData.setPixel(particle.x, particle.y, particle.color);
                
                particle.fx += -.1+.2*Math.random();
                particle.fy += -.1+.2*Math.random();
                i++;
            }
            bitmapData.applyFilter(bitmapData, bitmapData.rect, new Point(), filter);
            bitmapData.unlock();
        }
        
        
        
        private function onResize(e:Event):void 
        {
            resize();
        }
        
        private function resize():void 
        {
            bitmapData = new BitmapData(stage.stageWidth/2, stage.stageHeight/2, false, 0x000000);
            if (bitmap.bitmapData)
            {
                bitmap.bitmapData.dispose();
            }
            bitmap.bitmapData = bitmapData;
        }
        
    }

}
class Particle
{
    public var x:Number = 0;
    public var y:Number = 0;
    public var fx:Number = 0;
    public var fy:Number = 0;
    public var color:Number = 0xFFFFFF;
}