/**
 * Copyright hemingway ( http://wonderfl.net/user/hemingway )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hdhR
 */

package {
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.events.Event;
    
    [SWF(frameRate=60, width=465, height=465)]
    public class ParticleTest extends Sprite {
        private static const SCENE_BEGIN_X:int = 0;
        private static const SCENE_BEGIN_Y:int = 0;
        private static const SCENE_END_X:int = 465;
        private static const SCENE_END_Y:int = 465;
        
        private var _canvas:Bitmap;
        private var _canvasData:BitmapData;
        private var _occlusionMap:Vector.<Vector.<int>>;
        private var _particle:Vector.<int>;
        private var _frame:int;
        
        public function ParticleTest() {
            this._occlusionMap = new Vector.<Vector.<int>>;
            this._canvasData = new BitmapData(465, 465, false, 0);
            this._canvas = new Bitmap(this._canvasData);
            this._particle = new Vector.<int>(7, true);
            this._particle[0] = 0;
            this._particle[1] = 0;
            this._particle[2] = 5;
            this._particle[3] = 4;
            this._frame = 0;
            
            for (var $x:int=0; $x < 465; $x++) {
                this._occlusionMap[$x] = new Vector.<int>;
                
                for (var $y:int=0; $y < 465; $y++) {
                    if ($x < 0 || $y < 0 || $x > 465 || $y > 465) {
                        this._occlusionMap[$x][$y] = 0;
                        this._canvasData.setPixel($x, $y, this._occlusionMap[$x][$y]);
                    } else {
                        this._occlusionMap[$x][$y] = 1;   
                    }
                }
            }
            
            this.addChild(this._canvas);
            
            this.addEventListener(Event.ENTER_FRAME, this.enterFrameHandler);
        }
        
        private function enterFrameHandler($event:Event) :void {
            this._frame++;
            
            this._canvasData.setPixel(this._particle[0], this._particle[1], 0xFFFFFF);
                
            if (!checkVerticalCollision(this._particle)) {
                this._particle[3] = ~(this._particle[3]-1);
            }
                    
            if (!checkHorizontalCollision(this._particle)) {
                this._particle[2] = ~(this._particle[2]-1);
            }
            
            this._particle[0] += this._particle[2];
            this._particle[1] += this._particle[3];
        }
        
        private function checkHorizontalCollision($particle:Vector.<int>) :Boolean {
            var $return:Boolean = false;
            
            if (($particle[0]+$particle[2]) > SCENE_BEGIN_X && ($particle[0]+$particle[2]) < SCENE_END_X) {
                if (this._occlusionMap[$particle[0]+$particle[2]][$particle[1]]) {
                    $return = true;
                }
            }
            
            return $return;
        }
        
        private function checkVerticalCollision($particle:Vector.<int>) :Boolean {
            var $return:Boolean = false;
            
            if (($particle[1]+$particle[3]) > SCENE_BEGIN_Y && ($particle[1]+$particle[3]) < SCENE_END_Y) {
                if (this._occlusionMap[$particle[0]][$particle[1]+$particle[3]]) {
                    $return = true;
                }    
            }
            
            return $return;
        }
    }
}