/**
 * Copyright zahir ( http://wonderfl.net/user/zahir )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hdYK
 */

package{
	import flash.display.Bitmap;
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.IOErrorEvent;
	import flash.events.ProgressEvent;
	import flash.events.SecurityErrorEvent;
	import flash.filters.DropShadowFilter;
	import flash.net.URLLoader;
	import flash.net.URLRequest;
	import flash.system.LoaderContext;
	import flash.system.Security;
	import flash.text.TextField;
	import flash.utils.ByteArray;
	
	[SWF(backgroundColor="#999999", frameRate=30)]

	public class LaodZip extends Sprite{
		private const policy:String = "http://zahir.coresv.com/zahir/crossdomain.xml";
		private const url:String  = "http://zahir.coresv.com/zahir/img.zip";
		private const IMG:Array = ["jpg","jpeg", "gif", "png"];
		
		private var l:URLLoader;
		private var t:TextField;
		private var zip:Zip;
		
		private var num:int = 0;
		
		public function LaodZip(){
			Security.loadPolicyFile( policy );
			
			t = new TextField();
			t.width = t.height = 465;
			addChild(t);
			
			l = new URLLoader();
			l.addEventListener(Event.COMPLETE, onComp);
			l.addEventListener(ProgressEvent.PROGRESS, onProg);
			l.addEventListener(IOErrorEvent.IO_ERROR, onIOErr);
			l.addEventListener(SecurityErrorEvent.SECURITY_ERROR, onSCRTYErr);
			
			l.dataFormat = "binary";
			var lc:LoaderContext = new LoaderContext(true);
			
			
			var req:URLRequest = new URLRequest( url );
			l.load( req );
		}
		private function onComp(e:Event):void{
			l.removeEventListener(Event.COMPLETE, onComp);
			l.removeEventListener(ProgressEvent.PROGRESS, onProg);
			l.removeEventListener(IOErrorEvent.IO_ERROR, onIOErr);
			l.removeEventListener(SecurityErrorEvent.SECURITY_ERROR, onSCRTYErr);
			t.text = "Complete !!"
			
			zip = new Zip();
			zip.addEventListener( Event.COMPLETE, zipComp);
			zip.read( l.data );
		}
		private function zipComp(e:Event):void{
			var arr:Array = zip.getfiles();
			for(var i:int =0, len:int = arr.length; i<len; i++){
				if( check( arr[i].name ) ){
					loadImg( arr[i].data );
				}
			}
		}
		private function check( fileName:String ):Boolean{
			var len:int = IMG.length;
			for(var i:int = 0; i<len; i++){
				var extension:String = IMG[i];
				var target:String = fileName.substr(fileName.length - extension.length, fileName.length);
				if(new RegExp(extension, "i").test( target ) ) return true;
			}
			return false;
		}
		private function loadImg( data:ByteArray ):void{
			var _l:Loader = new Loader();
			_l.contentLoaderInfo.addEventListener(Event.INIT, function(e:Event):void{
				_l.width = 50;
				_l.scaleY = _l.scaleX;
				
				_l.x = 60 * num + 10;
				_l.y = 30;
				_l.filters = [new DropShadowFilter(5,45,0,0.8)];
				
				if(_l.content is Bitmap) addChild( _l );
				
				num++;
			});
			_l.loadBytes( data );
		}
		private function onProg(e:ProgressEvent):void{
			t.text = String( e.bytesLoaded / e.bytesTotal ) + "%";
		}
		private function onIOErr(e:IOErrorEvent):void{
			t.text = "IO Error !!";
		}
		private function onSCRTYErr(e:SecurityErrorEvent):void{
			t.text = "Security Error !!";
		}
	}
}
	import flash.events.EventDispatcher;
	import flash.events.Event;
	import flash.utils.IDataInput;
	import flash.utils.ByteArray;
	

class Zip extends EventDispatcher{
	
	private const SIGNATURE:uint = 0x04034b50;
	
	private var src:ByteArray;
	private var files:Array = [];
	
	public function Zip(){}
	
	public function read( data:IDataInput ):void{
		src = new ByteArray();
		data.readBytes( src );
		src.endian = "littleEndian";
		
		addEventListener( "read", reading );
		reading();
	}
	private function reading( e:Event = null ):void{
		var signature:uint;
		var compression:int;
		var offset:uint;
		var fileNameLength:uint;
		var exFieldLength:uint;
		var fileName:String = "";
		var compSize:uint;
		var uncompSize:uint;
		
		signature = src.readInt();
		if( signature !== SIGNATURE ){
				src.clear();
				readComplete();
				return;
		}
		src.position += 4;
		
		compression = src.readUnsignedShort();
		
		src.position += 8;
		
		compSize = src.readUnsignedInt();
		uncompSize = src.readUnsignedInt();
		fileNameLength = src.readUnsignedShort();
		exFieldLength = src.readUnsignedShort();
		
		var entry:Entry = new Entry();
		
		entry.name = src.readUTFBytes( fileNameLength );
		entry.exField = src.readUTFBytes( exFieldLength );
		
		if(compSize){
			var b:ByteArray = new ByteArray();
			src.readBytes( b, 0, compSize );
			if(compression == 8) b.inflate();
			entry.data = b;
			
			files[files.length] = entry;
		}
		
		dispatchEvent( new Event("read") );
	}
	private function readComplete():void{
		removeEventListener("read", reading );
		dispatchEvent( new Event(Event.COMPLETE) );
	}
	public function getfiles():Array{
		return files;
	}
}

class Entry{
	public var name:String = "";
	public var data:ByteArray;
	public var exField:*;
}