/**
 * Copyright codeonwort ( http://wonderfl.net/user/codeonwort )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hdGB
 */

// forked from codeonwort's perlin noise xor
package {
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.events.Event;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        private const W:int = 465
        private const H:int = 465
        private var src1:BitmapData, src2:BitmapData
        private var bd:BitmapData, temp:BitmapData
        private var x0:Number = 0, y0:Number = 0, t0:Number = 0
        private var x1:Number = 0, y1:Number = 0, t1:Number = 0
        private const zero:Point = new Point
        public function FlashTest() {
            //var c:uint
            //for(var i:int=0; i<bd.width; i++){
                //for(var j:int=0; j<bd.height; j++){
                    //c = bd.getPixel(i, j) ^ bd2.getPixel(i, j)
                    //bd.setPixel(i, j, c)
                //}
            //}
            
            bd = new BitmapData(W, H, false)
            temp = bd.clone()
            
            src1 = new BitmapData(W+W, H+H, false)
            src2 = new BitmapData(W+W, H+H, false)
            generate()
            
            addChild(new Bitmap(bd))
            addEventListener("enterFrame", loop)
            stage.addEventListener("mouseDown", function($:Event):void { generate() })
        }
        private function generate():void {
            var scalex0:Number = 1 + Math.random() * 3
            var scaley0:Number = 1 + Math.random() * 3
            temp.perlinNoise(W/scalex0, H/scaley0, 6, Math.random() * 12321, true, true)
            src1.copyPixels(temp, temp.rect, new Point(0, 0))
            src1.copyPixels(temp, temp.rect, new Point(W, 0))
            src1.copyPixels(temp, temp.rect, new Point(0, H))
            src1.copyPixels(temp, temp.rect, new Point(W, H))
            
            var scalex1:Number = 1 + Math.random() * 3
            var scaley1:Number = 1 + Math.random() * 3
            temp.perlinNoise(W/scalex1, H/scaley1, 6, Math.random() * 12321, true, true)
            src2.copyPixels(temp, temp.rect, new Point(0, 0))
            src2.copyPixels(temp, temp.rect, new Point(W, 0))
            src2.copyPixels(temp, temp.rect, new Point(0, H))
            src2.copyPixels(temp, temp.rect, new Point(W, H))
        }
        private function loop(e:Event):void {
            t0 += (Math.random() - .5) / 5
            x0 += 5 * Math.cos(t0)
            y0 += 5 * Math.sin(t0)
            if(x0 >= W) x0 -= W
            else if(x0 < 0) x0 += W
            if(y0 >= H) y0 -= H
            else if(y0 < 0) y0 += H
            
            var dx:Number = mouseX-465/2
            var dy:Number = mouseY-465/2
            var d:Number = Math.sqrt(dx*dx + dy*dy) / 10
            t1 = Math.atan2(dy, dx)
            //t1 += (Math.random() - .5) / 5
            x1 += d * Math.cos(t1)
            y1 += d * Math.sin(t1)
            if(x1 < 0) x1 += W
            else if(x1 >= W) x1 -= W
            if(y1 < 0) y1 += H
            else if(y1 >= H) y1 -= H
            
            bd.copyPixels(src1, new Rectangle(x0, y0, W, H), zero)
            temp.copyPixels(src2, new Rectangle(x1, y1, W, H), zero)
            var vec:Vector.<uint> = bd.getVector(bd.rect)
            var vec2:Vector.<uint> = temp.getVector(temp.rect)
            var len:int = vec.length
            for(var i:int=0; i<len; i++) vec[i] = vec[i] ^ vec2[i]
            bd.setVector(bd.rect, vec)
        }

    }
}