/**
 * Copyright rettuce ( http://wonderfl.net/user/rettuce )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hcjn
 */

package 
{
    import flash.events.*;
    import flash.utils.*;
	import flash.events.TimerEvent;
	import flash.utils.Timer;
	import org.papervision3d.materials.*;
    import org.papervision3d.materials.utils.*;
	import org.papervision3d.objects.primitives.*;
	import org.papervision3d.view.*;
	import flash.display.Stage;
	
	[SWF(width = 465, height = 465, backgroundColor = 0x000000, frameRate = 30)]
	/**
	 * ...wonderfl本　2-10の途中
	 * @author rettuce
	 */
	public class DocumentClass extends BasicView 
	{
		private const PIXEL_NUM       :int    = 10;         //  縦横の枚数   
        private const MAX_RADIUS    :int    = 20000;  // 空間の大きさ
        private const PLANE_SIZE    :int    = 1000;       // パーティクルのサイズ
        private const PLANE_MARGIN  :int    = 100;     // パーティクルの余白
        private var pixelArr        :Array  = [];     // パーティクルを格納する配列
        private var dmyObjs         :Array  = [];     // ダミーの3Dオブジェクト
        private var dmyPixels       :Array  = [];     // ダミーの3Dピクセル
        private var index           :int    = 0;      // 形状のインデックス番号
		
		public function DocumentClass()
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);		
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			main();
		}
		
		private function main():void
		{
			// カメラの位置
            camera.z = -MAX_RADIUS;
			
			// 7秒毎のタイマーセット
			var timer:Timer = new Timer(7000);
			timer.addEventListener(TimerEvent.TIMER, loop);
			timer.start();
			
			// 初期化
			initSet();
			
			// モーションを100ミリ秒遅らせてスタート。直後だと座標取得ができないらしい。
			setTimeout(loop, 100);
			
			// レンダリング
			startRendering();
		}
		
		private function initSet():void
		{
			// 空間生成
			var wireMaterial:WireframeMaterial = new WireframeMaterial(0xFF0000);
			wireMaterial.opposite = true;
			
			var cube:Cube = new Cube(
                new MaterialsList( { all:wireMaterial } ),
                MAX_RADIUS, MAX_RADIUS, MAX_RADIUS,
                5, 5, 5);
            scene.addChild(cube);
			
			// パーティクル生成
			var material:ColorMaterial = new ColorMaterial(0xFFFFFF);
			material.doubleSided = true;
			
			pixelArr = [];
			
			for ( var i:int = 0; i < PIXEL_NUM; i++ )
			{
				pixelArr[i] = [];
				for (var m:int = 0; m < PIXEL_NUM; m++ )
				{
					var o:Plane = new Plane(material, PLANE_SIZE, PLANE_SIZE);
					scene.addChild(o);
					pixelArr[i][m] = o;
					
					o.x = (i * PLANE_SIZE) + (i * PLANE_MARGIN);
					o.y = (m * PLANE_SIZE) + (m * PLANE_MARGIN);
					o.z = PLANE_SIZE*2 * Math.random();
				}
			}
		}
		
		private function loop(e:TimerEvent):void
		{
			
		}
		
	}
}



