/**
 * Copyright milchreis ( http://wonderfl.net/user/milchreis )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hbK3
 */

// forked from vianty's drag drop
package 
{
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    import flash.display.Sprite;
    
    public class DragAndDropExample extends Sprite 
    {
        public function DragAndDropExample() 
        {
            // A: adding functionality via methods in this class
            var externallyAddedDragAndDrop:Box = new Box(50, 50, 0xff0000);                                
            externallyAddedDragAndDrop.x = 30;
            externallyAddedDragAndDrop.y = 30;
            externallyAddedDragAndDrop.addEventListener(MouseEvent.MOUSE_DOWN, drag);
            externallyAddedDragAndDrop.addEventListener(MouseEvent.MOUSE_UP, drop);
            addChild(externallyAddedDragAndDrop);
            
            // B: moving methods of A to util class with purely static methods
            var dragAndDropViaObserver:Box = new Box(80, 30, 0x00ff00);                                
            dragAndDropViaObserver.x = 30;
            dragAndDropViaObserver.y = 100;
            DragAndDropObserver.addTarget(dragAndDropViaObserver);
            addChild(dragAndDropViaObserver);
            
            // C: new Box class that adds itself to the observer of B
            var dragAndDropViaInternalObserver:DraggableBox = new DraggableBox(100, 20, 0x0000ff);                                
            dragAndDropViaInternalObserver.x = 30;
            dragAndDropViaInternalObserver.y = 170;
            addChild(dragAndDropViaInternalObserver);
        }
        
        public function drag(e:MouseEvent):void
        {
            e.currentTarget.startDrag();
        }
        
        public function drop(e:MouseEvent):void
        {
            stopDrag();
        }
    }
}

import flash.events.MouseEvent;
import flash.events.IEventDispatcher;

import flash.display.Sprite;
import flash.display.JointStyle;
import flash.display.CapsStyle;
import flash.display.LineScaleMode;

internal class Box extends Sprite  // R.I.P. MovieClip
{
    public function Box(width:Number = 100, height:Number = 100, color:uint = 0)
    {
        buttonMode = true;
        
        graphics.beginFill(0xffffff);
        graphics.lineStyle(5, color, 1, true, LineScaleMode.NORMAL, CapsStyle.ROUND, JointStyle.ROUND);
        graphics.drawRect(0, 0, width, height);
        
        graphics.beginFill(color);
        graphics.lineStyle(2, color, 1, false, LineScaleMode.NORMAL, CapsStyle.ROUND, JointStyle.ROUND);
        graphics.drawRect(6, 6, width - 11, height - 11);
        
        graphics.endFill();
    }
}

internal class DragAndDropObserver
{
    public static function addTarget(target:IEventDispatcher):void
    {
        target.addEventListener(MouseEvent.MOUSE_DOWN, drag, false, 0, true);
        target.addEventListener(MouseEvent.MOUSE_UP, drop, false, 0, true);
    }
    
    private static function drag(e:MouseEvent):void
    {
        e.currentTarget.startDrag();
    }
    
    private static function drop(e:MouseEvent):void
    {
        e.currentTarget.stopDrag();
    } 
}

internal class DraggableBox extends Box
{
    public function DraggableBox(width:Number = 100, height:Number = 100, color:uint = 0)
    {
        super(width, height, color);
        
        DragAndDropObserver.addTarget(this);
    }
}


